/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatus;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientVpnConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientVpnConnection> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpnEndpointId").getter(ClientVpnConnection.getter(ClientVpnConnection::clientVpnEndpointId)).setter(ClientVpnConnection.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("clientVpnEndpointId").build()}).build();
    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timestamp").getter(ClientVpnConnection.getter(ClientVpnConnection::timestamp)).setter(ClientVpnConnection.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").unmarshallLocationName("timestamp").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionId").getter(ClientVpnConnection.getter(ClientVpnConnection::connectionId)).setter(ClientVpnConnection.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").unmarshallLocationName("connectionId").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(ClientVpnConnection.getter(ClientVpnConnection::username)).setter(ClientVpnConnection.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").unmarshallLocationName("username").build()}).build();
    private static final SdkField<String> CONNECTION_ESTABLISHED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionEstablishedTime").getter(ClientVpnConnection.getter(ClientVpnConnection::connectionEstablishedTime)).setter(ClientVpnConnection.setter(Builder::connectionEstablishedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionEstablishedTime").unmarshallLocationName("connectionEstablishedTime").build()}).build();
    private static final SdkField<String> INGRESS_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressBytes").getter(ClientVpnConnection.getter(ClientVpnConnection::ingressBytes)).setter(ClientVpnConnection.setter(Builder::ingressBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressBytes").unmarshallLocationName("ingressBytes").build()}).build();
    private static final SdkField<String> EGRESS_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EgressBytes").getter(ClientVpnConnection.getter(ClientVpnConnection::egressBytes)).setter(ClientVpnConnection.setter(Builder::egressBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressBytes").unmarshallLocationName("egressBytes").build()}).build();
    private static final SdkField<String> INGRESS_PACKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPackets").getter(ClientVpnConnection.getter(ClientVpnConnection::ingressPackets)).setter(ClientVpnConnection.setter(Builder::ingressPackets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPackets").unmarshallLocationName("ingressPackets").build()}).build();
    private static final SdkField<String> EGRESS_PACKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EgressPackets").getter(ClientVpnConnection.getter(ClientVpnConnection::egressPackets)).setter(ClientVpnConnection.setter(Builder::egressPackets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressPackets").unmarshallLocationName("egressPackets").build()}).build();
    private static final SdkField<String> CLIENT_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientIp").getter(ClientVpnConnection.getter(ClientVpnConnection::clientIp)).setter(ClientVpnConnection.setter(Builder::clientIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIp").unmarshallLocationName("clientIp").build()}).build();
    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommonName").getter(ClientVpnConnection.getter(ClientVpnConnection::commonName)).setter(ClientVpnConnection.setter(Builder::commonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName").unmarshallLocationName("commonName").build()}).build();
    private static final SdkField<ClientVpnConnectionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(ClientVpnConnection.getter(ClientVpnConnection::status)).setter(ClientVpnConnection.setter(Builder::status)).constructor(ClientVpnConnectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> CONNECTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionEndTime").getter(ClientVpnConnection.getter(ClientVpnConnection::connectionEndTime)).setter(ClientVpnConnection.setter(Builder::connectionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionEndTime").unmarshallLocationName("connectionEndTime").build()}).build();
    private static final SdkField<List<String>> POSTURE_COMPLIANCE_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PostureComplianceStatuses").getter(ClientVpnConnection.getter(ClientVpnConnection::postureComplianceStatuses)).setter(ClientVpnConnection.setter(Builder::postureComplianceStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostureComplianceStatusSet").unmarshallLocationName("postureComplianceStatusSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, TIMESTAMP_FIELD, CONNECTION_ID_FIELD, USERNAME_FIELD, CONNECTION_ESTABLISHED_TIME_FIELD, INGRESS_BYTES_FIELD, EGRESS_BYTES_FIELD, INGRESS_PACKETS_FIELD, EGRESS_PACKETS_FIELD, CLIENT_IP_FIELD, COMMON_NAME_FIELD, STATUS_FIELD, CONNECTION_END_TIME_FIELD, POSTURE_COMPLIANCE_STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClientVpnConnection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientVpnEndpointId;
    private final String timestamp;
    private final String connectionId;
    private final String username;
    private final String connectionEstablishedTime;
    private final String ingressBytes;
    private final String egressBytes;
    private final String ingressPackets;
    private final String egressPackets;
    private final String clientIp;
    private final String commonName;
    private final ClientVpnConnectionStatus status;
    private final String connectionEndTime;
    private final List<String> postureComplianceStatuses;

    private ClientVpnConnection(BuilderImpl builder) {
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.timestamp = builder.timestamp;
        this.connectionId = builder.connectionId;
        this.username = builder.username;
        this.connectionEstablishedTime = builder.connectionEstablishedTime;
        this.ingressBytes = builder.ingressBytes;
        this.egressBytes = builder.egressBytes;
        this.ingressPackets = builder.ingressPackets;
        this.egressPackets = builder.egressPackets;
        this.clientIp = builder.clientIp;
        this.commonName = builder.commonName;
        this.status = builder.status;
        this.connectionEndTime = builder.connectionEndTime;
        this.postureComplianceStatuses = builder.postureComplianceStatuses;
    }

    public final String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public final String timestamp() {
        return this.timestamp;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String username() {
        return this.username;
    }

    public final String connectionEstablishedTime() {
        return this.connectionEstablishedTime;
    }

    public final String ingressBytes() {
        return this.ingressBytes;
    }

    public final String egressBytes() {
        return this.egressBytes;
    }

    public final String ingressPackets() {
        return this.ingressPackets;
    }

    public final String egressPackets() {
        return this.egressPackets;
    }

    public final String clientIp() {
        return this.clientIp;
    }

    public final String commonName() {
        return this.commonName;
    }

    public final ClientVpnConnectionStatus status() {
        return this.status;
    }

    public final String connectionEndTime() {
        return this.connectionEndTime;
    }

    public final boolean hasPostureComplianceStatuses() {
        return this.postureComplianceStatuses != null && !(this.postureComplianceStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> postureComplianceStatuses() {
        return this.postureComplianceStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionEstablishedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPackets());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressPackets());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPostureComplianceStatuses() ? this.postureComplianceStatuses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnConnection)) {
            return false;
        }
        ClientVpnConnection other = (ClientVpnConnection)obj;
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.connectionEstablishedTime(), other.connectionEstablishedTime()) && Objects.equals(this.ingressBytes(), other.ingressBytes()) && Objects.equals(this.egressBytes(), other.egressBytes()) && Objects.equals(this.ingressPackets(), other.ingressPackets()) && Objects.equals(this.egressPackets(), other.egressPackets()) && Objects.equals(this.clientIp(), other.clientIp()) && Objects.equals(this.commonName(), other.commonName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.connectionEndTime(), other.connectionEndTime()) && this.hasPostureComplianceStatuses() == other.hasPostureComplianceStatuses() && Objects.equals(this.postureComplianceStatuses(), other.postureComplianceStatuses());
    }

    public final String toString() {
        return ToString.builder((String)"ClientVpnConnection").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("Timestamp", (Object)this.timestamp()).add("ConnectionId", (Object)this.connectionId()).add("Username", (Object)this.username()).add("ConnectionEstablishedTime", (Object)this.connectionEstablishedTime()).add("IngressBytes", (Object)this.ingressBytes()).add("EgressBytes", (Object)this.egressBytes()).add("IngressPackets", (Object)this.ingressPackets()).add("EgressPackets", (Object)this.egressPackets()).add("ClientIp", (Object)this.clientIp()).add("CommonName", (Object)this.commonName()).add("Status", (Object)this.status()).add("ConnectionEndTime", (Object)this.connectionEndTime()).add("PostureComplianceStatuses", this.hasPostureComplianceStatuses() ? this.postureComplianceStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "ConnectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "ConnectionEstablishedTime": {
                return Optional.ofNullable(clazz.cast(this.connectionEstablishedTime()));
            }
            case "IngressBytes": {
                return Optional.ofNullable(clazz.cast(this.ingressBytes()));
            }
            case "EgressBytes": {
                return Optional.ofNullable(clazz.cast(this.egressBytes()));
            }
            case "IngressPackets": {
                return Optional.ofNullable(clazz.cast(this.ingressPackets()));
            }
            case "EgressPackets": {
                return Optional.ofNullable(clazz.cast(this.egressPackets()));
            }
            case "ClientIp": {
                return Optional.ofNullable(clazz.cast(this.clientIp()));
            }
            case "CommonName": {
                return Optional.ofNullable(clazz.cast(this.commonName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ConnectionEndTime": {
                return Optional.ofNullable(clazz.cast(this.connectionEndTime()));
            }
            case "PostureComplianceStatuses": {
                return Optional.ofNullable(clazz.cast(this.postureComplianceStatuses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientVpnEndpointId", CLIENT_VPN_ENDPOINT_ID_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("ConnectionId", CONNECTION_ID_FIELD);
        map.put("Username", USERNAME_FIELD);
        map.put("ConnectionEstablishedTime", CONNECTION_ESTABLISHED_TIME_FIELD);
        map.put("IngressBytes", INGRESS_BYTES_FIELD);
        map.put("EgressBytes", EGRESS_BYTES_FIELD);
        map.put("IngressPackets", INGRESS_PACKETS_FIELD);
        map.put("EgressPackets", EGRESS_PACKETS_FIELD);
        map.put("ClientIp", CLIENT_IP_FIELD);
        map.put("CommonName", COMMON_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ConnectionEndTime", CONNECTION_END_TIME_FIELD);
        map.put("PostureComplianceStatusSet", POSTURE_COMPLIANCE_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnConnection, T> g) {
        return obj -> g.apply((ClientVpnConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String timestamp;
        private String connectionId;
        private String username;
        private String connectionEstablishedTime;
        private String ingressBytes;
        private String egressBytes;
        private String ingressPackets;
        private String egressPackets;
        private String clientIp;
        private String commonName;
        private ClientVpnConnectionStatus status;
        private String connectionEndTime;
        private List<String> postureComplianceStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnConnection model) {
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.timestamp(model.timestamp);
            this.connectionId(model.connectionId);
            this.username(model.username);
            this.connectionEstablishedTime(model.connectionEstablishedTime);
            this.ingressBytes(model.ingressBytes);
            this.egressBytes(model.egressBytes);
            this.ingressPackets(model.ingressPackets);
            this.egressPackets(model.egressPackets);
            this.clientIp(model.clientIp);
            this.commonName(model.commonName);
            this.status(model.status);
            this.connectionEndTime(model.connectionEndTime);
            this.postureComplianceStatuses(model.postureComplianceStatuses);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getConnectionEstablishedTime() {
            return this.connectionEstablishedTime;
        }

        public final void setConnectionEstablishedTime(String connectionEstablishedTime) {
            this.connectionEstablishedTime = connectionEstablishedTime;
        }

        @Override
        public final Builder connectionEstablishedTime(String connectionEstablishedTime) {
            this.connectionEstablishedTime = connectionEstablishedTime;
            return this;
        }

        public final String getIngressBytes() {
            return this.ingressBytes;
        }

        public final void setIngressBytes(String ingressBytes) {
            this.ingressBytes = ingressBytes;
        }

        @Override
        public final Builder ingressBytes(String ingressBytes) {
            this.ingressBytes = ingressBytes;
            return this;
        }

        public final String getEgressBytes() {
            return this.egressBytes;
        }

        public final void setEgressBytes(String egressBytes) {
            this.egressBytes = egressBytes;
        }

        @Override
        public final Builder egressBytes(String egressBytes) {
            this.egressBytes = egressBytes;
            return this;
        }

        public final String getIngressPackets() {
            return this.ingressPackets;
        }

        public final void setIngressPackets(String ingressPackets) {
            this.ingressPackets = ingressPackets;
        }

        @Override
        public final Builder ingressPackets(String ingressPackets) {
            this.ingressPackets = ingressPackets;
            return this;
        }

        public final String getEgressPackets() {
            return this.egressPackets;
        }

        public final void setEgressPackets(String egressPackets) {
            this.egressPackets = egressPackets;
        }

        @Override
        public final Builder egressPackets(String egressPackets) {
            this.egressPackets = egressPackets;
            return this;
        }

        public final String getClientIp() {
            return this.clientIp;
        }

        public final void setClientIp(String clientIp) {
            this.clientIp = clientIp;
        }

        @Override
        public final Builder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        public final String getCommonName() {
            return this.commonName;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final ClientVpnConnectionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ClientVpnConnectionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ClientVpnConnectionStatus status) {
            this.status = status;
            return this;
        }

        public final String getConnectionEndTime() {
            return this.connectionEndTime;
        }

        public final void setConnectionEndTime(String connectionEndTime) {
            this.connectionEndTime = connectionEndTime;
        }

        @Override
        public final Builder connectionEndTime(String connectionEndTime) {
            this.connectionEndTime = connectionEndTime;
            return this;
        }

        public final Collection<String> getPostureComplianceStatuses() {
            if (this.postureComplianceStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.postureComplianceStatuses;
        }

        public final void setPostureComplianceStatuses(Collection<String> postureComplianceStatuses) {
            this.postureComplianceStatuses = ValueStringListCopier.copy(postureComplianceStatuses);
        }

        @Override
        public final Builder postureComplianceStatuses(Collection<String> postureComplianceStatuses) {
            this.postureComplianceStatuses = ValueStringListCopier.copy(postureComplianceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postureComplianceStatuses(String ... postureComplianceStatuses) {
            this.postureComplianceStatuses(Arrays.asList(postureComplianceStatuses));
            return this;
        }

        public ClientVpnConnection build() {
            return new ClientVpnConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientVpnConnection> {
        public Builder clientVpnEndpointId(String var1);

        public Builder timestamp(String var1);

        public Builder connectionId(String var1);

        public Builder username(String var1);

        public Builder connectionEstablishedTime(String var1);

        public Builder ingressBytes(String var1);

        public Builder egressBytes(String var1);

        public Builder ingressPackets(String var1);

        public Builder egressPackets(String var1);

        public Builder clientIp(String var1);

        public Builder commonName(String var1);

        public Builder status(ClientVpnConnectionStatus var1);

        default public Builder status(Consumer<ClientVpnConnectionStatus.Builder> status) {
            return this.status((ClientVpnConnectionStatus)((ClientVpnConnectionStatus.Builder)ClientVpnConnectionStatus.builder().applyMutation(status)).build());
        }

        public Builder connectionEndTime(String var1);

        public Builder postureComplianceStatuses(Collection<String> var1);

        public Builder postureComplianceStatuses(String ... var1);
    }
}

