/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue;
import software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue;
import software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue;
import software.amazon.awssdk.services.ec2.model.DnsSupportValue;
import software.amazon.awssdk.services.ec2.model.MulticastSupportValue;
import software.amazon.awssdk.services.ec2.model.SecurityGroupReferencingSupportValue;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayOptions> {
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AmazonSideAsn").getter(TransitGatewayOptions.getter(TransitGatewayOptions::amazonSideAsn)).setter(TransitGatewayOptions.setter(Builder::amazonSideAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn").unmarshallLocationName("amazonSideAsn").build()}).build();
    private static final SdkField<List<String>> TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayCidrBlocks").getter(TransitGatewayOptions.getter(TransitGatewayOptions::transitGatewayCidrBlocks)).setter(TransitGatewayOptions.setter(Builder::transitGatewayCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayCidrBlocks").unmarshallLocationName("transitGatewayCidrBlocks").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoAcceptSharedAttachments").getter(TransitGatewayOptions.getter(TransitGatewayOptions::autoAcceptSharedAttachmentsAsString)).setter(TransitGatewayOptions.setter(Builder::autoAcceptSharedAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAttachments").unmarshallLocationName("autoAcceptSharedAttachments").build()}).build();
    private static final SdkField<String> DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRouteTableAssociation").getter(TransitGatewayOptions.getter(TransitGatewayOptions::defaultRouteTableAssociationAsString)).setter(TransitGatewayOptions.setter(Builder::defaultRouteTableAssociation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTableAssociation").unmarshallLocationName("defaultRouteTableAssociation").build()}).build();
    private static final SdkField<String> ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationDefaultRouteTableId").getter(TransitGatewayOptions.getter(TransitGatewayOptions::associationDefaultRouteTableId)).setter(TransitGatewayOptions.setter(Builder::associationDefaultRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDefaultRouteTableId").unmarshallLocationName("associationDefaultRouteTableId").build()}).build();
    private static final SdkField<String> DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRouteTablePropagation").getter(TransitGatewayOptions.getter(TransitGatewayOptions::defaultRouteTablePropagationAsString)).setter(TransitGatewayOptions.setter(Builder::defaultRouteTablePropagation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTablePropagation").unmarshallLocationName("defaultRouteTablePropagation").build()}).build();
    private static final SdkField<String> PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropagationDefaultRouteTableId").getter(TransitGatewayOptions.getter(TransitGatewayOptions::propagationDefaultRouteTableId)).setter(TransitGatewayOptions.setter(Builder::propagationDefaultRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagationDefaultRouteTableId").unmarshallLocationName("propagationDefaultRouteTableId").build()}).build();
    private static final SdkField<String> VPN_ECMP_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnEcmpSupport").getter(TransitGatewayOptions.getter(TransitGatewayOptions::vpnEcmpSupportAsString)).setter(TransitGatewayOptions.setter(Builder::vpnEcmpSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnEcmpSupport").unmarshallLocationName("vpnEcmpSupport").build()}).build();
    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsSupport").getter(TransitGatewayOptions.getter(TransitGatewayOptions::dnsSupportAsString)).setter(TransitGatewayOptions.setter(Builder::dnsSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport").unmarshallLocationName("dnsSupport").build()}).build();
    private static final SdkField<String> SECURITY_GROUP_REFERENCING_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityGroupReferencingSupport").getter(TransitGatewayOptions.getter(TransitGatewayOptions::securityGroupReferencingSupportAsString)).setter(TransitGatewayOptions.setter(Builder::securityGroupReferencingSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupReferencingSupport").unmarshallLocationName("securityGroupReferencingSupport").build()}).build();
    private static final SdkField<String> MULTICAST_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MulticastSupport").getter(TransitGatewayOptions.getter(TransitGatewayOptions::multicastSupportAsString)).setter(TransitGatewayOptions.setter(Builder::multicastSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastSupport").unmarshallLocationName("multicastSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_SIDE_ASN_FIELD, TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD, AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD, DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD, ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD, DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD, PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD, VPN_ECMP_SUPPORT_FIELD, DNS_SUPPORT_FIELD, SECURITY_GROUP_REFERENCING_SUPPORT_FIELD, MULTICAST_SUPPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long amazonSideAsn;
    private final List<String> transitGatewayCidrBlocks;
    private final String autoAcceptSharedAttachments;
    private final String defaultRouteTableAssociation;
    private final String associationDefaultRouteTableId;
    private final String defaultRouteTablePropagation;
    private final String propagationDefaultRouteTableId;
    private final String vpnEcmpSupport;
    private final String dnsSupport;
    private final String securityGroupReferencingSupport;
    private final String multicastSupport;

    private TransitGatewayOptions(BuilderImpl builder) {
        this.amazonSideAsn = builder.amazonSideAsn;
        this.transitGatewayCidrBlocks = builder.transitGatewayCidrBlocks;
        this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
        this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
        this.associationDefaultRouteTableId = builder.associationDefaultRouteTableId;
        this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
        this.propagationDefaultRouteTableId = builder.propagationDefaultRouteTableId;
        this.vpnEcmpSupport = builder.vpnEcmpSupport;
        this.dnsSupport = builder.dnsSupport;
        this.securityGroupReferencingSupport = builder.securityGroupReferencingSupport;
        this.multicastSupport = builder.multicastSupport;
    }

    public final Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public final boolean hasTransitGatewayCidrBlocks() {
        return this.transitGatewayCidrBlocks != null && !(this.transitGatewayCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> transitGatewayCidrBlocks() {
        return this.transitGatewayCidrBlocks;
    }

    public final AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments() {
        return AutoAcceptSharedAttachmentsValue.fromValue(this.autoAcceptSharedAttachments);
    }

    public final String autoAcceptSharedAttachmentsAsString() {
        return this.autoAcceptSharedAttachments;
    }

    public final DefaultRouteTableAssociationValue defaultRouteTableAssociation() {
        return DefaultRouteTableAssociationValue.fromValue(this.defaultRouteTableAssociation);
    }

    public final String defaultRouteTableAssociationAsString() {
        return this.defaultRouteTableAssociation;
    }

    public final String associationDefaultRouteTableId() {
        return this.associationDefaultRouteTableId;
    }

    public final DefaultRouteTablePropagationValue defaultRouteTablePropagation() {
        return DefaultRouteTablePropagationValue.fromValue(this.defaultRouteTablePropagation);
    }

    public final String defaultRouteTablePropagationAsString() {
        return this.defaultRouteTablePropagation;
    }

    public final String propagationDefaultRouteTableId() {
        return this.propagationDefaultRouteTableId;
    }

    public final VpnEcmpSupportValue vpnEcmpSupport() {
        return VpnEcmpSupportValue.fromValue(this.vpnEcmpSupport);
    }

    public final String vpnEcmpSupportAsString() {
        return this.vpnEcmpSupport;
    }

    public final DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(this.dnsSupport);
    }

    public final String dnsSupportAsString() {
        return this.dnsSupport;
    }

    public final SecurityGroupReferencingSupportValue securityGroupReferencingSupport() {
        return SecurityGroupReferencingSupportValue.fromValue(this.securityGroupReferencingSupport);
    }

    public final String securityGroupReferencingSupportAsString() {
        return this.securityGroupReferencingSupport;
    }

    public final MulticastSupportValue multicastSupport() {
        return MulticastSupportValue.fromValue(this.multicastSupport);
    }

    public final String multicastSupportAsString() {
        return this.multicastSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayCidrBlocks() ? this.transitGatewayCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAcceptSharedAttachmentsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteTableAssociationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteTablePropagationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnEcmpSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupReferencingSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastSupportAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayOptions)) {
            return false;
        }
        TransitGatewayOptions other = (TransitGatewayOptions)obj;
        return Objects.equals(this.amazonSideAsn(), other.amazonSideAsn()) && this.hasTransitGatewayCidrBlocks() == other.hasTransitGatewayCidrBlocks() && Objects.equals(this.transitGatewayCidrBlocks(), other.transitGatewayCidrBlocks()) && Objects.equals(this.autoAcceptSharedAttachmentsAsString(), other.autoAcceptSharedAttachmentsAsString()) && Objects.equals(this.defaultRouteTableAssociationAsString(), other.defaultRouteTableAssociationAsString()) && Objects.equals(this.associationDefaultRouteTableId(), other.associationDefaultRouteTableId()) && Objects.equals(this.defaultRouteTablePropagationAsString(), other.defaultRouteTablePropagationAsString()) && Objects.equals(this.propagationDefaultRouteTableId(), other.propagationDefaultRouteTableId()) && Objects.equals(this.vpnEcmpSupportAsString(), other.vpnEcmpSupportAsString()) && Objects.equals(this.dnsSupportAsString(), other.dnsSupportAsString()) && Objects.equals(this.securityGroupReferencingSupportAsString(), other.securityGroupReferencingSupportAsString()) && Objects.equals(this.multicastSupportAsString(), other.multicastSupportAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayOptions").add("AmazonSideAsn", (Object)this.amazonSideAsn()).add("TransitGatewayCidrBlocks", this.hasTransitGatewayCidrBlocks() ? this.transitGatewayCidrBlocks() : null).add("AutoAcceptSharedAttachments", (Object)this.autoAcceptSharedAttachmentsAsString()).add("DefaultRouteTableAssociation", (Object)this.defaultRouteTableAssociationAsString()).add("AssociationDefaultRouteTableId", (Object)this.associationDefaultRouteTableId()).add("DefaultRouteTablePropagation", (Object)this.defaultRouteTablePropagationAsString()).add("PropagationDefaultRouteTableId", (Object)this.propagationDefaultRouteTableId()).add("VpnEcmpSupport", (Object)this.vpnEcmpSupportAsString()).add("DnsSupport", (Object)this.dnsSupportAsString()).add("SecurityGroupReferencingSupport", (Object)this.securityGroupReferencingSupportAsString()).add("MulticastSupport", (Object)this.multicastSupportAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
            case "TransitGatewayCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayCidrBlocks()));
            }
            case "AutoAcceptSharedAttachments": {
                return Optional.ofNullable(clazz.cast(this.autoAcceptSharedAttachmentsAsString()));
            }
            case "DefaultRouteTableAssociation": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteTableAssociationAsString()));
            }
            case "AssociationDefaultRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.associationDefaultRouteTableId()));
            }
            case "DefaultRouteTablePropagation": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteTablePropagationAsString()));
            }
            case "PropagationDefaultRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.propagationDefaultRouteTableId()));
            }
            case "VpnEcmpSupport": {
                return Optional.ofNullable(clazz.cast(this.vpnEcmpSupportAsString()));
            }
            case "DnsSupport": {
                return Optional.ofNullable(clazz.cast(this.dnsSupportAsString()));
            }
            case "SecurityGroupReferencingSupport": {
                return Optional.ofNullable(clazz.cast(this.securityGroupReferencingSupportAsString()));
            }
            case "MulticastSupport": {
                return Optional.ofNullable(clazz.cast(this.multicastSupportAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AmazonSideAsn", AMAZON_SIDE_ASN_FIELD);
        map.put("TransitGatewayCidrBlocks", TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD);
        map.put("AutoAcceptSharedAttachments", AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD);
        map.put("DefaultRouteTableAssociation", DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD);
        map.put("AssociationDefaultRouteTableId", ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD);
        map.put("DefaultRouteTablePropagation", DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD);
        map.put("PropagationDefaultRouteTableId", PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD);
        map.put("VpnEcmpSupport", VPN_ECMP_SUPPORT_FIELD);
        map.put("DnsSupport", DNS_SUPPORT_FIELD);
        map.put("SecurityGroupReferencingSupport", SECURITY_GROUP_REFERENCING_SUPPORT_FIELD);
        map.put("MulticastSupport", MULTICAST_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayOptions, T> g) {
        return obj -> g.apply((TransitGatewayOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long amazonSideAsn;
        private List<String> transitGatewayCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private String autoAcceptSharedAttachments;
        private String defaultRouteTableAssociation;
        private String associationDefaultRouteTableId;
        private String defaultRouteTablePropagation;
        private String propagationDefaultRouteTableId;
        private String vpnEcmpSupport;
        private String dnsSupport;
        private String securityGroupReferencingSupport;
        private String multicastSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayOptions model) {
            this.amazonSideAsn(model.amazonSideAsn);
            this.transitGatewayCidrBlocks(model.transitGatewayCidrBlocks);
            this.autoAcceptSharedAttachments(model.autoAcceptSharedAttachments);
            this.defaultRouteTableAssociation(model.defaultRouteTableAssociation);
            this.associationDefaultRouteTableId(model.associationDefaultRouteTableId);
            this.defaultRouteTablePropagation(model.defaultRouteTablePropagation);
            this.propagationDefaultRouteTableId(model.propagationDefaultRouteTableId);
            this.vpnEcmpSupport(model.vpnEcmpSupport);
            this.dnsSupport(model.dnsSupport);
            this.securityGroupReferencingSupport(model.securityGroupReferencingSupport);
            this.multicastSupport(model.multicastSupport);
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final Collection<String> getTransitGatewayCidrBlocks() {
            if (this.transitGatewayCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.transitGatewayCidrBlocks;
        }

        public final void setTransitGatewayCidrBlocks(Collection<String> transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks = ValueStringListCopier.copy(transitGatewayCidrBlocks);
        }

        @Override
        public final Builder transitGatewayCidrBlocks(Collection<String> transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks = ValueStringListCopier.copy(transitGatewayCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayCidrBlocks(String ... transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks(Arrays.asList(transitGatewayCidrBlocks));
            return this;
        }

        public final String getAutoAcceptSharedAttachments() {
            return this.autoAcceptSharedAttachments;
        }

        public final void setAutoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments(autoAcceptSharedAttachments == null ? null : autoAcceptSharedAttachments.toString());
            return this;
        }

        public final String getDefaultRouteTableAssociation() {
            return this.defaultRouteTableAssociation;
        }

        public final void setDefaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
        }

        @Override
        public final Builder defaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        @Override
        public final Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation(defaultRouteTableAssociation == null ? null : defaultRouteTableAssociation.toString());
            return this;
        }

        public final String getAssociationDefaultRouteTableId() {
            return this.associationDefaultRouteTableId;
        }

        public final void setAssociationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
        }

        @Override
        public final Builder associationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
            return this;
        }

        public final String getDefaultRouteTablePropagation() {
            return this.defaultRouteTablePropagation;
        }

        public final void setDefaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
        }

        @Override
        public final Builder defaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        @Override
        public final Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation(defaultRouteTablePropagation == null ? null : defaultRouteTablePropagation.toString());
            return this;
        }

        public final String getPropagationDefaultRouteTableId() {
            return this.propagationDefaultRouteTableId;
        }

        public final void setPropagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
        }

        @Override
        public final Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
            return this;
        }

        public final String getVpnEcmpSupport() {
            return this.vpnEcmpSupport;
        }

        public final void setVpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        @Override
        public final Builder vpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        @Override
        public final Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport) {
            this.vpnEcmpSupport(vpnEcmpSupport == null ? null : vpnEcmpSupport.toString());
            return this;
        }

        public final String getDnsSupport() {
            return this.dnsSupport;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport == null ? null : dnsSupport.toString());
            return this;
        }

        public final String getSecurityGroupReferencingSupport() {
            return this.securityGroupReferencingSupport;
        }

        public final void setSecurityGroupReferencingSupport(String securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport = securityGroupReferencingSupport;
        }

        @Override
        public final Builder securityGroupReferencingSupport(String securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport = securityGroupReferencingSupport;
            return this;
        }

        @Override
        public final Builder securityGroupReferencingSupport(SecurityGroupReferencingSupportValue securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport(securityGroupReferencingSupport == null ? null : securityGroupReferencingSupport.toString());
            return this;
        }

        public final String getMulticastSupport() {
            return this.multicastSupport;
        }

        public final void setMulticastSupport(String multicastSupport) {
            this.multicastSupport = multicastSupport;
        }

        @Override
        public final Builder multicastSupport(String multicastSupport) {
            this.multicastSupport = multicastSupport;
            return this;
        }

        @Override
        public final Builder multicastSupport(MulticastSupportValue multicastSupport) {
            this.multicastSupport(multicastSupport == null ? null : multicastSupport.toString());
            return this;
        }

        public TransitGatewayOptions build() {
            return new TransitGatewayOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayOptions> {
        public Builder amazonSideAsn(Long var1);

        public Builder transitGatewayCidrBlocks(Collection<String> var1);

        public Builder transitGatewayCidrBlocks(String ... var1);

        public Builder autoAcceptSharedAttachments(String var1);

        public Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue var1);

        public Builder defaultRouteTableAssociation(String var1);

        public Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue var1);

        public Builder associationDefaultRouteTableId(String var1);

        public Builder defaultRouteTablePropagation(String var1);

        public Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue var1);

        public Builder propagationDefaultRouteTableId(String var1);

        public Builder vpnEcmpSupport(String var1);

        public Builder vpnEcmpSupport(VpnEcmpSupportValue var1);

        public Builder dnsSupport(String var1);

        public Builder dnsSupport(DnsSupportValue var1);

        public Builder securityGroupReferencingSupport(String var1);

        public Builder securityGroupReferencingSupport(SecurityGroupReferencingSupportValue var1);

        public Builder multicastSupport(String var1);

        public Builder multicastSupport(MulticastSupportValue var1);
    }
}

