/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewayConnectPeersResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewayConnectPeersResponse> {
    private static final SdkField<List<TransitGatewayConnectPeer>> TRANSIT_GATEWAY_CONNECT_PEERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayConnectPeers").getter(DescribeTransitGatewayConnectPeersResponse.getter(DescribeTransitGatewayConnectPeersResponse::transitGatewayConnectPeers)).setter(DescribeTransitGatewayConnectPeersResponse.setter(Builder::transitGatewayConnectPeers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayConnectPeerSet").unmarshallLocationName("transitGatewayConnectPeerSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayConnectPeer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTransitGatewayConnectPeersResponse.getter(DescribeTransitGatewayConnectPeersResponse::nextToken)).setter(DescribeTransitGatewayConnectPeersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_CONNECT_PEERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTransitGatewayConnectPeersResponse.memberNameToFieldInitializer();
    private final List<TransitGatewayConnectPeer> transitGatewayConnectPeers;
    private final String nextToken;

    private DescribeTransitGatewayConnectPeersResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayConnectPeers = builder.transitGatewayConnectPeers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransitGatewayConnectPeers() {
        return this.transitGatewayConnectPeers != null && !(this.transitGatewayConnectPeers instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayConnectPeer> transitGatewayConnectPeers() {
        return this.transitGatewayConnectPeers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayConnectPeers() ? this.transitGatewayConnectPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayConnectPeersResponse)) {
            return false;
        }
        DescribeTransitGatewayConnectPeersResponse other = (DescribeTransitGatewayConnectPeersResponse)((Object)obj);
        return this.hasTransitGatewayConnectPeers() == other.hasTransitGatewayConnectPeers() && Objects.equals(this.transitGatewayConnectPeers(), other.transitGatewayConnectPeers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTransitGatewayConnectPeersResponse").add("TransitGatewayConnectPeers", this.hasTransitGatewayConnectPeers() ? this.transitGatewayConnectPeers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayConnectPeers": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayConnectPeers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayConnectPeerSet", TRANSIT_GATEWAY_CONNECT_PEERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayConnectPeersResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayConnectPeersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayConnectPeer> transitGatewayConnectPeers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayConnectPeersResponse model) {
            super(model);
            this.transitGatewayConnectPeers(model.transitGatewayConnectPeers);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayConnectPeer.Builder> getTransitGatewayConnectPeers() {
            List<TransitGatewayConnectPeer.Builder> result = TransitGatewayConnectPeerListCopier.copyToBuilder(this.transitGatewayConnectPeers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayConnectPeers(Collection<TransitGatewayConnectPeer.BuilderImpl> transitGatewayConnectPeers) {
            this.transitGatewayConnectPeers = TransitGatewayConnectPeerListCopier.copyFromBuilder(transitGatewayConnectPeers);
        }

        @Override
        public final Builder transitGatewayConnectPeers(Collection<TransitGatewayConnectPeer> transitGatewayConnectPeers) {
            this.transitGatewayConnectPeers = TransitGatewayConnectPeerListCopier.copy(transitGatewayConnectPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayConnectPeers(TransitGatewayConnectPeer ... transitGatewayConnectPeers) {
            this.transitGatewayConnectPeers(Arrays.asList(transitGatewayConnectPeers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayConnectPeers(Consumer<TransitGatewayConnectPeer.Builder> ... transitGatewayConnectPeers) {
            this.transitGatewayConnectPeers(Stream.of(transitGatewayConnectPeers).map(c -> (TransitGatewayConnectPeer)((TransitGatewayConnectPeer.Builder)TransitGatewayConnectPeer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTransitGatewayConnectPeersResponse build() {
            return new DescribeTransitGatewayConnectPeersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewayConnectPeersResponse> {
        public Builder transitGatewayConnectPeers(Collection<TransitGatewayConnectPeer> var1);

        public Builder transitGatewayConnectPeers(TransitGatewayConnectPeer ... var1);

        public Builder transitGatewayConnectPeers(Consumer<TransitGatewayConnectPeer.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

