/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.ReasonCodesListCopier;
import software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes;
import software.amazon.awssdk.services.ec2.model.ReportStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportInstanceStatusRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ReportInstanceStatusRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ReportInstanceStatusRequest.getter(ReportInstanceStatusRequest::dryRun)).setter(ReportInstanceStatusRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<List<String>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(ReportInstanceStatusRequest.getter(ReportInstanceStatusRequest::instances)).setter(ReportInstanceStatusRequest.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build(), ListTrait.builder().memberLocationName("InstanceId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReportInstanceStatusRequest.getter(ReportInstanceStatusRequest::statusAsString)).setter(ReportInstanceStatusRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ReportInstanceStatusRequest.getter(ReportInstanceStatusRequest::startTime)).setter(ReportInstanceStatusRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ReportInstanceStatusRequest.getter(ReportInstanceStatusRequest::endTime)).setter(ReportInstanceStatusRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").unmarshallLocationName("endTime").build()}).build();
    private static final SdkField<List<String>> REASON_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReasonCodes").getter(ReportInstanceStatusRequest.getter(ReportInstanceStatusRequest::reasonCodesAsStrings)).setter(ReportInstanceStatusRequest.setter(Builder::reasonCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode").unmarshallLocationName("reasonCode").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ReportInstanceStatusRequest.getter(ReportInstanceStatusRequest::description)).setter(ReportInstanceStatusRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, INSTANCES_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, REASON_CODES_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportInstanceStatusRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final List<String> instances;
    private final String status;
    private final Instant startTime;
    private final Instant endTime;
    private final List<String> reasonCodes;
    private final String description;

    private ReportInstanceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.instances = builder.instances;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.reasonCodes = builder.reasonCodes;
        this.description = builder.description;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<String> instances() {
        return this.instances;
    }

    public final ReportStatusType status() {
        return ReportStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final List<ReportInstanceReasonCodes> reasonCodes() {
        return ReasonCodesListCopier.copyStringToEnum(this.reasonCodes);
    }

    public final boolean hasReasonCodes() {
        return this.reasonCodes != null && !(this.reasonCodes instanceof SdkAutoConstructList);
    }

    public final List<String> reasonCodesAsStrings() {
        return this.reasonCodes;
    }

    @Deprecated
    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasonCodes() ? this.reasonCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportInstanceStatusRequest)) {
            return false;
        }
        ReportInstanceStatusRequest other = (ReportInstanceStatusRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasReasonCodes() == other.hasReasonCodes() && Objects.equals(this.reasonCodesAsStrings(), other.reasonCodesAsStrings()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ReportInstanceStatusRequest").add("DryRun", (Object)this.dryRun()).add("Instances", this.hasInstances() ? this.instances() : null).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ReasonCodes", this.hasReasonCodes() ? this.reasonCodesAsStrings() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ReasonCodes": {
                return Optional.ofNullable(clazz.cast(this.reasonCodesAsStrings()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InstanceId", INSTANCES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ReasonCode", REASON_CODES_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportInstanceStatusRequest, T> g) {
        return obj -> g.apply((ReportInstanceStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private List<String> instances = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant startTime;
        private Instant endTime;
        private List<String> reasonCodes = DefaultSdkAutoConstructList.getInstance();
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportInstanceStatusRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.instances(model.instances);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.reasonCodesWithStrings(model.reasonCodes);
            this.description(model.description);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getInstances() {
            if (this.instances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instances;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<String> getReasonCodes() {
            if (this.reasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reasonCodes;
        }

        public final void setReasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
        }

        @Override
        public final Builder reasonCodesWithStrings(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodesWithStrings(String ... reasonCodes) {
            this.reasonCodesWithStrings(Arrays.asList(reasonCodes));
            return this;
        }

        @Override
        public final Builder reasonCodes(Collection<ReportInstanceReasonCodes> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copyEnumToString(reasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodes(ReportInstanceReasonCodes ... reasonCodes) {
            this.reasonCodes(Arrays.asList(reasonCodes));
            return this;
        }

        @Deprecated
        public final String getDescription() {
            return this.description;
        }

        @Deprecated
        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Deprecated
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReportInstanceStatusRequest build() {
            return new ReportInstanceStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReportInstanceStatusRequest> {
        public Builder dryRun(Boolean var1);

        public Builder instances(Collection<String> var1);

        public Builder instances(String ... var1);

        public Builder status(String var1);

        public Builder status(ReportStatusType var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder reasonCodesWithStrings(Collection<String> var1);

        public Builder reasonCodesWithStrings(String ... var1);

        public Builder reasonCodes(Collection<ReportInstanceReasonCodes> var1);

        public Builder reasonCodes(ReportInstanceReasonCodes ... var1);

        @Deprecated
        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

