/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.PrefixListAssociation;

public class GetManagedPrefixListAssociationsPublisher
implements SdkPublisher<GetManagedPrefixListAssociationsResponse> {
    private final Ec2AsyncClient client;
    private final GetManagedPrefixListAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetManagedPrefixListAssociationsPublisher(Ec2AsyncClient client, GetManagedPrefixListAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetManagedPrefixListAssociationsPublisher(Ec2AsyncClient client, GetManagedPrefixListAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetManagedPrefixListAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetManagedPrefixListAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PrefixListAssociation> prefixListAssociations() {
        Function<GetManagedPrefixListAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.prefixListAssociations() != null) {
                return response.prefixListAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetManagedPrefixListAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetManagedPrefixListAssociationsResponseFetcher
    implements AsyncPageFetcher<GetManagedPrefixListAssociationsResponse> {
        private GetManagedPrefixListAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetManagedPrefixListAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetManagedPrefixListAssociationsResponse> nextPage(GetManagedPrefixListAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetManagedPrefixListAssociationsPublisher.this.client.getManagedPrefixListAssociations(GetManagedPrefixListAssociationsPublisher.this.firstRequest);
            }
            return GetManagedPrefixListAssociationsPublisher.this.client.getManagedPrefixListAssociations((GetManagedPrefixListAssociationsRequest)((Object)GetManagedPrefixListAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

