/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VpcCidrBlockState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcCidrBlockAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcCidrBlockAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcCidrBlockAssociation.getter(VpcCidrBlockAssociation::associationId)).setter(VpcCidrBlockAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcCidrBlockAssociation.getter(VpcCidrBlockAssociation::cidrBlock)).setter(VpcCidrBlockAssociation.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("cidrBlock").build()}).build();
    private static final SdkField<VpcCidrBlockState> CIDR_BLOCK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VpcCidrBlockAssociation.getter(VpcCidrBlockAssociation::cidrBlockState)).setter(VpcCidrBlockAssociation.setter(Builder::cidrBlockState)).constructor(VpcCidrBlockState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockState").unmarshallLocationName("cidrBlockState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, CIDR_BLOCK_FIELD, CIDR_BLOCK_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String cidrBlock;
    private final VpcCidrBlockState cidrBlockState;

    private VpcCidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.cidrBlock = builder.cidrBlock;
        this.cidrBlockState = builder.cidrBlockState;
    }

    public String associationId() {
        return this.associationId;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public VpcCidrBlockState cidrBlockState() {
        return this.cidrBlockState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlockState());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcCidrBlockAssociation)) {
            return false;
        }
        VpcCidrBlockAssociation other = (VpcCidrBlockAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.cidrBlockState(), other.cidrBlockState());
    }

    public String toString() {
        return ToString.builder((String)"VpcCidrBlockAssociation").add("AssociationId", (Object)this.associationId()).add("CidrBlock", (Object)this.cidrBlock()).add("CidrBlockState", (Object)this.cidrBlockState()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "CidrBlockState": {
                return Optional.ofNullable(clazz.cast(this.cidrBlockState()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcCidrBlockAssociation, T> g) {
        return obj -> g.apply((VpcCidrBlockAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String cidrBlock;
        private VpcCidrBlockState cidrBlockState;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcCidrBlockAssociation model) {
            this.associationId(model.associationId);
            this.cidrBlock(model.cidrBlock);
            this.cidrBlockState(model.cidrBlockState);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final VpcCidrBlockState.Builder getCidrBlockState() {
            return this.cidrBlockState != null ? this.cidrBlockState.toBuilder() : null;
        }

        @Override
        public final Builder cidrBlockState(VpcCidrBlockState cidrBlockState) {
            this.cidrBlockState = cidrBlockState;
            return this;
        }

        public final void setCidrBlockState(VpcCidrBlockState.BuilderImpl cidrBlockState) {
            this.cidrBlockState = cidrBlockState != null ? cidrBlockState.build() : null;
        }

        public VpcCidrBlockAssociation build() {
            return new VpcCidrBlockAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcCidrBlockAssociation> {
        public Builder associationId(String var1);

        public Builder cidrBlock(String var1);

        public Builder cidrBlockState(VpcCidrBlockState var1);

        default public Builder cidrBlockState(Consumer<VpcCidrBlockState.Builder> cidrBlockState) {
            return this.cidrBlockState((VpcCidrBlockState)((VpcCidrBlockState.Builder)VpcCidrBlockState.builder().applyMutation(cidrBlockState)).build());
        }
    }
}

