/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion;
import software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegionSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpamTier;
import software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion;
import software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegionSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIpamRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyIpamRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyIpamRequest.getter(ModifyIpamRequest::dryRun)).setter(ModifyIpamRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamId").getter(ModifyIpamRequest.getter(ModifyIpamRequest::ipamId)).setter(ModifyIpamRequest.setter(Builder::ipamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId").unmarshallLocationName("IpamId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyIpamRequest.getter(ModifyIpamRequest::description)).setter(ModifyIpamRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<AddIpamOperatingRegion>> ADD_OPERATING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddOperatingRegions").getter(ModifyIpamRequest.getter(ModifyIpamRequest::addOperatingRegions)).setter(ModifyIpamRequest.setter(Builder::addOperatingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddOperatingRegion").unmarshallLocationName("AddOperatingRegion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddIpamOperatingRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RemoveIpamOperatingRegion>> REMOVE_OPERATING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveOperatingRegions").getter(ModifyIpamRequest.getter(ModifyIpamRequest::removeOperatingRegions)).setter(ModifyIpamRequest.setter(Builder::removeOperatingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveOperatingRegion").unmarshallLocationName("RemoveOperatingRegion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemoveIpamOperatingRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(ModifyIpamRequest.getter(ModifyIpamRequest::tierAsString)).setter(ModifyIpamRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").unmarshallLocationName("Tier").build()}).build();
    private static final SdkField<Boolean> ENABLE_PRIVATE_GUA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePrivateGua").getter(ModifyIpamRequest.getter(ModifyIpamRequest::enablePrivateGua)).setter(ModifyIpamRequest.setter(Builder::enablePrivateGua)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrivateGua").unmarshallLocationName("EnablePrivateGua").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_ID_FIELD, DESCRIPTION_FIELD, ADD_OPERATING_REGIONS_FIELD, REMOVE_OPERATING_REGIONS_FIELD, TIER_FIELD, ENABLE_PRIVATE_GUA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("IpamId", IPAM_ID_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("AddOperatingRegion", ADD_OPERATING_REGIONS_FIELD);
            this.put("RemoveOperatingRegion", REMOVE_OPERATING_REGIONS_FIELD);
            this.put("Tier", TIER_FIELD);
            this.put("EnablePrivateGua", ENABLE_PRIVATE_GUA_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String ipamId;
    private final String description;
    private final List<AddIpamOperatingRegion> addOperatingRegions;
    private final List<RemoveIpamOperatingRegion> removeOperatingRegions;
    private final String tier;
    private final Boolean enablePrivateGua;

    private ModifyIpamRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamId = builder.ipamId;
        this.description = builder.description;
        this.addOperatingRegions = builder.addOperatingRegions;
        this.removeOperatingRegions = builder.removeOperatingRegions;
        this.tier = builder.tier;
        this.enablePrivateGua = builder.enablePrivateGua;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamId() {
        return this.ipamId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasAddOperatingRegions() {
        return this.addOperatingRegions != null && !(this.addOperatingRegions instanceof SdkAutoConstructList);
    }

    public final List<AddIpamOperatingRegion> addOperatingRegions() {
        return this.addOperatingRegions;
    }

    public final boolean hasRemoveOperatingRegions() {
        return this.removeOperatingRegions != null && !(this.removeOperatingRegions instanceof SdkAutoConstructList);
    }

    public final List<RemoveIpamOperatingRegion> removeOperatingRegions() {
        return this.removeOperatingRegions;
    }

    public final IpamTier tier() {
        return IpamTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final Boolean enablePrivateGua() {
        return this.enablePrivateGua;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddOperatingRegions() ? this.addOperatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveOperatingRegions() ? this.removeOperatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePrivateGua());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamRequest)) {
            return false;
        }
        ModifyIpamRequest other = (ModifyIpamRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamId(), other.ipamId()) && Objects.equals(this.description(), other.description()) && this.hasAddOperatingRegions() == other.hasAddOperatingRegions() && Objects.equals(this.addOperatingRegions(), other.addOperatingRegions()) && this.hasRemoveOperatingRegions() == other.hasRemoveOperatingRegions() && Objects.equals(this.removeOperatingRegions(), other.removeOperatingRegions()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.enablePrivateGua(), other.enablePrivateGua());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyIpamRequest").add("DryRun", (Object)this.dryRun()).add("IpamId", (Object)this.ipamId()).add("Description", (Object)this.description()).add("AddOperatingRegions", this.hasAddOperatingRegions() ? this.addOperatingRegions() : null).add("RemoveOperatingRegions", this.hasRemoveOperatingRegions() ? this.removeOperatingRegions() : null).add("Tier", (Object)this.tierAsString()).add("EnablePrivateGua", (Object)this.enablePrivateGua()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamId": {
                return Optional.ofNullable(clazz.cast(this.ipamId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AddOperatingRegions": {
                return Optional.ofNullable(clazz.cast(this.addOperatingRegions()));
            }
            case "RemoveOperatingRegions": {
                return Optional.ofNullable(clazz.cast(this.removeOperatingRegions()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "EnablePrivateGua": {
                return Optional.ofNullable(clazz.cast(this.enablePrivateGua()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamRequest, T> g) {
        return obj -> g.apply((ModifyIpamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamId;
        private String description;
        private List<AddIpamOperatingRegion> addOperatingRegions = DefaultSdkAutoConstructList.getInstance();
        private List<RemoveIpamOperatingRegion> removeOperatingRegions = DefaultSdkAutoConstructList.getInstance();
        private String tier;
        private Boolean enablePrivateGua;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamId(model.ipamId);
            this.description(model.description);
            this.addOperatingRegions(model.addOperatingRegions);
            this.removeOperatingRegions(model.removeOperatingRegions);
            this.tier(model.tier);
            this.enablePrivateGua(model.enablePrivateGua);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamId() {
            return this.ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AddIpamOperatingRegion.Builder> getAddOperatingRegions() {
            List<AddIpamOperatingRegion.Builder> result = AddIpamOperatingRegionSetCopier.copyToBuilder(this.addOperatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOperatingRegions(Collection<AddIpamOperatingRegion.BuilderImpl> addOperatingRegions) {
            this.addOperatingRegions = AddIpamOperatingRegionSetCopier.copyFromBuilder(addOperatingRegions);
        }

        @Override
        public final Builder addOperatingRegions(Collection<AddIpamOperatingRegion> addOperatingRegions) {
            this.addOperatingRegions = AddIpamOperatingRegionSetCopier.copy(addOperatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOperatingRegions(AddIpamOperatingRegion ... addOperatingRegions) {
            this.addOperatingRegions(Arrays.asList(addOperatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOperatingRegions(Consumer<AddIpamOperatingRegion.Builder> ... addOperatingRegions) {
            this.addOperatingRegions(Stream.of(addOperatingRegions).map(c -> (AddIpamOperatingRegion)((AddIpamOperatingRegion.Builder)AddIpamOperatingRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RemoveIpamOperatingRegion.Builder> getRemoveOperatingRegions() {
            List<RemoveIpamOperatingRegion.Builder> result = RemoveIpamOperatingRegionSetCopier.copyToBuilder(this.removeOperatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveOperatingRegions(Collection<RemoveIpamOperatingRegion.BuilderImpl> removeOperatingRegions) {
            this.removeOperatingRegions = RemoveIpamOperatingRegionSetCopier.copyFromBuilder(removeOperatingRegions);
        }

        @Override
        public final Builder removeOperatingRegions(Collection<RemoveIpamOperatingRegion> removeOperatingRegions) {
            this.removeOperatingRegions = RemoveIpamOperatingRegionSetCopier.copy(removeOperatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOperatingRegions(RemoveIpamOperatingRegion ... removeOperatingRegions) {
            this.removeOperatingRegions(Arrays.asList(removeOperatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOperatingRegions(Consumer<RemoveIpamOperatingRegion.Builder> ... removeOperatingRegions) {
            this.removeOperatingRegions(Stream.of(removeOperatingRegions).map(c -> (RemoveIpamOperatingRegion)((RemoveIpamOperatingRegion.Builder)RemoveIpamOperatingRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(IpamTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Boolean getEnablePrivateGua() {
            return this.enablePrivateGua;
        }

        public final void setEnablePrivateGua(Boolean enablePrivateGua) {
            this.enablePrivateGua = enablePrivateGua;
        }

        @Override
        public final Builder enablePrivateGua(Boolean enablePrivateGua) {
            this.enablePrivateGua = enablePrivateGua;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamRequest build() {
            return new ModifyIpamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIpamRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamId(String var1);

        public Builder description(String var1);

        public Builder addOperatingRegions(Collection<AddIpamOperatingRegion> var1);

        public Builder addOperatingRegions(AddIpamOperatingRegion ... var1);

        public Builder addOperatingRegions(Consumer<AddIpamOperatingRegion.Builder> ... var1);

        public Builder removeOperatingRegions(Collection<RemoveIpamOperatingRegion> var1);

        public Builder removeOperatingRegions(RemoveIpamOperatingRegion ... var1);

        public Builder removeOperatingRegions(Consumer<RemoveIpamOperatingRegion.Builder> ... var1);

        public Builder tier(String var1);

        public Builder tier(IpamTier var1);

        public Builder enablePrivateGua(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

