/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion;
import software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegionSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIpamResourceDiscoveryRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateIpamResourceDiscoveryRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateIpamResourceDiscoveryRequest.getter(CreateIpamResourceDiscoveryRequest::dryRun)).setter(CreateIpamResourceDiscoveryRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateIpamResourceDiscoveryRequest.getter(CreateIpamResourceDiscoveryRequest::description)).setter(CreateIpamResourceDiscoveryRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<AddIpamOperatingRegion>> OPERATING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperatingRegions").getter(CreateIpamResourceDiscoveryRequest.getter(CreateIpamResourceDiscoveryRequest::operatingRegions)).setter(CreateIpamResourceDiscoveryRequest.setter(Builder::operatingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingRegion").unmarshallLocationName("OperatingRegion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddIpamOperatingRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateIpamResourceDiscoveryRequest.getter(CreateIpamResourceDiscoveryRequest::tagSpecifications)).setter(CreateIpamResourceDiscoveryRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateIpamResourceDiscoveryRequest.getter(CreateIpamResourceDiscoveryRequest::clientToken)).setter(CreateIpamResourceDiscoveryRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, DESCRIPTION_FIELD, OPERATING_REGIONS_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("OperatingRegion", OPERATING_REGIONS_FIELD);
            this.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String description;
    private final List<AddIpamOperatingRegion> operatingRegions;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;

    private CreateIpamResourceDiscoveryRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.description = builder.description;
        this.operatingRegions = builder.operatingRegions;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasOperatingRegions() {
        return this.operatingRegions != null && !(this.operatingRegions instanceof SdkAutoConstructList);
    }

    public final List<AddIpamOperatingRegion> operatingRegions() {
        return this.operatingRegions;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingRegions() ? this.operatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamResourceDiscoveryRequest)) {
            return false;
        }
        CreateIpamResourceDiscoveryRequest other = (CreateIpamResourceDiscoveryRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.description(), other.description()) && this.hasOperatingRegions() == other.hasOperatingRegions() && Objects.equals(this.operatingRegions(), other.operatingRegions()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIpamResourceDiscoveryRequest").add("DryRun", (Object)this.dryRun()).add("Description", (Object)this.description()).add("OperatingRegions", this.hasOperatingRegions() ? this.operatingRegions() : null).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OperatingRegions": {
                return Optional.ofNullable(clazz.cast(this.operatingRegions()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamResourceDiscoveryRequest, T> g) {
        return obj -> g.apply((CreateIpamResourceDiscoveryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String description;
        private List<AddIpamOperatingRegion> operatingRegions = DefaultSdkAutoConstructList.getInstance();
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamResourceDiscoveryRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.description(model.description);
            this.operatingRegions(model.operatingRegions);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AddIpamOperatingRegion.Builder> getOperatingRegions() {
            List<AddIpamOperatingRegion.Builder> result = AddIpamOperatingRegionSetCopier.copyToBuilder(this.operatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperatingRegions(Collection<AddIpamOperatingRegion.BuilderImpl> operatingRegions) {
            this.operatingRegions = AddIpamOperatingRegionSetCopier.copyFromBuilder(operatingRegions);
        }

        @Override
        public final Builder operatingRegions(Collection<AddIpamOperatingRegion> operatingRegions) {
            this.operatingRegions = AddIpamOperatingRegionSetCopier.copy(operatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingRegions(AddIpamOperatingRegion ... operatingRegions) {
            this.operatingRegions(Arrays.asList(operatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingRegions(Consumer<AddIpamOperatingRegion.Builder> ... operatingRegions) {
            this.operatingRegions(Stream.of(operatingRegions).map(c -> (AddIpamOperatingRegion)((AddIpamOperatingRegion.Builder)AddIpamOperatingRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpamResourceDiscoveryRequest build() {
            return new CreateIpamResourceDiscoveryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIpamResourceDiscoveryRequest> {
        public Builder dryRun(Boolean var1);

        public Builder description(String var1);

        public Builder operatingRegions(Collection<AddIpamOperatingRegion> var1);

        public Builder operatingRegions(AddIpamOperatingRegion ... var1);

        public Builder operatingRegions(Consumer<AddIpamOperatingRegion.Builder> ... var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

