/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDefaultSubnetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateDefaultSubnetRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CreateDefaultSubnetRequest.getter(CreateDefaultSubnetRequest::availabilityZone)).setter(CreateDefaultSubnetRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateDefaultSubnetRequest.getter(CreateDefaultSubnetRequest::dryRun)).setter(CreateDefaultSubnetRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<Boolean> IPV6_NATIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Ipv6Native").getter(CreateDefaultSubnetRequest.getter(CreateDefaultSubnetRequest::ipv6Native)).setter(CreateDefaultSubnetRequest.setter(Builder::ipv6Native)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Native").unmarshallLocationName("Ipv6Native").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, DRY_RUN_FIELD, IPV6_NATIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("Ipv6Native", IPV6_NATIVE_FIELD);
        }
    });
    private final String availabilityZone;
    private final Boolean dryRun;
    private final Boolean ipv6Native;

    private CreateDefaultSubnetRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.dryRun = builder.dryRun;
        this.ipv6Native = builder.ipv6Native;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Boolean ipv6Native() {
        return this.ipv6Native;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Native());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDefaultSubnetRequest)) {
            return false;
        }
        CreateDefaultSubnetRequest other = (CreateDefaultSubnetRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipv6Native(), other.ipv6Native());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDefaultSubnetRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("DryRun", (Object)this.dryRun()).add("Ipv6Native", (Object)this.ipv6Native()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Ipv6Native": {
                return Optional.ofNullable(clazz.cast(this.ipv6Native()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDefaultSubnetRequest, T> g) {
        return obj -> g.apply((CreateDefaultSubnetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Boolean dryRun;
        private Boolean ipv6Native;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDefaultSubnetRequest model) {
            super(model);
            this.availabilityZone(model.availabilityZone);
            this.dryRun(model.dryRun);
            this.ipv6Native(model.ipv6Native);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Boolean getIpv6Native() {
            return this.ipv6Native;
        }

        public final void setIpv6Native(Boolean ipv6Native) {
            this.ipv6Native = ipv6Native;
        }

        @Override
        public final Builder ipv6Native(Boolean ipv6Native) {
            this.ipv6Native = ipv6Native;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDefaultSubnetRequest build() {
            return new CreateDefaultSubnetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDefaultSubnetRequest> {
        public Builder availabilityZone(String var1);

        public Builder dryRun(Boolean var1);

        public Builder ipv6Native(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

