/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AccountAttributeValue;
import software.amazon.awssdk.services.ec2.model.AccountAttributeValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountAttribute> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(AccountAttribute.getter(AccountAttribute::attributeName)).setter(AccountAttribute.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").unmarshallLocationName("attributeName").build()}).build();
    private static final SdkField<List<AccountAttributeValue>> ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeValues").getter(AccountAttribute.getter(AccountAttribute::attributeValues)).setter(AccountAttribute.setter(Builder::attributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValueSet").unmarshallLocationName("attributeValueSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, ATTRIBUTE_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AttributeName", ATTRIBUTE_NAME_FIELD);
            this.put("AttributeValueSet", ATTRIBUTE_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final List<AccountAttributeValue> attributeValues;

    private AccountAttribute(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValues = builder.attributeValues;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final boolean hasAttributeValues() {
        return this.attributeValues != null && !(this.attributeValues instanceof SdkAutoConstructList);
    }

    public final List<AccountAttributeValue> attributeValues() {
        return this.attributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeValues() ? this.attributeValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAttribute)) {
            return false;
        }
        AccountAttribute other = (AccountAttribute)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && this.hasAttributeValues() == other.hasAttributeValues() && Objects.equals(this.attributeValues(), other.attributeValues());
    }

    public final String toString() {
        return ToString.builder((String)"AccountAttribute").add("AttributeName", (Object)this.attributeName()).add("AttributeValues", this.hasAttributeValues() ? this.attributeValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "AttributeValues": {
                return Optional.ofNullable(clazz.cast(this.attributeValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountAttribute, T> g) {
        return obj -> g.apply((AccountAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private List<AccountAttributeValue> attributeValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAttribute model) {
            this.attributeName(model.attributeName);
            this.attributeValues(model.attributeValues);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final List<AccountAttributeValue.Builder> getAttributeValues() {
            List<AccountAttributeValue.Builder> result = AccountAttributeValueListCopier.copyToBuilder(this.attributeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeValues(Collection<AccountAttributeValue.BuilderImpl> attributeValues) {
            this.attributeValues = AccountAttributeValueListCopier.copyFromBuilder(attributeValues);
        }

        @Override
        public final Builder attributeValues(Collection<AccountAttributeValue> attributeValues) {
            this.attributeValues = AccountAttributeValueListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(AccountAttributeValue ... attributeValues) {
            this.attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(Consumer<AccountAttributeValue.Builder> ... attributeValues) {
            this.attributeValues(Stream.of(attributeValues).map(c -> (AccountAttributeValue)((AccountAttributeValue.Builder)AccountAttributeValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AccountAttribute build() {
            return new AccountAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountAttribute> {
        public Builder attributeName(String var1);

        public Builder attributeValues(Collection<AccountAttributeValue> var1);

        public Builder attributeValues(AccountAttributeValue ... var1);

        public Builder attributeValues(Consumer<AccountAttributeValue.Builder> ... var1);
    }
}

