/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubnetConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubnetConfiguration> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(SubnetConfiguration.getter(SubnetConfiguration::subnetId)).setter(SubnetConfiguration.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build()}).build();
    private static final SdkField<String> IPV4_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv4").getter(SubnetConfiguration.getter(SubnetConfiguration::ipv4)).setter(SubnetConfiguration.setter(Builder::ipv4)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4").unmarshallLocationName("Ipv4").build()}).build();
    private static final SdkField<String> IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6").getter(SubnetConfiguration.getter(SubnetConfiguration::ipv6)).setter(SubnetConfiguration.setter(Builder::ipv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6").unmarshallLocationName("Ipv6").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, IPV4_FIELD, IPV6_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubnetConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subnetId;
    private final String ipv4;
    private final String ipv6;

    private SubnetConfiguration(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.ipv4 = builder.ipv4;
        this.ipv6 = builder.ipv6;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String ipv4() {
        return this.ipv4;
    }

    public final String ipv6() {
        return this.ipv6;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetConfiguration)) {
            return false;
        }
        SubnetConfiguration other = (SubnetConfiguration)obj;
        return Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.ipv4(), other.ipv4()) && Objects.equals(this.ipv6(), other.ipv6());
    }

    public final String toString() {
        return ToString.builder((String)"SubnetConfiguration").add("SubnetId", (Object)this.subnetId()).add("Ipv4", (Object)this.ipv4()).add("Ipv6", (Object)this.ipv6()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "Ipv4": {
                return Optional.ofNullable(clazz.cast(this.ipv4()));
            }
            case "Ipv6": {
                return Optional.ofNullable(clazz.cast(this.ipv6()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("Ipv4", IPV4_FIELD);
        map.put("Ipv6", IPV6_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubnetConfiguration, T> g) {
        return obj -> g.apply((SubnetConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetId;
        private String ipv4;
        private String ipv6;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetConfiguration model) {
            this.subnetId(model.subnetId);
            this.ipv4(model.ipv4);
            this.ipv6(model.ipv6);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getIpv4() {
            return this.ipv4;
        }

        public final void setIpv4(String ipv4) {
            this.ipv4 = ipv4;
        }

        @Override
        public final Builder ipv4(String ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public final String getIpv6() {
            return this.ipv6;
        }

        public final void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        @Override
        public final Builder ipv6(String ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public SubnetConfiguration build() {
            return new SubnetConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubnetConfiguration> {
        public Builder subnetId(String var1);

        public Builder ipv4(String var1);

        public Builder ipv6(String var1);
    }
}

