/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ActiveInstance;
import software.amazon.awssdk.services.ec2.model.ActiveInstanceSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpotFleetInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSpotFleetInstancesResponse> {
    private static final SdkField<List<ActiveInstance>> ACTIVE_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActiveInstances").getter(DescribeSpotFleetInstancesResponse.getter(DescribeSpotFleetInstancesResponse::activeInstances)).setter(DescribeSpotFleetInstancesResponse.setter(Builder::activeInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveInstanceSet").unmarshallLocationName("activeInstanceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSpotFleetInstancesResponse.getter(DescribeSpotFleetInstancesResponse::nextToken)).setter(DescribeSpotFleetInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotFleetRequestId").getter(DescribeSpotFleetInstancesResponse.getter(DescribeSpotFleetInstancesResponse::spotFleetRequestId)).setter(DescribeSpotFleetInstancesResponse.setter(Builder::spotFleetRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId").unmarshallLocationName("spotFleetRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_INSTANCES_FIELD, NEXT_TOKEN_FIELD, SPOT_FLEET_REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSpotFleetInstancesResponse.memberNameToFieldInitializer();
    private final List<ActiveInstance> activeInstances;
    private final String nextToken;
    private final String spotFleetRequestId;

    private DescribeSpotFleetInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.activeInstances = builder.activeInstances;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    public final boolean hasActiveInstances() {
        return this.activeInstances != null && !(this.activeInstances instanceof SdkAutoConstructList);
    }

    public final List<ActiveInstance> activeInstances() {
        return this.activeInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveInstances() ? this.activeInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetInstancesResponse)) {
            return false;
        }
        DescribeSpotFleetInstancesResponse other = (DescribeSpotFleetInstancesResponse)((Object)obj);
        return this.hasActiveInstances() == other.hasActiveInstances() && Objects.equals(this.activeInstances(), other.activeInstances()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSpotFleetInstancesResponse").add("ActiveInstances", this.hasActiveInstances() ? this.activeInstances() : null).add("NextToken", (Object)this.nextToken()).add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveInstances": {
                return Optional.ofNullable(clazz.cast(this.activeInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SpotFleetRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActiveInstanceSet", ACTIVE_INSTANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SpotFleetRequestId", SPOT_FLEET_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotFleetInstancesResponse, T> g) {
        return obj -> g.apply((DescribeSpotFleetInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ActiveInstance> activeInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetInstancesResponse model) {
            super(model);
            this.activeInstances(model.activeInstances);
            this.nextToken(model.nextToken);
            this.spotFleetRequestId(model.spotFleetRequestId);
        }

        public final List<ActiveInstance.Builder> getActiveInstances() {
            List<ActiveInstance.Builder> result = ActiveInstanceSetCopier.copyToBuilder(this.activeInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveInstances(Collection<ActiveInstance.BuilderImpl> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copyFromBuilder(activeInstances);
        }

        @Override
        public final Builder activeInstances(Collection<ActiveInstance> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copy(activeInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(ActiveInstance ... activeInstances) {
            this.activeInstances(Arrays.asList(activeInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(Consumer<ActiveInstance.Builder> ... activeInstances) {
            this.activeInstances(Stream.of(activeInstances).map(c -> (ActiveInstance)((ActiveInstance.Builder)ActiveInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        @Override
        public DescribeSpotFleetInstancesResponse build() {
            return new DescribeSpotFleetInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSpotFleetInstancesResponse> {
        public Builder activeInstances(Collection<ActiveInstance> var1);

        public Builder activeInstances(ActiveInstance ... var1);

        public Builder activeInstances(Consumer<ActiveInstance.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder spotFleetRequestId(String var1);
    }
}

