/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SuccessfulInstanceCreditSpecificationItem;
import software.amazon.awssdk.services.ec2.model.SuccessfulInstanceCreditSpecificationSetCopier;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationItem;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceCreditSpecificationResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifyInstanceCreditSpecificationResponse> {
    private static final SdkField<List<SuccessfulInstanceCreditSpecificationItem>> SUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulInstanceCreditSpecifications").getter(ModifyInstanceCreditSpecificationResponse.getter(ModifyInstanceCreditSpecificationResponse::successfulInstanceCreditSpecifications)).setter(ModifyInstanceCreditSpecificationResponse.setter(Builder::successfulInstanceCreditSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulInstanceCreditSpecificationSet").unmarshallLocationName("successfulInstanceCreditSpecificationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuccessfulInstanceCreditSpecificationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<UnsuccessfulInstanceCreditSpecificationItem>> UNSUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnsuccessfulInstanceCreditSpecifications").getter(ModifyInstanceCreditSpecificationResponse.getter(ModifyInstanceCreditSpecificationResponse::unsuccessfulInstanceCreditSpecifications)).setter(ModifyInstanceCreditSpecificationResponse.setter(Builder::unsuccessfulInstanceCreditSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulInstanceCreditSpecificationSet").unmarshallLocationName("unsuccessfulInstanceCreditSpecificationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnsuccessfulInstanceCreditSpecificationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD, UNSUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyInstanceCreditSpecificationResponse.memberNameToFieldInitializer();
    private final List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications;
    private final List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications;

    private ModifyInstanceCreditSpecificationResponse(BuilderImpl builder) {
        super(builder);
        this.successfulInstanceCreditSpecifications = builder.successfulInstanceCreditSpecifications;
        this.unsuccessfulInstanceCreditSpecifications = builder.unsuccessfulInstanceCreditSpecifications;
    }

    public final boolean hasSuccessfulInstanceCreditSpecifications() {
        return this.successfulInstanceCreditSpecifications != null && !(this.successfulInstanceCreditSpecifications instanceof SdkAutoConstructList);
    }

    public final List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications() {
        return this.successfulInstanceCreditSpecifications;
    }

    public final boolean hasUnsuccessfulInstanceCreditSpecifications() {
        return this.unsuccessfulInstanceCreditSpecifications != null && !(this.unsuccessfulInstanceCreditSpecifications instanceof SdkAutoConstructList);
    }

    public final List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications() {
        return this.unsuccessfulInstanceCreditSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulInstanceCreditSpecifications() ? this.successfulInstanceCreditSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessfulInstanceCreditSpecifications() ? this.unsuccessfulInstanceCreditSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCreditSpecificationResponse)) {
            return false;
        }
        ModifyInstanceCreditSpecificationResponse other = (ModifyInstanceCreditSpecificationResponse)((Object)obj);
        return this.hasSuccessfulInstanceCreditSpecifications() == other.hasSuccessfulInstanceCreditSpecifications() && Objects.equals(this.successfulInstanceCreditSpecifications(), other.successfulInstanceCreditSpecifications()) && this.hasUnsuccessfulInstanceCreditSpecifications() == other.hasUnsuccessfulInstanceCreditSpecifications() && Objects.equals(this.unsuccessfulInstanceCreditSpecifications(), other.unsuccessfulInstanceCreditSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceCreditSpecificationResponse").add("SuccessfulInstanceCreditSpecifications", this.hasSuccessfulInstanceCreditSpecifications() ? this.successfulInstanceCreditSpecifications() : null).add("UnsuccessfulInstanceCreditSpecifications", this.hasUnsuccessfulInstanceCreditSpecifications() ? this.unsuccessfulInstanceCreditSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulInstanceCreditSpecifications": {
                return Optional.ofNullable(clazz.cast(this.successfulInstanceCreditSpecifications()));
            }
            case "UnsuccessfulInstanceCreditSpecifications": {
                return Optional.ofNullable(clazz.cast(this.unsuccessfulInstanceCreditSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SuccessfulInstanceCreditSpecificationSet", SUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD);
        map.put("UnsuccessfulInstanceCreditSpecificationSet", UNSUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceCreditSpecificationResponse, T> g) {
        return obj -> g.apply((ModifyInstanceCreditSpecificationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCreditSpecificationResponse model) {
            super(model);
            this.successfulInstanceCreditSpecifications(model.successfulInstanceCreditSpecifications);
            this.unsuccessfulInstanceCreditSpecifications(model.unsuccessfulInstanceCreditSpecifications);
        }

        public final List<SuccessfulInstanceCreditSpecificationItem.Builder> getSuccessfulInstanceCreditSpecifications() {
            List<SuccessfulInstanceCreditSpecificationItem.Builder> result = SuccessfulInstanceCreditSpecificationSetCopier.copyToBuilder(this.successfulInstanceCreditSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulInstanceCreditSpecifications(Collection<SuccessfulInstanceCreditSpecificationItem.BuilderImpl> successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications = SuccessfulInstanceCreditSpecificationSetCopier.copyFromBuilder(successfulInstanceCreditSpecifications);
        }

        @Override
        public final Builder successfulInstanceCreditSpecifications(Collection<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications = SuccessfulInstanceCreditSpecificationSetCopier.copy(successfulInstanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulInstanceCreditSpecifications(SuccessfulInstanceCreditSpecificationItem ... successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications(Arrays.asList(successfulInstanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulInstanceCreditSpecifications(Consumer<SuccessfulInstanceCreditSpecificationItem.Builder> ... successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications(Stream.of(successfulInstanceCreditSpecifications).map(c -> (SuccessfulInstanceCreditSpecificationItem)((SuccessfulInstanceCreditSpecificationItem.Builder)SuccessfulInstanceCreditSpecificationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnsuccessfulInstanceCreditSpecificationItem.Builder> getUnsuccessfulInstanceCreditSpecifications() {
            List<UnsuccessfulInstanceCreditSpecificationItem.Builder> result = UnsuccessfulInstanceCreditSpecificationSetCopier.copyToBuilder(this.unsuccessfulInstanceCreditSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessfulInstanceCreditSpecifications(Collection<UnsuccessfulInstanceCreditSpecificationItem.BuilderImpl> unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications = UnsuccessfulInstanceCreditSpecificationSetCopier.copyFromBuilder(unsuccessfulInstanceCreditSpecifications);
        }

        @Override
        public final Builder unsuccessfulInstanceCreditSpecifications(Collection<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications = UnsuccessfulInstanceCreditSpecificationSetCopier.copy(unsuccessfulInstanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulInstanceCreditSpecifications(UnsuccessfulInstanceCreditSpecificationItem ... unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications(Arrays.asList(unsuccessfulInstanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulInstanceCreditSpecifications(Consumer<UnsuccessfulInstanceCreditSpecificationItem.Builder> ... unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications(Stream.of(unsuccessfulInstanceCreditSpecifications).map(c -> (UnsuccessfulInstanceCreditSpecificationItem)((UnsuccessfulInstanceCreditSpecificationItem.Builder)UnsuccessfulInstanceCreditSpecificationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ModifyInstanceCreditSpecificationResponse build() {
            return new ModifyInstanceCreditSpecificationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceCreditSpecificationResponse> {
        public Builder successfulInstanceCreditSpecifications(Collection<SuccessfulInstanceCreditSpecificationItem> var1);

        public Builder successfulInstanceCreditSpecifications(SuccessfulInstanceCreditSpecificationItem ... var1);

        public Builder successfulInstanceCreditSpecifications(Consumer<SuccessfulInstanceCreditSpecificationItem.Builder> ... var1);

        public Builder unsuccessfulInstanceCreditSpecifications(Collection<UnsuccessfulInstanceCreditSpecificationItem> var1);

        public Builder unsuccessfulInstanceCreditSpecifications(UnsuccessfulInstanceCreditSpecificationItem ... var1);

        public Builder unsuccessfulInstanceCreditSpecifications(Consumer<UnsuccessfulInstanceCreditSpecificationItem.Builder> ... var1);
    }
}

