/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamNetworkInterfaceAttachmentStatus;
import software.amazon.awssdk.services.ec2.model.IpamResourceCidrIpSource;
import software.amazon.awssdk.services.ec2.model.IpamResourceTag;
import software.amazon.awssdk.services.ec2.model.IpamResourceTagListCopier;
import software.amazon.awssdk.services.ec2.model.IpamResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamDiscoveredResourceCidr
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamDiscoveredResourceCidr> {
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryId").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::ipamResourceDiscoveryId)).setter(IpamDiscoveredResourceCidr.setter(Builder::ipamResourceDiscoveryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryId").unmarshallLocationName("ipamResourceDiscoveryId").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRegion").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceRegion)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").unmarshallLocationName("resourceRegion").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceId)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwnerId").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceOwnerId)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").unmarshallLocationName("resourceOwnerId").build()}).build();
    private static final SdkField<String> RESOURCE_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCidr").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceCidr)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCidr").unmarshallLocationName("resourceCidr").build()}).build();
    private static final SdkField<String> IP_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpSource").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::ipSourceAsString)).setter(IpamDiscoveredResourceCidr.setter(Builder::ipSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpSource").unmarshallLocationName("ipSource").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceTypeAsString)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<List<IpamResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceTags)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTagSet").unmarshallLocationName("resourceTagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Double> IP_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("IpUsage").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::ipUsage)).setter(IpamDiscoveredResourceCidr.setter(Builder::ipUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpUsage").unmarshallLocationName("ipUsage").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::vpcId)).setter(IpamDiscoveredResourceCidr.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::subnetId)).setter(IpamDiscoveredResourceCidr.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ATTACHMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceAttachmentStatus").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::networkInterfaceAttachmentStatusAsString)).setter(IpamDiscoveredResourceCidr.setter(Builder::networkInterfaceAttachmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceAttachmentStatus").unmarshallLocationName("networkInterfaceAttachmentStatus").build()}).build();
    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTime").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::sampleTime)).setter(IpamDiscoveredResourceCidr.setter(Builder::sampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").unmarshallLocationName("sampleTime").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::availabilityZoneId)).setter(IpamDiscoveredResourceCidr.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_RESOURCE_DISCOVERY_ID_FIELD, RESOURCE_REGION_FIELD, RESOURCE_ID_FIELD, RESOURCE_OWNER_ID_FIELD, RESOURCE_CIDR_FIELD, IP_SOURCE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TAGS_FIELD, IP_USAGE_FIELD, VPC_ID_FIELD, SUBNET_ID_FIELD, NETWORK_INTERFACE_ATTACHMENT_STATUS_FIELD, SAMPLE_TIME_FIELD, AVAILABILITY_ZONE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamDiscoveredResourceCidr.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ipamResourceDiscoveryId;
    private final String resourceRegion;
    private final String resourceId;
    private final String resourceOwnerId;
    private final String resourceCidr;
    private final String ipSource;
    private final String resourceType;
    private final List<IpamResourceTag> resourceTags;
    private final Double ipUsage;
    private final String vpcId;
    private final String subnetId;
    private final String networkInterfaceAttachmentStatus;
    private final Instant sampleTime;
    private final String availabilityZoneId;

    private IpamDiscoveredResourceCidr(BuilderImpl builder) {
        this.ipamResourceDiscoveryId = builder.ipamResourceDiscoveryId;
        this.resourceRegion = builder.resourceRegion;
        this.resourceId = builder.resourceId;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.resourceCidr = builder.resourceCidr;
        this.ipSource = builder.ipSource;
        this.resourceType = builder.resourceType;
        this.resourceTags = builder.resourceTags;
        this.ipUsage = builder.ipUsage;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.networkInterfaceAttachmentStatus = builder.networkInterfaceAttachmentStatus;
        this.sampleTime = builder.sampleTime;
        this.availabilityZoneId = builder.availabilityZoneId;
    }

    public final String ipamResourceDiscoveryId() {
        return this.ipamResourceDiscoveryId;
    }

    public final String resourceRegion() {
        return this.resourceRegion;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceOwnerId() {
        return this.resourceOwnerId;
    }

    public final String resourceCidr() {
        return this.resourceCidr;
    }

    public final IpamResourceCidrIpSource ipSource() {
        return IpamResourceCidrIpSource.fromValue(this.ipSource);
    }

    public final String ipSourceAsString() {
        return this.ipSource;
    }

    public final IpamResourceType resourceType() {
        return IpamResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<IpamResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public final Double ipUsage() {
        return this.ipUsage;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final IpamNetworkInterfaceAttachmentStatus networkInterfaceAttachmentStatus() {
        return IpamNetworkInterfaceAttachmentStatus.fromValue(this.networkInterfaceAttachmentStatus);
    }

    public final String networkInterfaceAttachmentStatusAsString() {
        return this.networkInterfaceAttachmentStatus;
    }

    public final Instant sampleTime() {
        return this.sampleTime;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipUsage());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceAttachmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamDiscoveredResourceCidr)) {
            return false;
        }
        IpamDiscoveredResourceCidr other = (IpamDiscoveredResourceCidr)obj;
        return Objects.equals(this.ipamResourceDiscoveryId(), other.ipamResourceDiscoveryId()) && Objects.equals(this.resourceRegion(), other.resourceRegion()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceOwnerId(), other.resourceOwnerId()) && Objects.equals(this.resourceCidr(), other.resourceCidr()) && Objects.equals(this.ipSourceAsString(), other.ipSourceAsString()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.ipUsage(), other.ipUsage()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.networkInterfaceAttachmentStatusAsString(), other.networkInterfaceAttachmentStatusAsString()) && Objects.equals(this.sampleTime(), other.sampleTime()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId());
    }

    public final String toString() {
        return ToString.builder((String)"IpamDiscoveredResourceCidr").add("IpamResourceDiscoveryId", (Object)this.ipamResourceDiscoveryId()).add("ResourceRegion", (Object)this.resourceRegion()).add("ResourceId", (Object)this.resourceId()).add("ResourceOwnerId", (Object)this.resourceOwnerId()).add("ResourceCidr", (Object)this.resourceCidr()).add("IpSource", (Object)this.ipSourceAsString()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("IpUsage", (Object)this.ipUsage()).add("VpcId", (Object)this.vpcId()).add("SubnetId", (Object)this.subnetId()).add("NetworkInterfaceAttachmentStatus", (Object)this.networkInterfaceAttachmentStatusAsString()).add("SampleTime", (Object)this.sampleTime()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamResourceDiscoveryId": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryId()));
            }
            case "ResourceRegion": {
                return Optional.ofNullable(clazz.cast(this.resourceRegion()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerId()));
            }
            case "ResourceCidr": {
                return Optional.ofNullable(clazz.cast(this.resourceCidr()));
            }
            case "IpSource": {
                return Optional.ofNullable(clazz.cast(this.ipSourceAsString()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "IpUsage": {
                return Optional.ofNullable(clazz.cast(this.ipUsage()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "NetworkInterfaceAttachmentStatus": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceAttachmentStatusAsString()));
            }
            case "SampleTime": {
                return Optional.ofNullable(clazz.cast(this.sampleTime()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IpamResourceDiscoveryId", IPAM_RESOURCE_DISCOVERY_ID_FIELD);
        map.put("ResourceRegion", RESOURCE_REGION_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceOwnerId", RESOURCE_OWNER_ID_FIELD);
        map.put("ResourceCidr", RESOURCE_CIDR_FIELD);
        map.put("IpSource", IP_SOURCE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceTagSet", RESOURCE_TAGS_FIELD);
        map.put("IpUsage", IP_USAGE_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("NetworkInterfaceAttachmentStatus", NETWORK_INTERFACE_ATTACHMENT_STATUS_FIELD);
        map.put("SampleTime", SAMPLE_TIME_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamDiscoveredResourceCidr, T> g) {
        return obj -> g.apply((IpamDiscoveredResourceCidr)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipamResourceDiscoveryId;
        private String resourceRegion;
        private String resourceId;
        private String resourceOwnerId;
        private String resourceCidr;
        private String ipSource;
        private String resourceType;
        private List<IpamResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private Double ipUsage;
        private String vpcId;
        private String subnetId;
        private String networkInterfaceAttachmentStatus;
        private Instant sampleTime;
        private String availabilityZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamDiscoveredResourceCidr model) {
            this.ipamResourceDiscoveryId(model.ipamResourceDiscoveryId);
            this.resourceRegion(model.resourceRegion);
            this.resourceId(model.resourceId);
            this.resourceOwnerId(model.resourceOwnerId);
            this.resourceCidr(model.resourceCidr);
            this.ipSource(model.ipSource);
            this.resourceType(model.resourceType);
            this.resourceTags(model.resourceTags);
            this.ipUsage(model.ipUsage);
            this.vpcId(model.vpcId);
            this.subnetId(model.subnetId);
            this.networkInterfaceAttachmentStatus(model.networkInterfaceAttachmentStatus);
            this.sampleTime(model.sampleTime);
            this.availabilityZoneId(model.availabilityZoneId);
        }

        public final String getIpamResourceDiscoveryId() {
            return this.ipamResourceDiscoveryId;
        }

        public final void setIpamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
        }

        @Override
        public final Builder ipamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
            return this;
        }

        public final String getResourceRegion() {
            return this.resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceOwnerId() {
            return this.resourceOwnerId;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final String getResourceCidr() {
            return this.resourceCidr;
        }

        public final void setResourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
        }

        @Override
        public final Builder resourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
            return this;
        }

        public final String getIpSource() {
            return this.ipSource;
        }

        public final void setIpSource(String ipSource) {
            this.ipSource = ipSource;
        }

        @Override
        public final Builder ipSource(String ipSource) {
            this.ipSource = ipSource;
            return this;
        }

        @Override
        public final Builder ipSource(IpamResourceCidrIpSource ipSource) {
            this.ipSource(ipSource == null ? null : ipSource.toString());
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<IpamResourceTag.Builder> getResourceTags() {
            List<IpamResourceTag.Builder> result = IpamResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<IpamResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = IpamResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<IpamResourceTag> resourceTags) {
            this.resourceTags = IpamResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(IpamResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<IpamResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (IpamResourceTag)((IpamResourceTag.Builder)IpamResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getIpUsage() {
            return this.ipUsage;
        }

        public final void setIpUsage(Double ipUsage) {
            this.ipUsage = ipUsage;
        }

        @Override
        public final Builder ipUsage(Double ipUsage) {
            this.ipUsage = ipUsage;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getNetworkInterfaceAttachmentStatus() {
            return this.networkInterfaceAttachmentStatus;
        }

        public final void setNetworkInterfaceAttachmentStatus(String networkInterfaceAttachmentStatus) {
            this.networkInterfaceAttachmentStatus = networkInterfaceAttachmentStatus;
        }

        @Override
        public final Builder networkInterfaceAttachmentStatus(String networkInterfaceAttachmentStatus) {
            this.networkInterfaceAttachmentStatus = networkInterfaceAttachmentStatus;
            return this;
        }

        @Override
        public final Builder networkInterfaceAttachmentStatus(IpamNetworkInterfaceAttachmentStatus networkInterfaceAttachmentStatus) {
            this.networkInterfaceAttachmentStatus(networkInterfaceAttachmentStatus == null ? null : networkInterfaceAttachmentStatus.toString());
            return this;
        }

        public final Instant getSampleTime() {
            return this.sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public IpamDiscoveredResourceCidr build() {
            return new IpamDiscoveredResourceCidr(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamDiscoveredResourceCidr> {
        public Builder ipamResourceDiscoveryId(String var1);

        public Builder resourceRegion(String var1);

        public Builder resourceId(String var1);

        public Builder resourceOwnerId(String var1);

        public Builder resourceCidr(String var1);

        public Builder ipSource(String var1);

        public Builder ipSource(IpamResourceCidrIpSource var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IpamResourceType var1);

        public Builder resourceTags(Collection<IpamResourceTag> var1);

        public Builder resourceTags(IpamResourceTag ... var1);

        public Builder resourceTags(Consumer<IpamResourceTag.Builder> ... var1);

        public Builder ipUsage(Double var1);

        public Builder vpcId(String var1);

        public Builder subnetId(String var1);

        public Builder networkInterfaceAttachmentStatus(String var1);

        public Builder networkInterfaceAttachmentStatus(IpamNetworkInterfaceAttachmentStatus var1);

        public Builder sampleTime(Instant var1);

        public Builder availabilityZoneId(String var1);
    }
}

