/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.OperatorResponse;
import software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateVersion> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchTemplateId").getter(LaunchTemplateVersion.getter(LaunchTemplateVersion::launchTemplateId)).setter(LaunchTemplateVersion.setter(Builder::launchTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId").unmarshallLocationName("launchTemplateId").build()}).build();
    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchTemplateName").getter(LaunchTemplateVersion.getter(LaunchTemplateVersion::launchTemplateName)).setter(LaunchTemplateVersion.setter(Builder::launchTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName").unmarshallLocationName("launchTemplateName").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(LaunchTemplateVersion.getter(LaunchTemplateVersion::versionNumber)).setter(LaunchTemplateVersion.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").unmarshallLocationName("versionNumber").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(LaunchTemplateVersion.getter(LaunchTemplateVersion::versionDescription)).setter(LaunchTemplateVersion.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").unmarshallLocationName("versionDescription").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(LaunchTemplateVersion.getter(LaunchTemplateVersion::createTime)).setter(LaunchTemplateVersion.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(LaunchTemplateVersion.getter(LaunchTemplateVersion::createdBy)).setter(LaunchTemplateVersion.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").unmarshallLocationName("createdBy").build()}).build();
    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultVersion").getter(LaunchTemplateVersion.getter(LaunchTemplateVersion::defaultVersion)).setter(LaunchTemplateVersion.setter(Builder::defaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersion").unmarshallLocationName("defaultVersion").build()}).build();
    private static final SdkField<ResponseLaunchTemplateData> LAUNCH_TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateData").getter(LaunchTemplateVersion.getter(LaunchTemplateVersion::launchTemplateData)).setter(LaunchTemplateVersion.setter(Builder::launchTemplateData)).constructor(ResponseLaunchTemplateData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateData").unmarshallLocationName("launchTemplateData").build()}).build();
    private static final SdkField<OperatorResponse> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operator").getter(LaunchTemplateVersion.getter(LaunchTemplateVersion::operator)).setter(LaunchTemplateVersion.setter(Builder::operator)).constructor(OperatorResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").unmarshallLocationName("operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD, LAUNCH_TEMPLATE_NAME_FIELD, VERSION_NUMBER_FIELD, VERSION_DESCRIPTION_FIELD, CREATE_TIME_FIELD, CREATED_BY_FIELD, DEFAULT_VERSION_FIELD, LAUNCH_TEMPLATE_DATA_FIELD, OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LaunchTemplateId", LAUNCH_TEMPLATE_ID_FIELD);
            this.put("LaunchTemplateName", LAUNCH_TEMPLATE_NAME_FIELD);
            this.put("VersionNumber", VERSION_NUMBER_FIELD);
            this.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("CreatedBy", CREATED_BY_FIELD);
            this.put("DefaultVersion", DEFAULT_VERSION_FIELD);
            this.put("LaunchTemplateData", LAUNCH_TEMPLATE_DATA_FIELD);
            this.put("Operator", OPERATOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String launchTemplateId;
    private final String launchTemplateName;
    private final Long versionNumber;
    private final String versionDescription;
    private final Instant createTime;
    private final String createdBy;
    private final Boolean defaultVersion;
    private final ResponseLaunchTemplateData launchTemplateData;
    private final OperatorResponse operator;

    private LaunchTemplateVersion(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.versionNumber = builder.versionNumber;
        this.versionDescription = builder.versionDescription;
        this.createTime = builder.createTime;
        this.createdBy = builder.createdBy;
        this.defaultVersion = builder.defaultVersion;
        this.launchTemplateData = builder.launchTemplateData;
        this.operator = builder.operator;
    }

    public final String launchTemplateId() {
        return this.launchTemplateId;
    }

    public final String launchTemplateName() {
        return this.launchTemplateName;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Boolean defaultVersion() {
        return this.defaultVersion;
    }

    public final ResponseLaunchTemplateData launchTemplateData() {
        return this.launchTemplateData;
    }

    public final OperatorResponse operator() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateVersion)) {
            return false;
        }
        LaunchTemplateVersion other = (LaunchTemplateVersion)obj;
        return Objects.equals(this.launchTemplateId(), other.launchTemplateId()) && Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.defaultVersion(), other.defaultVersion()) && Objects.equals(this.launchTemplateData(), other.launchTemplateData()) && Objects.equals(this.operator(), other.operator());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateVersion").add("LaunchTemplateId", (Object)this.launchTemplateId()).add("LaunchTemplateName", (Object)this.launchTemplateName()).add("VersionNumber", (Object)this.versionNumber()).add("VersionDescription", (Object)this.versionDescription()).add("CreateTime", (Object)this.createTime()).add("CreatedBy", (Object)this.createdBy()).add("DefaultVersion", (Object)this.defaultVersion()).add("LaunchTemplateData", (Object)this.launchTemplateData()).add("Operator", (Object)this.operator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateId": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateId()));
            }
            case "LaunchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "DefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.defaultVersion()));
            }
            case "LaunchTemplateData": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateData()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateVersion, T> g) {
        return obj -> g.apply((LaunchTemplateVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchTemplateId;
        private String launchTemplateName;
        private Long versionNumber;
        private String versionDescription;
        private Instant createTime;
        private String createdBy;
        private Boolean defaultVersion;
        private ResponseLaunchTemplateData launchTemplateData;
        private OperatorResponse operator;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateVersion model) {
            this.launchTemplateId(model.launchTemplateId);
            this.launchTemplateName(model.launchTemplateName);
            this.versionNumber(model.versionNumber);
            this.versionDescription(model.versionDescription);
            this.createTime(model.createTime);
            this.createdBy(model.createdBy);
            this.defaultVersion(model.defaultVersion);
            this.launchTemplateData(model.launchTemplateData);
            this.operator(model.operator);
        }

        public final String getLaunchTemplateId() {
            return this.launchTemplateId;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Boolean getDefaultVersion() {
            return this.defaultVersion;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final ResponseLaunchTemplateData.Builder getLaunchTemplateData() {
            return this.launchTemplateData != null ? this.launchTemplateData.toBuilder() : null;
        }

        public final void setLaunchTemplateData(ResponseLaunchTemplateData.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        @Override
        public final Builder launchTemplateData(ResponseLaunchTemplateData launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final OperatorResponse.Builder getOperator() {
            return this.operator != null ? this.operator.toBuilder() : null;
        }

        public final void setOperator(OperatorResponse.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorResponse operator) {
            this.operator = operator;
            return this;
        }

        public LaunchTemplateVersion build() {
            return new LaunchTemplateVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateVersion> {
        public Builder launchTemplateId(String var1);

        public Builder launchTemplateName(String var1);

        public Builder versionNumber(Long var1);

        public Builder versionDescription(String var1);

        public Builder createTime(Instant var1);

        public Builder createdBy(String var1);

        public Builder defaultVersion(Boolean var1);

        public Builder launchTemplateData(ResponseLaunchTemplateData var1);

        default public Builder launchTemplateData(Consumer<ResponseLaunchTemplateData.Builder> launchTemplateData) {
            return this.launchTemplateData((ResponseLaunchTemplateData)((ResponseLaunchTemplateData.Builder)ResponseLaunchTemplateData.builder().applyMutation(launchTemplateData)).build());
        }

        public Builder operator(OperatorResponse var1);

        default public Builder operator(Consumer<OperatorResponse.Builder> operator) {
            return this.operator((OperatorResponse)((OperatorResponse.Builder)OperatorResponse.builder().applyMutation(operator)).build());
        }
    }
}

