/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointTarget;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVerifiedAccessEndpointTargetsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetVerifiedAccessEndpointTargetsResponse> {
    private static final SdkField<List<VerifiedAccessEndpointTarget>> VERIFIED_ACCESS_ENDPOINT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VerifiedAccessEndpointTargets").getter(GetVerifiedAccessEndpointTargetsResponse.getter(GetVerifiedAccessEndpointTargetsResponse::verifiedAccessEndpointTargets)).setter(GetVerifiedAccessEndpointTargetsResponse.setter(Builder::verifiedAccessEndpointTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointTargetSet").unmarshallLocationName("verifiedAccessEndpointTargetSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VerifiedAccessEndpointTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetVerifiedAccessEndpointTargetsResponse.getter(GetVerifiedAccessEndpointTargetsResponse::nextToken)).setter(GetVerifiedAccessEndpointTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_ENDPOINT_TARGETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VerifiedAccessEndpointTargetSet", VERIFIED_ACCESS_ENDPOINT_TARGETS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<VerifiedAccessEndpointTarget> verifiedAccessEndpointTargets;
    private final String nextToken;

    private GetVerifiedAccessEndpointTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessEndpointTargets = builder.verifiedAccessEndpointTargets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVerifiedAccessEndpointTargets() {
        return this.verifiedAccessEndpointTargets != null && !(this.verifiedAccessEndpointTargets instanceof SdkAutoConstructList);
    }

    public final List<VerifiedAccessEndpointTarget> verifiedAccessEndpointTargets() {
        return this.verifiedAccessEndpointTargets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVerifiedAccessEndpointTargets() ? this.verifiedAccessEndpointTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVerifiedAccessEndpointTargetsResponse)) {
            return false;
        }
        GetVerifiedAccessEndpointTargetsResponse other = (GetVerifiedAccessEndpointTargetsResponse)((Object)obj);
        return this.hasVerifiedAccessEndpointTargets() == other.hasVerifiedAccessEndpointTargets() && Objects.equals(this.verifiedAccessEndpointTargets(), other.verifiedAccessEndpointTargets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetVerifiedAccessEndpointTargetsResponse").add("VerifiedAccessEndpointTargets", this.hasVerifiedAccessEndpointTargets() ? this.verifiedAccessEndpointTargets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessEndpointTargets": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessEndpointTargets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetVerifiedAccessEndpointTargetsResponse, T> g) {
        return obj -> g.apply((GetVerifiedAccessEndpointTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VerifiedAccessEndpointTarget> verifiedAccessEndpointTargets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVerifiedAccessEndpointTargetsResponse model) {
            super(model);
            this.verifiedAccessEndpointTargets(model.verifiedAccessEndpointTargets);
            this.nextToken(model.nextToken);
        }

        public final List<VerifiedAccessEndpointTarget.Builder> getVerifiedAccessEndpointTargets() {
            List<VerifiedAccessEndpointTarget.Builder> result = VerifiedAccessEndpointTargetListCopier.copyToBuilder(this.verifiedAccessEndpointTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVerifiedAccessEndpointTargets(Collection<VerifiedAccessEndpointTarget.BuilderImpl> verifiedAccessEndpointTargets) {
            this.verifiedAccessEndpointTargets = VerifiedAccessEndpointTargetListCopier.copyFromBuilder(verifiedAccessEndpointTargets);
        }

        @Override
        public final Builder verifiedAccessEndpointTargets(Collection<VerifiedAccessEndpointTarget> verifiedAccessEndpointTargets) {
            this.verifiedAccessEndpointTargets = VerifiedAccessEndpointTargetListCopier.copy(verifiedAccessEndpointTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessEndpointTargets(VerifiedAccessEndpointTarget ... verifiedAccessEndpointTargets) {
            this.verifiedAccessEndpointTargets(Arrays.asList(verifiedAccessEndpointTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessEndpointTargets(Consumer<VerifiedAccessEndpointTarget.Builder> ... verifiedAccessEndpointTargets) {
            this.verifiedAccessEndpointTargets(Stream.of(verifiedAccessEndpointTargets).map(c -> (VerifiedAccessEndpointTarget)((VerifiedAccessEndpointTarget.Builder)VerifiedAccessEndpointTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetVerifiedAccessEndpointTargetsResponse build() {
            return new GetVerifiedAccessEndpointTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVerifiedAccessEndpointTargetsResponse> {
        public Builder verifiedAccessEndpointTargets(Collection<VerifiedAccessEndpointTarget> var1);

        public Builder verifiedAccessEndpointTargets(VerifiedAccessEndpointTarget ... var1);

        public Builder verifiedAccessEndpointTargets(Consumer<VerifiedAccessEndpointTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

