/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SnapshotState;
import software.amazon.awssdk.services.ec2.model.StorageTier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TieringOperationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotTierStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotTierStatus> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(SnapshotTierStatus.getter(SnapshotTierStatus::snapshotId)).setter(SnapshotTierStatus.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(SnapshotTierStatus.getter(SnapshotTierStatus::volumeId)).setter(SnapshotTierStatus.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SnapshotTierStatus.getter(SnapshotTierStatus::statusAsString)).setter(SnapshotTierStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(SnapshotTierStatus.getter(SnapshotTierStatus::ownerId)).setter(SnapshotTierStatus.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SnapshotTierStatus.getter(SnapshotTierStatus::tags)).setter(SnapshotTierStatus.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STORAGE_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageTier").getter(SnapshotTierStatus.getter(SnapshotTierStatus::storageTierAsString)).setter(SnapshotTierStatus.setter(Builder::storageTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageTier").unmarshallLocationName("storageTier").build()}).build();
    private static final SdkField<Instant> LAST_TIERING_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastTieringStartTime").getter(SnapshotTierStatus.getter(SnapshotTierStatus::lastTieringStartTime)).setter(SnapshotTierStatus.setter(Builder::lastTieringStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastTieringStartTime").unmarshallLocationName("lastTieringStartTime").build()}).build();
    private static final SdkField<Integer> LAST_TIERING_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LastTieringProgress").getter(SnapshotTierStatus.getter(SnapshotTierStatus::lastTieringProgress)).setter(SnapshotTierStatus.setter(Builder::lastTieringProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastTieringProgress").unmarshallLocationName("lastTieringProgress").build()}).build();
    private static final SdkField<String> LAST_TIERING_OPERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastTieringOperationStatus").getter(SnapshotTierStatus.getter(SnapshotTierStatus::lastTieringOperationStatusAsString)).setter(SnapshotTierStatus.setter(Builder::lastTieringOperationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastTieringOperationStatus").unmarshallLocationName("lastTieringOperationStatus").build()}).build();
    private static final SdkField<String> LAST_TIERING_OPERATION_STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastTieringOperationStatusDetail").getter(SnapshotTierStatus.getter(SnapshotTierStatus::lastTieringOperationStatusDetail)).setter(SnapshotTierStatus.setter(Builder::lastTieringOperationStatusDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastTieringOperationStatusDetail").unmarshallLocationName("lastTieringOperationStatusDetail").build()}).build();
    private static final SdkField<Instant> ARCHIVAL_COMPLETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ArchivalCompleteTime").getter(SnapshotTierStatus.getter(SnapshotTierStatus::archivalCompleteTime)).setter(SnapshotTierStatus.setter(Builder::archivalCompleteTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivalCompleteTime").unmarshallLocationName("archivalCompleteTime").build()}).build();
    private static final SdkField<Instant> RESTORE_EXPIRY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RestoreExpiryTime").getter(SnapshotTierStatus.getter(SnapshotTierStatus::restoreExpiryTime)).setter(SnapshotTierStatus.setter(Builder::restoreExpiryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreExpiryTime").unmarshallLocationName("restoreExpiryTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, VOLUME_ID_FIELD, STATUS_FIELD, OWNER_ID_FIELD, TAGS_FIELD, STORAGE_TIER_FIELD, LAST_TIERING_START_TIME_FIELD, LAST_TIERING_PROGRESS_FIELD, LAST_TIERING_OPERATION_STATUS_FIELD, LAST_TIERING_OPERATION_STATUS_DETAIL_FIELD, ARCHIVAL_COMPLETE_TIME_FIELD, RESTORE_EXPIRY_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SnapshotId", SNAPSHOT_ID_FIELD);
            this.put("VolumeId", VOLUME_ID_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("OwnerId", OWNER_ID_FIELD);
            this.put("TagSet", TAGS_FIELD);
            this.put("StorageTier", STORAGE_TIER_FIELD);
            this.put("LastTieringStartTime", LAST_TIERING_START_TIME_FIELD);
            this.put("LastTieringProgress", LAST_TIERING_PROGRESS_FIELD);
            this.put("LastTieringOperationStatus", LAST_TIERING_OPERATION_STATUS_FIELD);
            this.put("LastTieringOperationStatusDetail", LAST_TIERING_OPERATION_STATUS_DETAIL_FIELD);
            this.put("ArchivalCompleteTime", ARCHIVAL_COMPLETE_TIME_FIELD);
            this.put("RestoreExpiryTime", RESTORE_EXPIRY_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String snapshotId;
    private final String volumeId;
    private final String status;
    private final String ownerId;
    private final List<Tag> tags;
    private final String storageTier;
    private final Instant lastTieringStartTime;
    private final Integer lastTieringProgress;
    private final String lastTieringOperationStatus;
    private final String lastTieringOperationStatusDetail;
    private final Instant archivalCompleteTime;
    private final Instant restoreExpiryTime;

    private SnapshotTierStatus(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.volumeId = builder.volumeId;
        this.status = builder.status;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
        this.storageTier = builder.storageTier;
        this.lastTieringStartTime = builder.lastTieringStartTime;
        this.lastTieringProgress = builder.lastTieringProgress;
        this.lastTieringOperationStatus = builder.lastTieringOperationStatus;
        this.lastTieringOperationStatusDetail = builder.lastTieringOperationStatusDetail;
        this.archivalCompleteTime = builder.archivalCompleteTime;
        this.restoreExpiryTime = builder.restoreExpiryTime;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final SnapshotState status() {
        return SnapshotState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final StorageTier storageTier() {
        return StorageTier.fromValue(this.storageTier);
    }

    public final String storageTierAsString() {
        return this.storageTier;
    }

    public final Instant lastTieringStartTime() {
        return this.lastTieringStartTime;
    }

    public final Integer lastTieringProgress() {
        return this.lastTieringProgress;
    }

    public final TieringOperationStatus lastTieringOperationStatus() {
        return TieringOperationStatus.fromValue(this.lastTieringOperationStatus);
    }

    public final String lastTieringOperationStatusAsString() {
        return this.lastTieringOperationStatus;
    }

    public final String lastTieringOperationStatusDetail() {
        return this.lastTieringOperationStatusDetail;
    }

    public final Instant archivalCompleteTime() {
        return this.archivalCompleteTime;
    }

    public final Instant restoreExpiryTime() {
        return this.restoreExpiryTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastTieringStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastTieringProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastTieringOperationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastTieringOperationStatusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.archivalCompleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreExpiryTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotTierStatus)) {
            return false;
        }
        SnapshotTierStatus other = (SnapshotTierStatus)obj;
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.ownerId(), other.ownerId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.storageTierAsString(), other.storageTierAsString()) && Objects.equals(this.lastTieringStartTime(), other.lastTieringStartTime()) && Objects.equals(this.lastTieringProgress(), other.lastTieringProgress()) && Objects.equals(this.lastTieringOperationStatusAsString(), other.lastTieringOperationStatusAsString()) && Objects.equals(this.lastTieringOperationStatusDetail(), other.lastTieringOperationStatusDetail()) && Objects.equals(this.archivalCompleteTime(), other.archivalCompleteTime()) && Objects.equals(this.restoreExpiryTime(), other.restoreExpiryTime());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotTierStatus").add("SnapshotId", (Object)this.snapshotId()).add("VolumeId", (Object)this.volumeId()).add("Status", (Object)this.statusAsString()).add("OwnerId", (Object)this.ownerId()).add("Tags", this.hasTags() ? this.tags() : null).add("StorageTier", (Object)this.storageTierAsString()).add("LastTieringStartTime", (Object)this.lastTieringStartTime()).add("LastTieringProgress", (Object)this.lastTieringProgress()).add("LastTieringOperationStatus", (Object)this.lastTieringOperationStatusAsString()).add("LastTieringOperationStatusDetail", (Object)this.lastTieringOperationStatusDetail()).add("ArchivalCompleteTime", (Object)this.archivalCompleteTime()).add("RestoreExpiryTime", (Object)this.restoreExpiryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StorageTier": {
                return Optional.ofNullable(clazz.cast(this.storageTierAsString()));
            }
            case "LastTieringStartTime": {
                return Optional.ofNullable(clazz.cast(this.lastTieringStartTime()));
            }
            case "LastTieringProgress": {
                return Optional.ofNullable(clazz.cast(this.lastTieringProgress()));
            }
            case "LastTieringOperationStatus": {
                return Optional.ofNullable(clazz.cast(this.lastTieringOperationStatusAsString()));
            }
            case "LastTieringOperationStatusDetail": {
                return Optional.ofNullable(clazz.cast(this.lastTieringOperationStatusDetail()));
            }
            case "ArchivalCompleteTime": {
                return Optional.ofNullable(clazz.cast(this.archivalCompleteTime()));
            }
            case "RestoreExpiryTime": {
                return Optional.ofNullable(clazz.cast(this.restoreExpiryTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotTierStatus, T> g) {
        return obj -> g.apply((SnapshotTierStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotId;
        private String volumeId;
        private String status;
        private String ownerId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String storageTier;
        private Instant lastTieringStartTime;
        private Integer lastTieringProgress;
        private String lastTieringOperationStatus;
        private String lastTieringOperationStatusDetail;
        private Instant archivalCompleteTime;
        private Instant restoreExpiryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotTierStatus model) {
            this.snapshotId(model.snapshotId);
            this.volumeId(model.volumeId);
            this.status(model.status);
            this.ownerId(model.ownerId);
            this.tags(model.tags);
            this.storageTier(model.storageTier);
            this.lastTieringStartTime(model.lastTieringStartTime);
            this.lastTieringProgress(model.lastTieringProgress);
            this.lastTieringOperationStatus(model.lastTieringOperationStatus);
            this.lastTieringOperationStatusDetail(model.lastTieringOperationStatusDetail);
            this.archivalCompleteTime(model.archivalCompleteTime);
            this.restoreExpiryTime(model.restoreExpiryTime);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SnapshotState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStorageTier() {
            return this.storageTier;
        }

        public final void setStorageTier(String storageTier) {
            this.storageTier = storageTier;
        }

        @Override
        public final Builder storageTier(String storageTier) {
            this.storageTier = storageTier;
            return this;
        }

        @Override
        public final Builder storageTier(StorageTier storageTier) {
            this.storageTier(storageTier == null ? null : storageTier.toString());
            return this;
        }

        public final Instant getLastTieringStartTime() {
            return this.lastTieringStartTime;
        }

        public final void setLastTieringStartTime(Instant lastTieringStartTime) {
            this.lastTieringStartTime = lastTieringStartTime;
        }

        @Override
        public final Builder lastTieringStartTime(Instant lastTieringStartTime) {
            this.lastTieringStartTime = lastTieringStartTime;
            return this;
        }

        public final Integer getLastTieringProgress() {
            return this.lastTieringProgress;
        }

        public final void setLastTieringProgress(Integer lastTieringProgress) {
            this.lastTieringProgress = lastTieringProgress;
        }

        @Override
        public final Builder lastTieringProgress(Integer lastTieringProgress) {
            this.lastTieringProgress = lastTieringProgress;
            return this;
        }

        public final String getLastTieringOperationStatus() {
            return this.lastTieringOperationStatus;
        }

        public final void setLastTieringOperationStatus(String lastTieringOperationStatus) {
            this.lastTieringOperationStatus = lastTieringOperationStatus;
        }

        @Override
        public final Builder lastTieringOperationStatus(String lastTieringOperationStatus) {
            this.lastTieringOperationStatus = lastTieringOperationStatus;
            return this;
        }

        @Override
        public final Builder lastTieringOperationStatus(TieringOperationStatus lastTieringOperationStatus) {
            this.lastTieringOperationStatus(lastTieringOperationStatus == null ? null : lastTieringOperationStatus.toString());
            return this;
        }

        public final String getLastTieringOperationStatusDetail() {
            return this.lastTieringOperationStatusDetail;
        }

        public final void setLastTieringOperationStatusDetail(String lastTieringOperationStatusDetail) {
            this.lastTieringOperationStatusDetail = lastTieringOperationStatusDetail;
        }

        @Override
        public final Builder lastTieringOperationStatusDetail(String lastTieringOperationStatusDetail) {
            this.lastTieringOperationStatusDetail = lastTieringOperationStatusDetail;
            return this;
        }

        public final Instant getArchivalCompleteTime() {
            return this.archivalCompleteTime;
        }

        public final void setArchivalCompleteTime(Instant archivalCompleteTime) {
            this.archivalCompleteTime = archivalCompleteTime;
        }

        @Override
        public final Builder archivalCompleteTime(Instant archivalCompleteTime) {
            this.archivalCompleteTime = archivalCompleteTime;
            return this;
        }

        public final Instant getRestoreExpiryTime() {
            return this.restoreExpiryTime;
        }

        public final void setRestoreExpiryTime(Instant restoreExpiryTime) {
            this.restoreExpiryTime = restoreExpiryTime;
        }

        @Override
        public final Builder restoreExpiryTime(Instant restoreExpiryTime) {
            this.restoreExpiryTime = restoreExpiryTime;
            return this;
        }

        public SnapshotTierStatus build() {
            return new SnapshotTierStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotTierStatus> {
        public Builder snapshotId(String var1);

        public Builder volumeId(String var1);

        public Builder status(String var1);

        public Builder status(SnapshotState var1);

        public Builder ownerId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder storageTier(String var1);

        public Builder storageTier(StorageTier var1);

        public Builder lastTieringStartTime(Instant var1);

        public Builder lastTieringProgress(Integer var1);

        public Builder lastTieringOperationStatus(String var1);

        public Builder lastTieringOperationStatus(TieringOperationStatus var1);

        public Builder lastTieringOperationStatusDetail(String var1);

        public Builder archivalCompleteTime(Instant var1);

        public Builder restoreExpiryTime(Instant var1);
    }
}

