/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.services.ec2.model.CapacityReservationSpecification;
import software.amazon.awssdk.services.ec2.model.CpuOptionsRequest;
import software.amazon.awssdk.services.ec2.model.CreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecificationsCopier;
import software.amazon.awssdk.services.ec2.model.ElasticInferenceAccelerator;
import software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorsCopier;
import software.amazon.awssdk.services.ec2.model.EnclaveOptionsRequest;
import software.amazon.awssdk.services.ec2.model.HibernationOptionsRequest;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptionsRequest;
import software.amazon.awssdk.services.ec2.model.InstanceMarketOptionsRequest;
import software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.ec2.model.LicenseConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.LicenseSpecificationListRequestCopier;
import software.amazon.awssdk.services.ec2.model.OperatorRequest;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesMonitoringEnabled;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunInstancesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, RunInstancesRequest> {
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(RunInstancesRequest.getter(RunInstancesRequest::blockDeviceMappings)).setter(RunInstancesRequest.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build(), ListTrait.builder().memberLocationName("BlockDeviceMapping").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(RunInstancesRequest.getter(RunInstancesRequest::imageId)).setter(RunInstancesRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(RunInstancesRequest.getter(RunInstancesRequest::instanceTypeAsString)).setter(RunInstancesRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6AddressCount").getter(RunInstancesRequest.getter(RunInstancesRequest::ipv6AddressCount)).setter(RunInstancesRequest.setter(Builder::ipv6AddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").unmarshallLocationName("Ipv6AddressCount").build()}).build();
    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(RunInstancesRequest.getter(RunInstancesRequest::ipv6Addresses)).setter(RunInstancesRequest.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address").unmarshallLocationName("Ipv6Address").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIpv6Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(RunInstancesRequest.getter(RunInstancesRequest::kernelId)).setter(RunInstancesRequest.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").unmarshallLocationName("KernelId").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(RunInstancesRequest.getter(RunInstancesRequest::keyName)).setter(RunInstancesRequest.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("KeyName").build()}).build();
    private static final SdkField<Integer> MAX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCount").getter(RunInstancesRequest.getter(RunInstancesRequest::maxCount)).setter(RunInstancesRequest.setter(Builder::maxCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCount").unmarshallLocationName("MaxCount").build()}).build();
    private static final SdkField<Integer> MIN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinCount").getter(RunInstancesRequest.getter(RunInstancesRequest::minCount)).setter(RunInstancesRequest.setter(Builder::minCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCount").unmarshallLocationName("MinCount").build()}).build();
    private static final SdkField<RunInstancesMonitoringEnabled> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Monitoring").getter(RunInstancesRequest.getter(RunInstancesRequest::monitoring)).setter(RunInstancesRequest.setter(Builder::monitoring)).constructor(RunInstancesMonitoringEnabled::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").unmarshallLocationName("Monitoring").build()}).build();
    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(RunInstancesRequest.getter(RunInstancesRequest::placement)).setter(RunInstancesRequest.setter(Builder::placement)).constructor(Placement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("Placement").build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamdiskId").getter(RunInstancesRequest.getter(RunInstancesRequest::ramdiskId)).setter(RunInstancesRequest.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").unmarshallLocationName("RamdiskId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(RunInstancesRequest.getter(RunInstancesRequest::securityGroupIds)).setter(RunInstancesRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(RunInstancesRequest.getter(RunInstancesRequest::securityGroups)).setter(RunInstancesRequest.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").unmarshallLocationName("SecurityGroup").build(), ListTrait.builder().memberLocationName("SecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").unmarshallLocationName("SecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(RunInstancesRequest.getter(RunInstancesRequest::subnetId)).setter(RunInstancesRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserData").getter(RunInstancesRequest.getter(RunInstancesRequest::userData)).setter(RunInstancesRequest.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").unmarshallLocationName("UserData").build()}).build();
    private static final SdkField<List<ElasticGpuSpecification>> ELASTIC_GPU_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticGpuSpecification").getter(RunInstancesRequest.getter(RunInstancesRequest::elasticGpuSpecification)).setter(RunInstancesRequest.setter(Builder::elasticGpuSpecification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecification").unmarshallLocationName("ElasticGpuSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticGpuSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ElasticInferenceAccelerator>> ELASTIC_INFERENCE_ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticInferenceAccelerators").getter(RunInstancesRequest.getter(RunInstancesRequest::elasticInferenceAccelerators)).setter(RunInstancesRequest.setter(Builder::elasticInferenceAccelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAccelerator").unmarshallLocationName("ElasticInferenceAccelerator").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticInferenceAccelerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(RunInstancesRequest.getter(RunInstancesRequest::tagSpecifications)).setter(RunInstancesRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplate").getter(RunInstancesRequest.getter(RunInstancesRequest::launchTemplate)).setter(RunInstancesRequest.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").unmarshallLocationName("LaunchTemplate").build()}).build();
    private static final SdkField<InstanceMarketOptionsRequest> INSTANCE_MARKET_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMarketOptions").getter(RunInstancesRequest.getter(RunInstancesRequest::instanceMarketOptions)).setter(RunInstancesRequest.setter(Builder::instanceMarketOptions)).constructor(InstanceMarketOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions").unmarshallLocationName("InstanceMarketOptions").build()}).build();
    private static final SdkField<CreditSpecificationRequest> CREDIT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreditSpecification").getter(RunInstancesRequest.getter(RunInstancesRequest::creditSpecification)).setter(RunInstancesRequest.setter(Builder::creditSpecification)).constructor(CreditSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification").unmarshallLocationName("CreditSpecification").build()}).build();
    private static final SdkField<CpuOptionsRequest> CPU_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CpuOptions").getter(RunInstancesRequest.getter(RunInstancesRequest::cpuOptions)).setter(RunInstancesRequest.setter(Builder::cpuOptions)).constructor(CpuOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions").unmarshallLocationName("CpuOptions").build()}).build();
    private static final SdkField<CapacityReservationSpecification> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationSpecification").getter(RunInstancesRequest.getter(RunInstancesRequest::capacityReservationSpecification)).setter(RunInstancesRequest.setter(Builder::capacityReservationSpecification)).constructor(CapacityReservationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification").unmarshallLocationName("CapacityReservationSpecification").build()}).build();
    private static final SdkField<HibernationOptionsRequest> HIBERNATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HibernationOptions").getter(RunInstancesRequest.getter(RunInstancesRequest::hibernationOptions)).setter(RunInstancesRequest.setter(Builder::hibernationOptions)).constructor(HibernationOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions").unmarshallLocationName("HibernationOptions").build()}).build();
    private static final SdkField<List<LicenseConfigurationRequest>> LICENSE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseSpecifications").getter(RunInstancesRequest.getter(RunInstancesRequest::licenseSpecifications)).setter(RunInstancesRequest.setter(Builder::licenseSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecification").unmarshallLocationName("LicenseSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<InstanceMetadataOptionsRequest> METADATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataOptions").getter(RunInstancesRequest.getter(RunInstancesRequest::metadataOptions)).setter(RunInstancesRequest.setter(Builder::metadataOptions)).constructor(InstanceMetadataOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").unmarshallLocationName("MetadataOptions").build()}).build();
    private static final SdkField<EnclaveOptionsRequest> ENCLAVE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnclaveOptions").getter(RunInstancesRequest.getter(RunInstancesRequest::enclaveOptions)).setter(RunInstancesRequest.setter(Builder::enclaveOptions)).constructor(EnclaveOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions").unmarshallLocationName("EnclaveOptions").build()}).build();
    private static final SdkField<PrivateDnsNameOptionsRequest> PRIVATE_DNS_NAME_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateDnsNameOptions").getter(RunInstancesRequest.getter(RunInstancesRequest::privateDnsNameOptions)).setter(RunInstancesRequest.setter(Builder::privateDnsNameOptions)).constructor(PrivateDnsNameOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameOptions").unmarshallLocationName("PrivateDnsNameOptions").build()}).build();
    private static final SdkField<InstanceMaintenanceOptionsRequest> MAINTENANCE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceOptions").getter(RunInstancesRequest.getter(RunInstancesRequest::maintenanceOptions)).setter(RunInstancesRequest.setter(Builder::maintenanceOptions)).constructor(InstanceMaintenanceOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceOptions").unmarshallLocationName("MaintenanceOptions").build()}).build();
    private static final SdkField<Boolean> DISABLE_API_STOP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableApiStop").getter(RunInstancesRequest.getter(RunInstancesRequest::disableApiStop)).setter(RunInstancesRequest.setter(Builder::disableApiStop)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiStop").unmarshallLocationName("DisableApiStop").build()}).build();
    private static final SdkField<Boolean> ENABLE_PRIMARY_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePrimaryIpv6").getter(RunInstancesRequest.getter(RunInstancesRequest::enablePrimaryIpv6)).setter(RunInstancesRequest.setter(Builder::enablePrimaryIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrimaryIpv6").unmarshallLocationName("EnablePrimaryIpv6").build()}).build();
    private static final SdkField<OperatorRequest> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operator").getter(RunInstancesRequest.getter(RunInstancesRequest::operator)).setter(RunInstancesRequest.setter(Builder::operator)).constructor(OperatorRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").unmarshallLocationName("Operator").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(RunInstancesRequest.getter(RunInstancesRequest::dryRun)).setter(RunInstancesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<Boolean> DISABLE_API_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableApiTermination").getter(RunInstancesRequest.getter(RunInstancesRequest::disableApiTermination)).setter(RunInstancesRequest.setter(Builder::disableApiTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination").unmarshallLocationName("disableApiTermination").build()}).build();
    private static final SdkField<String> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceInitiatedShutdownBehavior").getter(RunInstancesRequest.getter(RunInstancesRequest::instanceInitiatedShutdownBehaviorAsString)).setter(RunInstancesRequest.setter(Builder::instanceInitiatedShutdownBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior").unmarshallLocationName("instanceInitiatedShutdownBehavior").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(RunInstancesRequest.getter(RunInstancesRequest::privateIpAddress)).setter(RunInstancesRequest.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(RunInstancesRequest.getter(RunInstancesRequest::clientToken)).setter(RunInstancesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalInfo").getter(RunInstancesRequest.getter(RunInstancesRequest::additionalInfo)).setter(RunInstancesRequest.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo").unmarshallLocationName("additionalInfo").build()}).build();
    private static final SdkField<List<InstanceNetworkInterfaceSpecification>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaces").getter(RunInstancesRequest.getter(RunInstancesRequest::networkInterfaces)).setter(RunInstancesRequest.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface").unmarshallLocationName("networkInterface").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceNetworkInterfaceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<IamInstanceProfileSpecification> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(RunInstancesRequest.getter(RunInstancesRequest::iamInstanceProfile)).setter(RunInstancesRequest.setter(Builder::iamInstanceProfile)).constructor(IamInstanceProfileSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").unmarshallLocationName("iamInstanceProfile").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(RunInstancesRequest.getter(RunInstancesRequest::ebsOptimized)).setter(RunInstancesRequest.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("ebsOptimized").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD, IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, MAX_COUNT_FIELD, MIN_COUNT_FIELD, MONITORING_FIELD, PLACEMENT_FIELD, RAMDISK_ID_FIELD, SECURITY_GROUP_IDS_FIELD, SECURITY_GROUPS_FIELD, SUBNET_ID_FIELD, USER_DATA_FIELD, ELASTIC_GPU_SPECIFICATION_FIELD, ELASTIC_INFERENCE_ACCELERATORS_FIELD, TAG_SPECIFICATIONS_FIELD, LAUNCH_TEMPLATE_FIELD, INSTANCE_MARKET_OPTIONS_FIELD, CREDIT_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD, CAPACITY_RESERVATION_SPECIFICATION_FIELD, HIBERNATION_OPTIONS_FIELD, LICENSE_SPECIFICATIONS_FIELD, METADATA_OPTIONS_FIELD, ENCLAVE_OPTIONS_FIELD, PRIVATE_DNS_NAME_OPTIONS_FIELD, MAINTENANCE_OPTIONS_FIELD, DISABLE_API_STOP_FIELD, ENABLE_PRIMARY_IPV6_FIELD, OPERATOR_FIELD, DRY_RUN_FIELD, DISABLE_API_TERMINATION_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, PRIVATE_IP_ADDRESS_FIELD, CLIENT_TOKEN_FIELD, ADDITIONAL_INFO_FIELD, NETWORK_INTERFACES_FIELD, IAM_INSTANCE_PROFILE_FIELD, EBS_OPTIMIZED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BlockDeviceMapping", BLOCK_DEVICE_MAPPINGS_FIELD);
            this.put("ImageId", IMAGE_ID_FIELD);
            this.put("InstanceType", INSTANCE_TYPE_FIELD);
            this.put("Ipv6AddressCount", IPV6_ADDRESS_COUNT_FIELD);
            this.put("Ipv6Address", IPV6_ADDRESSES_FIELD);
            this.put("KernelId", KERNEL_ID_FIELD);
            this.put("KeyName", KEY_NAME_FIELD);
            this.put("MaxCount", MAX_COUNT_FIELD);
            this.put("MinCount", MIN_COUNT_FIELD);
            this.put("Monitoring", MONITORING_FIELD);
            this.put("Placement", PLACEMENT_FIELD);
            this.put("RamdiskId", RAMDISK_ID_FIELD);
            this.put("SecurityGroupId", SECURITY_GROUP_IDS_FIELD);
            this.put("SecurityGroup", SECURITY_GROUPS_FIELD);
            this.put("SubnetId", SUBNET_ID_FIELD);
            this.put("UserData", USER_DATA_FIELD);
            this.put("ElasticGpuSpecification", ELASTIC_GPU_SPECIFICATION_FIELD);
            this.put("ElasticInferenceAccelerator", ELASTIC_INFERENCE_ACCELERATORS_FIELD);
            this.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
            this.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
            this.put("InstanceMarketOptions", INSTANCE_MARKET_OPTIONS_FIELD);
            this.put("CreditSpecification", CREDIT_SPECIFICATION_FIELD);
            this.put("CpuOptions", CPU_OPTIONS_FIELD);
            this.put("CapacityReservationSpecification", CAPACITY_RESERVATION_SPECIFICATION_FIELD);
            this.put("HibernationOptions", HIBERNATION_OPTIONS_FIELD);
            this.put("LicenseSpecification", LICENSE_SPECIFICATIONS_FIELD);
            this.put("MetadataOptions", METADATA_OPTIONS_FIELD);
            this.put("EnclaveOptions", ENCLAVE_OPTIONS_FIELD);
            this.put("PrivateDnsNameOptions", PRIVATE_DNS_NAME_OPTIONS_FIELD);
            this.put("MaintenanceOptions", MAINTENANCE_OPTIONS_FIELD);
            this.put("DisableApiStop", DISABLE_API_STOP_FIELD);
            this.put("EnablePrimaryIpv6", ENABLE_PRIMARY_IPV6_FIELD);
            this.put("Operator", OPERATOR_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("DisableApiTermination", DISABLE_API_TERMINATION_FIELD);
            this.put("InstanceInitiatedShutdownBehavior", INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD);
            this.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("AdditionalInfo", ADDITIONAL_INFO_FIELD);
            this.put("NetworkInterface", NETWORK_INTERFACES_FIELD);
            this.put("IamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
            this.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        }
    });
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String imageId;
    private final String instanceType;
    private final Integer ipv6AddressCount;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final String kernelId;
    private final String keyName;
    private final Integer maxCount;
    private final Integer minCount;
    private final RunInstancesMonitoringEnabled monitoring;
    private final Placement placement;
    private final String ramdiskId;
    private final List<String> securityGroupIds;
    private final List<String> securityGroups;
    private final String subnetId;
    private final String userData;
    private final List<ElasticGpuSpecification> elasticGpuSpecification;
    private final List<ElasticInferenceAccelerator> elasticInferenceAccelerators;
    private final List<TagSpecification> tagSpecifications;
    private final LaunchTemplateSpecification launchTemplate;
    private final InstanceMarketOptionsRequest instanceMarketOptions;
    private final CreditSpecificationRequest creditSpecification;
    private final CpuOptionsRequest cpuOptions;
    private final CapacityReservationSpecification capacityReservationSpecification;
    private final HibernationOptionsRequest hibernationOptions;
    private final List<LicenseConfigurationRequest> licenseSpecifications;
    private final InstanceMetadataOptionsRequest metadataOptions;
    private final EnclaveOptionsRequest enclaveOptions;
    private final PrivateDnsNameOptionsRequest privateDnsNameOptions;
    private final InstanceMaintenanceOptionsRequest maintenanceOptions;
    private final Boolean disableApiStop;
    private final Boolean enablePrimaryIpv6;
    private final OperatorRequest operator;
    private final Boolean dryRun;
    private final Boolean disableApiTermination;
    private final String instanceInitiatedShutdownBehavior;
    private final String privateIpAddress;
    private final String clientToken;
    private final String additionalInfo;
    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final Boolean ebsOptimized;

    private RunInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.maxCount = builder.maxCount;
        this.minCount = builder.minCount;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
        this.elasticGpuSpecification = builder.elasticGpuSpecification;
        this.elasticInferenceAccelerators = builder.elasticInferenceAccelerators;
        this.tagSpecifications = builder.tagSpecifications;
        this.launchTemplate = builder.launchTemplate;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.creditSpecification = builder.creditSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.hibernationOptions = builder.hibernationOptions;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.metadataOptions = builder.metadataOptions;
        this.enclaveOptions = builder.enclaveOptions;
        this.privateDnsNameOptions = builder.privateDnsNameOptions;
        this.maintenanceOptions = builder.maintenanceOptions;
        this.disableApiStop = builder.disableApiStop;
        this.enablePrimaryIpv6 = builder.enablePrimaryIpv6;
        this.operator = builder.operator;
        this.dryRun = builder.dryRun;
        this.disableApiTermination = builder.disableApiTermination;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.privateIpAddress = builder.privateIpAddress;
        this.clientToken = builder.clientToken;
        this.additionalInfo = builder.additionalInfo;
        this.networkInterfaces = builder.networkInterfaces;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.ebsOptimized = builder.ebsOptimized;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final Integer maxCount() {
        return this.maxCount;
    }

    public final Integer minCount() {
        return this.minCount;
    }

    public final RunInstancesMonitoringEnabled monitoring() {
        return this.monitoring;
    }

    public final Placement placement() {
        return this.placement;
    }

    public final String ramdiskId() {
        return this.ramdiskId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String userData() {
        return this.userData;
    }

    public final boolean hasElasticGpuSpecification() {
        return this.elasticGpuSpecification != null && !(this.elasticGpuSpecification instanceof SdkAutoConstructList);
    }

    public final List<ElasticGpuSpecification> elasticGpuSpecification() {
        return this.elasticGpuSpecification;
    }

    public final boolean hasElasticInferenceAccelerators() {
        return this.elasticInferenceAccelerators != null && !(this.elasticInferenceAccelerators instanceof SdkAutoConstructList);
    }

    public final List<ElasticInferenceAccelerator> elasticInferenceAccelerators() {
        return this.elasticInferenceAccelerators;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public final InstanceMarketOptionsRequest instanceMarketOptions() {
        return this.instanceMarketOptions;
    }

    public final CreditSpecificationRequest creditSpecification() {
        return this.creditSpecification;
    }

    public final CpuOptionsRequest cpuOptions() {
        return this.cpuOptions;
    }

    public final CapacityReservationSpecification capacityReservationSpecification() {
        return this.capacityReservationSpecification;
    }

    public final HibernationOptionsRequest hibernationOptions() {
        return this.hibernationOptions;
    }

    public final boolean hasLicenseSpecifications() {
        return this.licenseSpecifications != null && !(this.licenseSpecifications instanceof SdkAutoConstructList);
    }

    public final List<LicenseConfigurationRequest> licenseSpecifications() {
        return this.licenseSpecifications;
    }

    public final InstanceMetadataOptionsRequest metadataOptions() {
        return this.metadataOptions;
    }

    public final EnclaveOptionsRequest enclaveOptions() {
        return this.enclaveOptions;
    }

    public final PrivateDnsNameOptionsRequest privateDnsNameOptions() {
        return this.privateDnsNameOptions;
    }

    public final InstanceMaintenanceOptionsRequest maintenanceOptions() {
        return this.maintenanceOptions;
    }

    public final Boolean disableApiStop() {
        return this.disableApiStop;
    }

    public final Boolean enablePrimaryIpv6() {
        return this.enablePrimaryIpv6;
    }

    public final OperatorRequest operator() {
        return this.operator;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public final ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(this.instanceInitiatedShutdownBehavior);
    }

    public final String instanceInitiatedShutdownBehaviorAsString() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String additionalInfo() {
        return this.additionalInfo;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticGpuSpecification() ? this.elasticGpuSpecification() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticInferenceAccelerators() ? this.elasticInferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseSpecifications() ? this.licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.enclaveOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsNameOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiStop());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePrimaryIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunInstancesRequest)) {
            return false;
        }
        RunInstancesRequest other = (RunInstancesRequest)((Object)obj);
        return this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.ipv6AddressCount(), other.ipv6AddressCount()) && this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.maxCount(), other.maxCount()) && Objects.equals(this.minCount(), other.minCount()) && Objects.equals(this.monitoring(), other.monitoring()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.userData(), other.userData()) && this.hasElasticGpuSpecification() == other.hasElasticGpuSpecification() && Objects.equals(this.elasticGpuSpecification(), other.elasticGpuSpecification()) && this.hasElasticInferenceAccelerators() == other.hasElasticInferenceAccelerators() && Objects.equals(this.elasticInferenceAccelerators(), other.elasticInferenceAccelerators()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.instanceMarketOptions(), other.instanceMarketOptions()) && Objects.equals(this.creditSpecification(), other.creditSpecification()) && Objects.equals(this.cpuOptions(), other.cpuOptions()) && Objects.equals(this.capacityReservationSpecification(), other.capacityReservationSpecification()) && Objects.equals(this.hibernationOptions(), other.hibernationOptions()) && this.hasLicenseSpecifications() == other.hasLicenseSpecifications() && Objects.equals(this.licenseSpecifications(), other.licenseSpecifications()) && Objects.equals(this.metadataOptions(), other.metadataOptions()) && Objects.equals(this.enclaveOptions(), other.enclaveOptions()) && Objects.equals(this.privateDnsNameOptions(), other.privateDnsNameOptions()) && Objects.equals(this.maintenanceOptions(), other.maintenanceOptions()) && Objects.equals(this.disableApiStop(), other.disableApiStop()) && Objects.equals(this.enablePrimaryIpv6(), other.enablePrimaryIpv6()) && Objects.equals(this.operator(), other.operator()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.disableApiTermination(), other.disableApiTermination()) && Objects.equals(this.instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.additionalInfo(), other.additionalInfo()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized());
    }

    public final String toString() {
        return ToString.builder((String)"RunInstancesRequest").add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("Ipv6AddressCount", (Object)this.ipv6AddressCount()).add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).add("KernelId", (Object)this.kernelId()).add("KeyName", (Object)this.keyName()).add("MaxCount", (Object)this.maxCount()).add("MinCount", (Object)this.minCount()).add("Monitoring", (Object)this.monitoring()).add("Placement", (Object)this.placement()).add("RamdiskId", (Object)this.ramdiskId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SubnetId", (Object)this.subnetId()).add("UserData", (Object)(this.userData() == null ? null : "*** Sensitive Data Redacted ***")).add("ElasticGpuSpecification", this.hasElasticGpuSpecification() ? this.elasticGpuSpecification() : null).add("ElasticInferenceAccelerators", this.hasElasticInferenceAccelerators() ? this.elasticInferenceAccelerators() : null).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("LaunchTemplate", (Object)this.launchTemplate()).add("InstanceMarketOptions", (Object)this.instanceMarketOptions()).add("CreditSpecification", (Object)this.creditSpecification()).add("CpuOptions", (Object)this.cpuOptions()).add("CapacityReservationSpecification", (Object)this.capacityReservationSpecification()).add("HibernationOptions", (Object)this.hibernationOptions()).add("LicenseSpecifications", this.hasLicenseSpecifications() ? this.licenseSpecifications() : null).add("MetadataOptions", (Object)this.metadataOptions()).add("EnclaveOptions", (Object)this.enclaveOptions()).add("PrivateDnsNameOptions", (Object)this.privateDnsNameOptions()).add("MaintenanceOptions", (Object)this.maintenanceOptions()).add("DisableApiStop", (Object)this.disableApiStop()).add("EnablePrimaryIpv6", (Object)this.enablePrimaryIpv6()).add("Operator", (Object)this.operator()).add("DryRun", (Object)this.dryRun()).add("DisableApiTermination", (Object)this.disableApiTermination()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehaviorAsString()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("ClientToken", (Object)this.clientToken()).add("AdditionalInfo", (Object)this.additionalInfo()).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("EbsOptimized", (Object)this.ebsOptimized()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "Ipv6AddressCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressCount()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "MaxCount": {
                return Optional.ofNullable(clazz.cast(this.maxCount()));
            }
            case "MinCount": {
                return Optional.ofNullable(clazz.cast(this.minCount()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "ElasticGpuSpecification": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuSpecification()));
            }
            case "ElasticInferenceAccelerators": {
                return Optional.ofNullable(clazz.cast(this.elasticInferenceAccelerators()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "InstanceMarketOptions": {
                return Optional.ofNullable(clazz.cast(this.instanceMarketOptions()));
            }
            case "CreditSpecification": {
                return Optional.ofNullable(clazz.cast(this.creditSpecification()));
            }
            case "CpuOptions": {
                return Optional.ofNullable(clazz.cast(this.cpuOptions()));
            }
            case "CapacityReservationSpecification": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationSpecification()));
            }
            case "HibernationOptions": {
                return Optional.ofNullable(clazz.cast(this.hibernationOptions()));
            }
            case "LicenseSpecifications": {
                return Optional.ofNullable(clazz.cast(this.licenseSpecifications()));
            }
            case "MetadataOptions": {
                return Optional.ofNullable(clazz.cast(this.metadataOptions()));
            }
            case "EnclaveOptions": {
                return Optional.ofNullable(clazz.cast(this.enclaveOptions()));
            }
            case "PrivateDnsNameOptions": {
                return Optional.ofNullable(clazz.cast(this.privateDnsNameOptions()));
            }
            case "MaintenanceOptions": {
                return Optional.ofNullable(clazz.cast(this.maintenanceOptions()));
            }
            case "DisableApiStop": {
                return Optional.ofNullable(clazz.cast(this.disableApiStop()));
            }
            case "EnablePrimaryIpv6": {
                return Optional.ofNullable(clazz.cast(this.enablePrimaryIpv6()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "DisableApiTermination": {
                return Optional.ofNullable(clazz.cast(this.disableApiTermination()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInitiatedShutdownBehaviorAsString()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "AdditionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RunInstancesRequest, T> g) {
        return obj -> g.apply((RunInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private String instanceType;
        private Integer ipv6AddressCount;
        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String kernelId;
        private String keyName;
        private Integer maxCount;
        private Integer minCount;
        private RunInstancesMonitoringEnabled monitoring;
        private Placement placement;
        private String ramdiskId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private String userData;
        private List<ElasticGpuSpecification> elasticGpuSpecification = DefaultSdkAutoConstructList.getInstance();
        private List<ElasticInferenceAccelerator> elasticInferenceAccelerators = DefaultSdkAutoConstructList.getInstance();
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private LaunchTemplateSpecification launchTemplate;
        private InstanceMarketOptionsRequest instanceMarketOptions;
        private CreditSpecificationRequest creditSpecification;
        private CpuOptionsRequest cpuOptions;
        private CapacityReservationSpecification capacityReservationSpecification;
        private HibernationOptionsRequest hibernationOptions;
        private List<LicenseConfigurationRequest> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();
        private InstanceMetadataOptionsRequest metadataOptions;
        private EnclaveOptionsRequest enclaveOptions;
        private PrivateDnsNameOptionsRequest privateDnsNameOptions;
        private InstanceMaintenanceOptionsRequest maintenanceOptions;
        private Boolean disableApiStop;
        private Boolean enablePrimaryIpv6;
        private OperatorRequest operator;
        private Boolean dryRun;
        private Boolean disableApiTermination;
        private String instanceInitiatedShutdownBehavior;
        private String privateIpAddress;
        private String clientToken;
        private String additionalInfo;
        private List<InstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private IamInstanceProfileSpecification iamInstanceProfile;
        private Boolean ebsOptimized;

        private BuilderImpl() {
        }

        private BuilderImpl(RunInstancesRequest model) {
            super(model);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.ipv6AddressCount(model.ipv6AddressCount);
            this.ipv6Addresses(model.ipv6Addresses);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.maxCount(model.maxCount);
            this.minCount(model.minCount);
            this.monitoring(model.monitoring);
            this.placement(model.placement);
            this.ramdiskId(model.ramdiskId);
            this.securityGroupIds(model.securityGroupIds);
            this.securityGroups(model.securityGroups);
            this.subnetId(model.subnetId);
            this.userData(model.userData);
            this.elasticGpuSpecification(model.elasticGpuSpecification);
            this.elasticInferenceAccelerators(model.elasticInferenceAccelerators);
            this.tagSpecifications(model.tagSpecifications);
            this.launchTemplate(model.launchTemplate);
            this.instanceMarketOptions(model.instanceMarketOptions);
            this.creditSpecification(model.creditSpecification);
            this.cpuOptions(model.cpuOptions);
            this.capacityReservationSpecification(model.capacityReservationSpecification);
            this.hibernationOptions(model.hibernationOptions);
            this.licenseSpecifications(model.licenseSpecifications);
            this.metadataOptions(model.metadataOptions);
            this.enclaveOptions(model.enclaveOptions);
            this.privateDnsNameOptions(model.privateDnsNameOptions);
            this.maintenanceOptions(model.maintenanceOptions);
            this.disableApiStop(model.disableApiStop);
            this.enablePrimaryIpv6(model.enablePrimaryIpv6);
            this.operator(model.operator);
            this.dryRun(model.dryRun);
            this.disableApiTermination(model.disableApiTermination);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.privateIpAddress(model.privateIpAddress);
            this.clientToken(model.clientToken);
            this.additionalInfo(model.additionalInfo);
            this.networkInterfaces(model.networkInterfaces);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.ebsOptimized(model.ebsOptimized);
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingRequestListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = InstanceIpv6AddressListCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (InstanceIpv6Address)((InstanceIpv6Address.Builder)InstanceIpv6Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Integer getMaxCount() {
            return this.maxCount;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final Integer getMinCount() {
            return this.minCount;
        }

        public final void setMinCount(Integer minCount) {
            this.minCount = minCount;
        }

        @Override
        public final Builder minCount(Integer minCount) {
            this.minCount = minCount;
            return this;
        }

        public final RunInstancesMonitoringEnabled.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        public final void setMonitoring(RunInstancesMonitoringEnabled.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        public final Builder monitoring(RunInstancesMonitoringEnabled monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final Placement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getUserData() {
            return this.userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final List<ElasticGpuSpecification.Builder> getElasticGpuSpecification() {
            List<ElasticGpuSpecification.Builder> result = ElasticGpuSpecificationsCopier.copyToBuilder(this.elasticGpuSpecification);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticGpuSpecification(Collection<ElasticGpuSpecification.BuilderImpl> elasticGpuSpecification) {
            this.elasticGpuSpecification = ElasticGpuSpecificationsCopier.copyFromBuilder(elasticGpuSpecification);
        }

        @Override
        public final Builder elasticGpuSpecification(Collection<ElasticGpuSpecification> elasticGpuSpecification) {
            this.elasticGpuSpecification = ElasticGpuSpecificationsCopier.copy(elasticGpuSpecification);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecification(ElasticGpuSpecification ... elasticGpuSpecification) {
            this.elasticGpuSpecification(Arrays.asList(elasticGpuSpecification));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecification(Consumer<ElasticGpuSpecification.Builder> ... elasticGpuSpecification) {
            this.elasticGpuSpecification(Stream.of(elasticGpuSpecification).map(c -> (ElasticGpuSpecification)((ElasticGpuSpecification.Builder)ElasticGpuSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ElasticInferenceAccelerator.Builder> getElasticInferenceAccelerators() {
            List<ElasticInferenceAccelerator.Builder> result = ElasticInferenceAcceleratorsCopier.copyToBuilder(this.elasticInferenceAccelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticInferenceAccelerators(Collection<ElasticInferenceAccelerator.BuilderImpl> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = ElasticInferenceAcceleratorsCopier.copyFromBuilder(elasticInferenceAccelerators);
        }

        @Override
        public final Builder elasticInferenceAccelerators(Collection<ElasticInferenceAccelerator> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = ElasticInferenceAcceleratorsCopier.copy(elasticInferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(ElasticInferenceAccelerator ... elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators(Arrays.asList(elasticInferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(Consumer<ElasticInferenceAccelerator.Builder> ... elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators(Stream.of(elasticInferenceAccelerators).map(c -> (ElasticInferenceAccelerator)((ElasticInferenceAccelerator.Builder)ElasticInferenceAccelerator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final InstanceMarketOptionsRequest.Builder getInstanceMarketOptions() {
            return this.instanceMarketOptions != null ? this.instanceMarketOptions.toBuilder() : null;
        }

        public final void setInstanceMarketOptions(InstanceMarketOptionsRequest.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        @Override
        public final Builder instanceMarketOptions(InstanceMarketOptionsRequest instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final CreditSpecificationRequest.Builder getCreditSpecification() {
            return this.creditSpecification != null ? this.creditSpecification.toBuilder() : null;
        }

        public final void setCreditSpecification(CreditSpecificationRequest.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        @Override
        public final Builder creditSpecification(CreditSpecificationRequest creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final CpuOptionsRequest.Builder getCpuOptions() {
            return this.cpuOptions != null ? this.cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(CpuOptionsRequest.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        public final Builder cpuOptions(CpuOptionsRequest cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final CapacityReservationSpecification.Builder getCapacityReservationSpecification() {
            return this.capacityReservationSpecification != null ? this.capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(CapacityReservationSpecification.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification.build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final HibernationOptionsRequest.Builder getHibernationOptions() {
            return this.hibernationOptions != null ? this.hibernationOptions.toBuilder() : null;
        }

        public final void setHibernationOptions(HibernationOptionsRequest.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        @Override
        public final Builder hibernationOptions(HibernationOptionsRequest hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final List<LicenseConfigurationRequest.Builder> getLicenseSpecifications() {
            List<LicenseConfigurationRequest.Builder> result = LicenseSpecificationListRequestCopier.copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSpecifications(Collection<LicenseConfigurationRequest.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationListRequestCopier.copyFromBuilder(licenseSpecifications);
        }

        @Override
        public final Builder licenseSpecifications(Collection<LicenseConfigurationRequest> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationListRequestCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LicenseConfigurationRequest ... licenseSpecifications) {
            this.licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LicenseConfigurationRequest.Builder> ... licenseSpecifications) {
            this.licenseSpecifications(Stream.of(licenseSpecifications).map(c -> (LicenseConfigurationRequest)((LicenseConfigurationRequest.Builder)LicenseConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceMetadataOptionsRequest.Builder getMetadataOptions() {
            return this.metadataOptions != null ? this.metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(InstanceMetadataOptionsRequest.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptionsRequest metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final EnclaveOptionsRequest.Builder getEnclaveOptions() {
            return this.enclaveOptions != null ? this.enclaveOptions.toBuilder() : null;
        }

        public final void setEnclaveOptions(EnclaveOptionsRequest.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        public final Builder enclaveOptions(EnclaveOptionsRequest enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final PrivateDnsNameOptionsRequest.Builder getPrivateDnsNameOptions() {
            return this.privateDnsNameOptions != null ? this.privateDnsNameOptions.toBuilder() : null;
        }

        public final void setPrivateDnsNameOptions(PrivateDnsNameOptionsRequest.BuilderImpl privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions != null ? privateDnsNameOptions.build() : null;
        }

        @Override
        public final Builder privateDnsNameOptions(PrivateDnsNameOptionsRequest privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        public final InstanceMaintenanceOptionsRequest.Builder getMaintenanceOptions() {
            return this.maintenanceOptions != null ? this.maintenanceOptions.toBuilder() : null;
        }

        public final void setMaintenanceOptions(InstanceMaintenanceOptionsRequest.BuilderImpl maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions != null ? maintenanceOptions.build() : null;
        }

        @Override
        public final Builder maintenanceOptions(InstanceMaintenanceOptionsRequest maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions;
            return this;
        }

        public final Boolean getDisableApiStop() {
            return this.disableApiStop;
        }

        public final void setDisableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
        }

        @Override
        public final Builder disableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
            return this;
        }

        public final Boolean getEnablePrimaryIpv6() {
            return this.enablePrimaryIpv6;
        }

        public final void setEnablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
        }

        @Override
        public final Builder enablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
            return this;
        }

        public final OperatorRequest.Builder getOperator() {
            return this.operator != null ? this.operator.toBuilder() : null;
        }

        public final void setOperator(OperatorRequest.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorRequest operator) {
            this.operator = operator;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior == null ? null : instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final List<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            List<InstanceNetworkInterfaceSpecification.Builder> result = InstanceNetworkInterfaceSpecificationListCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (InstanceNetworkInterfaceSpecification)((InstanceNetworkInterfaceSpecification.Builder)InstanceNetworkInterfaceSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunInstancesRequest build() {
            return new RunInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RunInstancesRequest> {
        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder maxCount(Integer var1);

        public Builder minCount(Integer var1);

        public Builder monitoring(RunInstancesMonitoringEnabled var1);

        default public Builder monitoring(Consumer<RunInstancesMonitoringEnabled.Builder> monitoring) {
            return this.monitoring((RunInstancesMonitoringEnabled)((RunInstancesMonitoringEnabled.Builder)RunInstancesMonitoringEnabled.builder().applyMutation(monitoring)).build());
        }

        public Builder placement(Placement var1);

        default public Builder placement(Consumer<Placement.Builder> placement) {
            return this.placement((Placement)((Placement.Builder)Placement.builder().applyMutation(placement)).build());
        }

        public Builder ramdiskId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder subnetId(String var1);

        public Builder userData(String var1);

        public Builder elasticGpuSpecification(Collection<ElasticGpuSpecification> var1);

        public Builder elasticGpuSpecification(ElasticGpuSpecification ... var1);

        public Builder elasticGpuSpecification(Consumer<ElasticGpuSpecification.Builder> ... var1);

        public Builder elasticInferenceAccelerators(Collection<ElasticInferenceAccelerator> var1);

        public Builder elasticInferenceAccelerators(ElasticInferenceAccelerator ... var1);

        public Builder elasticInferenceAccelerators(Consumer<ElasticInferenceAccelerator.Builder> ... var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder instanceMarketOptions(InstanceMarketOptionsRequest var1);

        default public Builder instanceMarketOptions(Consumer<InstanceMarketOptionsRequest.Builder> instanceMarketOptions) {
            return this.instanceMarketOptions((InstanceMarketOptionsRequest)((InstanceMarketOptionsRequest.Builder)InstanceMarketOptionsRequest.builder().applyMutation(instanceMarketOptions)).build());
        }

        public Builder creditSpecification(CreditSpecificationRequest var1);

        default public Builder creditSpecification(Consumer<CreditSpecificationRequest.Builder> creditSpecification) {
            return this.creditSpecification((CreditSpecificationRequest)((CreditSpecificationRequest.Builder)CreditSpecificationRequest.builder().applyMutation(creditSpecification)).build());
        }

        public Builder cpuOptions(CpuOptionsRequest var1);

        default public Builder cpuOptions(Consumer<CpuOptionsRequest.Builder> cpuOptions) {
            return this.cpuOptions((CpuOptionsRequest)((CpuOptionsRequest.Builder)CpuOptionsRequest.builder().applyMutation(cpuOptions)).build());
        }

        public Builder capacityReservationSpecification(CapacityReservationSpecification var1);

        default public Builder capacityReservationSpecification(Consumer<CapacityReservationSpecification.Builder> capacityReservationSpecification) {
            return this.capacityReservationSpecification((CapacityReservationSpecification)((CapacityReservationSpecification.Builder)CapacityReservationSpecification.builder().applyMutation(capacityReservationSpecification)).build());
        }

        public Builder hibernationOptions(HibernationOptionsRequest var1);

        default public Builder hibernationOptions(Consumer<HibernationOptionsRequest.Builder> hibernationOptions) {
            return this.hibernationOptions((HibernationOptionsRequest)((HibernationOptionsRequest.Builder)HibernationOptionsRequest.builder().applyMutation(hibernationOptions)).build());
        }

        public Builder licenseSpecifications(Collection<LicenseConfigurationRequest> var1);

        public Builder licenseSpecifications(LicenseConfigurationRequest ... var1);

        public Builder licenseSpecifications(Consumer<LicenseConfigurationRequest.Builder> ... var1);

        public Builder metadataOptions(InstanceMetadataOptionsRequest var1);

        default public Builder metadataOptions(Consumer<InstanceMetadataOptionsRequest.Builder> metadataOptions) {
            return this.metadataOptions((InstanceMetadataOptionsRequest)((InstanceMetadataOptionsRequest.Builder)InstanceMetadataOptionsRequest.builder().applyMutation(metadataOptions)).build());
        }

        public Builder enclaveOptions(EnclaveOptionsRequest var1);

        default public Builder enclaveOptions(Consumer<EnclaveOptionsRequest.Builder> enclaveOptions) {
            return this.enclaveOptions((EnclaveOptionsRequest)((EnclaveOptionsRequest.Builder)EnclaveOptionsRequest.builder().applyMutation(enclaveOptions)).build());
        }

        public Builder privateDnsNameOptions(PrivateDnsNameOptionsRequest var1);

        default public Builder privateDnsNameOptions(Consumer<PrivateDnsNameOptionsRequest.Builder> privateDnsNameOptions) {
            return this.privateDnsNameOptions((PrivateDnsNameOptionsRequest)((PrivateDnsNameOptionsRequest.Builder)PrivateDnsNameOptionsRequest.builder().applyMutation(privateDnsNameOptions)).build());
        }

        public Builder maintenanceOptions(InstanceMaintenanceOptionsRequest var1);

        default public Builder maintenanceOptions(Consumer<InstanceMaintenanceOptionsRequest.Builder> maintenanceOptions) {
            return this.maintenanceOptions((InstanceMaintenanceOptionsRequest)((InstanceMaintenanceOptionsRequest.Builder)InstanceMaintenanceOptionsRequest.builder().applyMutation(maintenanceOptions)).build());
        }

        public Builder disableApiStop(Boolean var1);

        public Builder enablePrimaryIpv6(Boolean var1);

        public Builder operator(OperatorRequest var1);

        default public Builder operator(Consumer<OperatorRequest.Builder> operator) {
            return this.operator((OperatorRequest)((OperatorRequest.Builder)OperatorRequest.builder().applyMutation(operator)).build());
        }

        public Builder dryRun(Boolean var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceInitiatedShutdownBehavior(ShutdownBehavior var1);

        public Builder privateIpAddress(String var1);

        public Builder clientToken(String var1);

        public Builder additionalInfo(String var1);

        public Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... var1);

        public Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... var1);

        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfileSpecification)((IamInstanceProfileSpecification.Builder)IamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder ebsOptimized(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

