/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ManagedBy;
import software.amazon.awssdk.services.ec2.model.SnapshotBlockPublicAccessState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSnapshotBlockPublicAccessStateResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetSnapshotBlockPublicAccessStateResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetSnapshotBlockPublicAccessStateResponse.getter(GetSnapshotBlockPublicAccessStateResponse::stateAsString)).setter(GetSnapshotBlockPublicAccessStateResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> MANAGED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedBy").getter(GetSnapshotBlockPublicAccessStateResponse.getter(GetSnapshotBlockPublicAccessStateResponse::managedByAsString)).setter(GetSnapshotBlockPublicAccessStateResponse.setter(Builder::managedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy").unmarshallLocationName("managedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, MANAGED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("State", STATE_FIELD);
            this.put("ManagedBy", MANAGED_BY_FIELD);
        }
    });
    private final String state;
    private final String managedBy;

    private GetSnapshotBlockPublicAccessStateResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.managedBy = builder.managedBy;
    }

    public final SnapshotBlockPublicAccessState state() {
        return SnapshotBlockPublicAccessState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final ManagedBy managedBy() {
        return ManagedBy.fromValue(this.managedBy);
    }

    public final String managedByAsString() {
        return this.managedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnapshotBlockPublicAccessStateResponse)) {
            return false;
        }
        GetSnapshotBlockPublicAccessStateResponse other = (GetSnapshotBlockPublicAccessStateResponse)((Object)obj);
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.managedByAsString(), other.managedByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetSnapshotBlockPublicAccessStateResponse").add("State", (Object)this.stateAsString()).add("ManagedBy", (Object)this.managedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ManagedBy": {
                return Optional.ofNullable(clazz.cast(this.managedByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSnapshotBlockPublicAccessStateResponse, T> g) {
        return obj -> g.apply((GetSnapshotBlockPublicAccessStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String state;
        private String managedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnapshotBlockPublicAccessStateResponse model) {
            super(model);
            this.state(model.state);
            this.managedBy(model.managedBy);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotBlockPublicAccessState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getManagedBy() {
            return this.managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public final Builder managedBy(ManagedBy managedBy) {
            this.managedBy(managedBy == null ? null : managedBy.toString());
            return this;
        }

        @Override
        public GetSnapshotBlockPublicAccessStateResponse build() {
            return new GetSnapshotBlockPublicAccessStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSnapshotBlockPublicAccessStateResponse> {
        public Builder state(String var1);

        public Builder state(SnapshotBlockPublicAccessState var1);

        public Builder managedBy(String var1);

        public Builder managedBy(ManagedBy var1);
    }
}

