/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification;
import software.amazon.awssdk.services.ec2.model.PriceScheduleSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReservedInstancesListingRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstancesId").getter(CreateReservedInstancesListingRequest.getter(CreateReservedInstancesListingRequest::reservedInstancesId)).setter(CreateReservedInstancesListingRequest.setter(Builder::reservedInstancesId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId").unmarshallLocationName("reservedInstancesId").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(CreateReservedInstancesListingRequest.getter(CreateReservedInstancesListingRequest::instanceCount)).setter(CreateReservedInstancesListingRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final SdkField<List<PriceScheduleSpecification>> PRICE_SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PriceSchedules").getter(CreateReservedInstancesListingRequest.getter(CreateReservedInstancesListingRequest::priceSchedules)).setter(CreateReservedInstancesListingRequest.setter(Builder::priceSchedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceSchedules").unmarshallLocationName("priceSchedules").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PriceScheduleSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateReservedInstancesListingRequest.getter(CreateReservedInstancesListingRequest::clientToken)).setter(CreateReservedInstancesListingRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_ID_FIELD, INSTANCE_COUNT_FIELD, PRICE_SCHEDULES_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReservedInstancesId", RESERVED_INSTANCES_ID_FIELD);
            this.put("InstanceCount", INSTANCE_COUNT_FIELD);
            this.put("PriceSchedules", PRICE_SCHEDULES_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String reservedInstancesId;
    private final Integer instanceCount;
    private final List<PriceScheduleSpecification> priceSchedules;
    private final String clientToken;

    private CreateReservedInstancesListingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesId = builder.reservedInstancesId;
        this.instanceCount = builder.instanceCount;
        this.priceSchedules = builder.priceSchedules;
        this.clientToken = builder.clientToken;
    }

    public final String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final boolean hasPriceSchedules() {
        return this.priceSchedules != null && !(this.priceSchedules instanceof SdkAutoConstructList);
    }

    public final List<PriceScheduleSpecification> priceSchedules() {
        return this.priceSchedules;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPriceSchedules() ? this.priceSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservedInstancesListingRequest)) {
            return false;
        }
        CreateReservedInstancesListingRequest other = (CreateReservedInstancesListingRequest)((Object)obj);
        return Objects.equals(this.reservedInstancesId(), other.reservedInstancesId()) && Objects.equals(this.instanceCount(), other.instanceCount()) && this.hasPriceSchedules() == other.hasPriceSchedules() && Objects.equals(this.priceSchedules(), other.priceSchedules()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReservedInstancesListingRequest").add("ReservedInstancesId", (Object)this.reservedInstancesId()).add("InstanceCount", (Object)this.instanceCount()).add("PriceSchedules", this.hasPriceSchedules() ? this.priceSchedules() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstancesId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesId()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "PriceSchedules": {
                return Optional.ofNullable(clazz.cast(this.priceSchedules()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateReservedInstancesListingRequest, T> g) {
        return obj -> g.apply((CreateReservedInstancesListingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String reservedInstancesId;
        private Integer instanceCount;
        private List<PriceScheduleSpecification> priceSchedules = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReservedInstancesListingRequest model) {
            super(model);
            this.reservedInstancesId(model.reservedInstancesId);
            this.instanceCount(model.instanceCount);
            this.priceSchedules(model.priceSchedules);
            this.clientToken(model.clientToken);
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final List<PriceScheduleSpecification.Builder> getPriceSchedules() {
            List<PriceScheduleSpecification.Builder> result = PriceScheduleSpecificationListCopier.copyToBuilder(this.priceSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPriceSchedules(Collection<PriceScheduleSpecification.BuilderImpl> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copyFromBuilder(priceSchedules);
        }

        @Override
        public final Builder priceSchedules(Collection<PriceScheduleSpecification> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceScheduleSpecification ... priceSchedules) {
            this.priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(Consumer<PriceScheduleSpecification.Builder> ... priceSchedules) {
            this.priceSchedules(Stream.of(priceSchedules).map(c -> (PriceScheduleSpecification)((PriceScheduleSpecification.Builder)PriceScheduleSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReservedInstancesListingRequest build() {
            return new CreateReservedInstancesListingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
        public Builder reservedInstancesId(String var1);

        public Builder instanceCount(Integer var1);

        public Builder priceSchedules(Collection<PriceScheduleSpecification> var1);

        public Builder priceSchedules(PriceScheduleSpecification ... var1);

        public Builder priceSchedules(Consumer<PriceScheduleSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

