/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpPermissionListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityGroup> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(SecurityGroup.getter(SecurityGroup::groupId)).setter(SecurityGroup.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_EGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpPermissionsEgress").getter(SecurityGroup.getter(SecurityGroup::ipPermissionsEgress)).setter(SecurityGroup.setter(Builder::ipPermissionsEgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissionsEgress").unmarshallLocationName("ipPermissionsEgress").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SecurityGroup.getter(SecurityGroup::tags)).setter(SecurityGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(SecurityGroup.getter(SecurityGroup::vpcId)).setter(SecurityGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> SECURITY_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityGroupArn").getter(SecurityGroup.getter(SecurityGroup::securityGroupArn)).setter(SecurityGroup.setter(Builder::securityGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArn").unmarshallLocationName("securityGroupArn").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(SecurityGroup.getter(SecurityGroup::ownerId)).setter(SecurityGroup.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(SecurityGroup.getter(SecurityGroup::groupName)).setter(SecurityGroup.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SecurityGroup.getter(SecurityGroup::description)).setter(SecurityGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDescription").unmarshallLocationName("groupDescription").build()}).build();
    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpPermissions").getter(SecurityGroup.getter(SecurityGroup::ipPermissions)).setter(SecurityGroup.setter(Builder::ipPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions").unmarshallLocationName("ipPermissions").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, IP_PERMISSIONS_EGRESS_FIELD, TAGS_FIELD, VPC_ID_FIELD, SECURITY_GROUP_ARN_FIELD, OWNER_ID_FIELD, GROUP_NAME_FIELD, DESCRIPTION_FIELD, IP_PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GroupId", GROUP_ID_FIELD);
            this.put("IpPermissionsEgress", IP_PERMISSIONS_EGRESS_FIELD);
            this.put("TagSet", TAGS_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("SecurityGroupArn", SECURITY_GROUP_ARN_FIELD);
            this.put("OwnerId", OWNER_ID_FIELD);
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("GroupDescription", DESCRIPTION_FIELD);
            this.put("IpPermissions", IP_PERMISSIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final List<IpPermission> ipPermissionsEgress;
    private final List<Tag> tags;
    private final String vpcId;
    private final String securityGroupArn;
    private final String ownerId;
    private final String groupName;
    private final String description;
    private final List<IpPermission> ipPermissions;

    private SecurityGroup(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.ipPermissionsEgress = builder.ipPermissionsEgress;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
        this.securityGroupArn = builder.securityGroupArn;
        this.ownerId = builder.ownerId;
        this.groupName = builder.groupName;
        this.description = builder.description;
        this.ipPermissions = builder.ipPermissions;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final boolean hasIpPermissionsEgress() {
        return this.ipPermissionsEgress != null && !(this.ipPermissionsEgress instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> ipPermissionsEgress() {
        return this.ipPermissionsEgress;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String securityGroupArn() {
        return this.securityGroupArn;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasIpPermissions() {
        return this.ipPermissions != null && !(this.ipPermissions instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> ipPermissions() {
        return this.ipPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpPermissionsEgress() ? this.ipPermissionsEgress() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpPermissions() ? this.ipPermissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroup)) {
            return false;
        }
        SecurityGroup other = (SecurityGroup)obj;
        return Objects.equals(this.groupId(), other.groupId()) && this.hasIpPermissionsEgress() == other.hasIpPermissionsEgress() && Objects.equals(this.ipPermissionsEgress(), other.ipPermissionsEgress()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.securityGroupArn(), other.securityGroupArn()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.description(), other.description()) && this.hasIpPermissions() == other.hasIpPermissions() && Objects.equals(this.ipPermissions(), other.ipPermissions());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityGroup").add("GroupId", (Object)this.groupId()).add("IpPermissionsEgress", this.hasIpPermissionsEgress() ? this.ipPermissionsEgress() : null).add("Tags", this.hasTags() ? this.tags() : null).add("VpcId", (Object)this.vpcId()).add("SecurityGroupArn", (Object)this.securityGroupArn()).add("OwnerId", (Object)this.ownerId()).add("GroupName", (Object)this.groupName()).add("Description", (Object)this.description()).add("IpPermissions", this.hasIpPermissions() ? this.ipPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "IpPermissionsEgress": {
                return Optional.ofNullable(clazz.cast(this.ipPermissionsEgress()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SecurityGroupArn": {
                return Optional.ofNullable(clazz.cast(this.securityGroupArn()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IpPermissions": {
                return Optional.ofNullable(clazz.cast(this.ipPermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroup, T> g) {
        return obj -> g.apply((SecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private List<IpPermission> ipPermissionsEgress = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;
        private String securityGroupArn;
        private String ownerId;
        private String groupName;
        private String description;
        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroup model) {
            this.groupId(model.groupId);
            this.ipPermissionsEgress(model.ipPermissionsEgress);
            this.tags(model.tags);
            this.vpcId(model.vpcId);
            this.securityGroupArn(model.securityGroupArn);
            this.ownerId(model.ownerId);
            this.groupName(model.groupName);
            this.description(model.description);
            this.ipPermissions(model.ipPermissions);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<IpPermission.Builder> getIpPermissionsEgress() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissionsEgress);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPermissionsEgress(Collection<IpPermission.BuilderImpl> ipPermissionsEgress) {
            this.ipPermissionsEgress = IpPermissionListCopier.copyFromBuilder(ipPermissionsEgress);
        }

        @Override
        public final Builder ipPermissionsEgress(Collection<IpPermission> ipPermissionsEgress) {
            this.ipPermissionsEgress = IpPermissionListCopier.copy(ipPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(IpPermission ... ipPermissionsEgress) {
            this.ipPermissionsEgress(Arrays.asList(ipPermissionsEgress));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(Consumer<IpPermission.Builder> ... ipPermissionsEgress) {
            this.ipPermissionsEgress(Stream.of(ipPermissionsEgress).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSecurityGroupArn() {
            return this.securityGroupArn;
        }

        public final void setSecurityGroupArn(String securityGroupArn) {
            this.securityGroupArn = securityGroupArn;
        }

        @Override
        public final Builder securityGroupArn(String securityGroupArn) {
            this.securityGroupArn = securityGroupArn;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<IpPermission.Builder> getIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission ... ipPermissions) {
            this.ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder> ... ipPermissions) {
            this.ipPermissions(Stream.of(ipPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SecurityGroup build() {
            return new SecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityGroup> {
        public Builder groupId(String var1);

        public Builder ipPermissionsEgress(Collection<IpPermission> var1);

        public Builder ipPermissionsEgress(IpPermission ... var1);

        public Builder ipPermissionsEgress(Consumer<IpPermission.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder vpcId(String var1);

        public Builder securityGroupArn(String var1);

        public Builder ownerId(String var1);

        public Builder groupName(String var1);

        public Builder description(String var1);

        public Builder ipPermissions(Collection<IpPermission> var1);

        public Builder ipPermissions(IpPermission ... var1);

        public Builder ipPermissions(Consumer<IpPermission.Builder> ... var1);
    }
}

