/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMappingSetCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesIamInstanceProfile;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesMonitoring;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterface;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterfaceSetCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesPlacement;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesSecurityGroupIdSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledInstancesLaunchSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledInstancesLaunchSpecification> {
    private static final SdkField<List<ScheduledInstancesBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::blockDeviceMappings)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build(), ListTrait.builder().memberLocationName("BlockDeviceMapping").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledInstancesBlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::ebsOptimized)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("EbsOptimized").build()}).build();
    private static final SdkField<ScheduledInstancesIamInstanceProfile> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::iamInstanceProfile)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::iamInstanceProfile)).constructor(ScheduledInstancesIamInstanceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").unmarshallLocationName("IamInstanceProfile").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::imageId)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::instanceType)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::kernelId)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").unmarshallLocationName("KernelId").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::keyName)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("KeyName").build()}).build();
    private static final SdkField<ScheduledInstancesMonitoring> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Monitoring").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::monitoring)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::monitoring)).constructor(ScheduledInstancesMonitoring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").unmarshallLocationName("Monitoring").build()}).build();
    private static final SdkField<List<ScheduledInstancesNetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaces").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::networkInterfaces)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface").unmarshallLocationName("NetworkInterface").build(), ListTrait.builder().memberLocationName("NetworkInterface").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledInstancesNetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface").unmarshallLocationName("NetworkInterface").build()}).build()).build()}).build();
    private static final SdkField<ScheduledInstancesPlacement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::placement)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::placement)).constructor(ScheduledInstancesPlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("Placement").build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamdiskId").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::ramdiskId)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").unmarshallLocationName("RamdiskId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::securityGroupIds)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::subnetId)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserData").getter(ScheduledInstancesLaunchSpecification.getter(ScheduledInstancesLaunchSpecification::userData)).setter(ScheduledInstancesLaunchSpecification.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").unmarshallLocationName("UserData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD, EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, MONITORING_FIELD, NETWORK_INTERFACES_FIELD, PLACEMENT_FIELD, RAMDISK_ID_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, USER_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BlockDeviceMapping", BLOCK_DEVICE_MAPPINGS_FIELD);
            this.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
            this.put("IamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
            this.put("ImageId", IMAGE_ID_FIELD);
            this.put("InstanceType", INSTANCE_TYPE_FIELD);
            this.put("KernelId", KERNEL_ID_FIELD);
            this.put("KeyName", KEY_NAME_FIELD);
            this.put("Monitoring", MONITORING_FIELD);
            this.put("NetworkInterface", NETWORK_INTERFACES_FIELD);
            this.put("Placement", PLACEMENT_FIELD);
            this.put("RamdiskId", RAMDISK_ID_FIELD);
            this.put("SecurityGroupId", SECURITY_GROUP_IDS_FIELD);
            this.put("SubnetId", SUBNET_ID_FIELD);
            this.put("UserData", USER_DATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings;
    private final Boolean ebsOptimized;
    private final ScheduledInstancesIamInstanceProfile iamInstanceProfile;
    private final String imageId;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final ScheduledInstancesMonitoring monitoring;
    private final List<ScheduledInstancesNetworkInterface> networkInterfaces;
    private final ScheduledInstancesPlacement placement;
    private final String ramdiskId;
    private final List<String> securityGroupIds;
    private final String subnetId;
    private final String userData;

    private ScheduledInstancesLaunchSpecification(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final ScheduledInstancesIamInstanceProfile iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final ScheduledInstancesMonitoring monitoring() {
        return this.monitoring;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<ScheduledInstancesNetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final ScheduledInstancesPlacement placement() {
        return this.placement;
    }

    public final String ramdiskId() {
        return this.ramdiskId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String userData() {
        return this.userData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesLaunchSpecification)) {
            return false;
        }
        ScheduledInstancesLaunchSpecification other = (ScheduledInstancesLaunchSpecification)obj;
        return this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.monitoring(), other.monitoring()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.userData(), other.userData());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledInstancesLaunchSpecification").add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceType()).add("KernelId", (Object)this.kernelId()).add("KeyName", (Object)this.keyName()).add("Monitoring", (Object)this.monitoring()).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("Placement", (Object)this.placement()).add("RamdiskId", (Object)this.ramdiskId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SubnetId", (Object)this.subnetId()).add("UserData", (Object)this.userData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstancesLaunchSpecification, T> g) {
        return obj -> g.apply((ScheduledInstancesLaunchSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private Boolean ebsOptimized;
        private ScheduledInstancesIamInstanceProfile iamInstanceProfile;
        private String imageId;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private ScheduledInstancesMonitoring monitoring;
        private List<ScheduledInstancesNetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private ScheduledInstancesPlacement placement;
        private String ramdiskId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesLaunchSpecification model) {
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.monitoring(model.monitoring);
            this.networkInterfaces(model.networkInterfaces);
            this.placement(model.placement);
            this.ramdiskId(model.ramdiskId);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetId(model.subnetId);
            this.userData(model.userData);
        }

        public final List<ScheduledInstancesBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<ScheduledInstancesBlockDeviceMapping.Builder> result = ScheduledInstancesBlockDeviceMappingSetCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = ScheduledInstancesBlockDeviceMappingSetCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = ScheduledInstancesBlockDeviceMappingSetCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(ScheduledInstancesBlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<ScheduledInstancesBlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (ScheduledInstancesBlockDeviceMapping)((ScheduledInstancesBlockDeviceMapping.Builder)ScheduledInstancesBlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final ScheduledInstancesIamInstanceProfile.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(ScheduledInstancesIamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(ScheduledInstancesIamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final ScheduledInstancesMonitoring.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        public final void setMonitoring(ScheduledInstancesMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        public final Builder monitoring(ScheduledInstancesMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final List<ScheduledInstancesNetworkInterface.Builder> getNetworkInterfaces() {
            List<ScheduledInstancesNetworkInterface.Builder> result = ScheduledInstancesNetworkInterfaceSetCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<ScheduledInstancesNetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = ScheduledInstancesNetworkInterfaceSetCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<ScheduledInstancesNetworkInterface> networkInterfaces) {
            this.networkInterfaces = ScheduledInstancesNetworkInterfaceSetCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(ScheduledInstancesNetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<ScheduledInstancesNetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (ScheduledInstancesNetworkInterface)((ScheduledInstancesNetworkInterface.Builder)ScheduledInstancesNetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ScheduledInstancesPlacement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(ScheduledInstancesPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(ScheduledInstancesPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ScheduledInstancesSecurityGroupIdSetCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ScheduledInstancesSecurityGroupIdSetCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getUserData() {
            return this.userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public ScheduledInstancesLaunchSpecification build() {
            return new ScheduledInstancesLaunchSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledInstancesLaunchSpecification> {
        public Builder blockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(ScheduledInstancesBlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<ScheduledInstancesBlockDeviceMapping.Builder> ... var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(ScheduledInstancesIamInstanceProfile var1);

        default public Builder iamInstanceProfile(Consumer<ScheduledInstancesIamInstanceProfile.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((ScheduledInstancesIamInstanceProfile)((ScheduledInstancesIamInstanceProfile.Builder)ScheduledInstancesIamInstanceProfile.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder monitoring(ScheduledInstancesMonitoring var1);

        default public Builder monitoring(Consumer<ScheduledInstancesMonitoring.Builder> monitoring) {
            return this.monitoring((ScheduledInstancesMonitoring)((ScheduledInstancesMonitoring.Builder)ScheduledInstancesMonitoring.builder().applyMutation(monitoring)).build());
        }

        public Builder networkInterfaces(Collection<ScheduledInstancesNetworkInterface> var1);

        public Builder networkInterfaces(ScheduledInstancesNetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<ScheduledInstancesNetworkInterface.Builder> ... var1);

        public Builder placement(ScheduledInstancesPlacement var1);

        default public Builder placement(Consumer<ScheduledInstancesPlacement.Builder> placement) {
            return this.placement((ScheduledInstancesPlacement)((ScheduledInstancesPlacement.Builder)ScheduledInstancesPlacement.builder().applyMutation(placement)).build());
        }

        public Builder ramdiskId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetId(String var1);

        public Builder userData(String var1);
    }
}

