/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportSnapshotTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportSnapshotTask> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ImportSnapshotTask.getter(ImportSnapshotTask::description)).setter(ImportSnapshotTask.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportTaskId").getter(ImportSnapshotTask.getter(ImportSnapshotTask::importTaskId)).setter(ImportSnapshotTask.setter(Builder::importTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTaskId").unmarshallLocationName("importTaskId").build()}).build();
    private static final SdkField<SnapshotTaskDetail> SNAPSHOT_TASK_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotTaskDetail").getter(ImportSnapshotTask.getter(ImportSnapshotTask::snapshotTaskDetail)).setter(ImportSnapshotTask.setter(Builder::snapshotTaskDetail)).constructor(SnapshotTaskDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTaskDetail").unmarshallLocationName("snapshotTaskDetail").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ImportSnapshotTask.getter(ImportSnapshotTask::tags)).setter(ImportSnapshotTask.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, IMPORT_TASK_ID_FIELD, SNAPSHOT_TASK_DETAIL_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ImportTaskId", IMPORT_TASK_ID_FIELD);
            this.put("SnapshotTaskDetail", SNAPSHOT_TASK_DETAIL_FIELD);
            this.put("TagSet", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String importTaskId;
    private final SnapshotTaskDetail snapshotTaskDetail;
    private final List<Tag> tags;

    private ImportSnapshotTask(BuilderImpl builder) {
        this.description = builder.description;
        this.importTaskId = builder.importTaskId;
        this.snapshotTaskDetail = builder.snapshotTaskDetail;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String importTaskId() {
        return this.importTaskId;
    }

    public final SnapshotTaskDetail snapshotTaskDetail() {
        return this.snapshotTaskDetail;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotTaskDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotTask)) {
            return false;
        }
        ImportSnapshotTask other = (ImportSnapshotTask)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.importTaskId(), other.importTaskId()) && Objects.equals(this.snapshotTaskDetail(), other.snapshotTaskDetail()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ImportSnapshotTask").add("Description", (Object)this.description()).add("ImportTaskId", (Object)this.importTaskId()).add("SnapshotTaskDetail", (Object)this.snapshotTaskDetail()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ImportTaskId": {
                return Optional.ofNullable(clazz.cast(this.importTaskId()));
            }
            case "SnapshotTaskDetail": {
                return Optional.ofNullable(clazz.cast(this.snapshotTaskDetail()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportSnapshotTask, T> g) {
        return obj -> g.apply((ImportSnapshotTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String importTaskId;
        private SnapshotTaskDetail snapshotTaskDetail;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotTask model) {
            this.description(model.description);
            this.importTaskId(model.importTaskId);
            this.snapshotTaskDetail(model.snapshotTaskDetail);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getImportTaskId() {
            return this.importTaskId;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final SnapshotTaskDetail.Builder getSnapshotTaskDetail() {
            return this.snapshotTaskDetail != null ? this.snapshotTaskDetail.toBuilder() : null;
        }

        public final void setSnapshotTaskDetail(SnapshotTaskDetail.BuilderImpl snapshotTaskDetail) {
            this.snapshotTaskDetail = snapshotTaskDetail != null ? snapshotTaskDetail.build() : null;
        }

        @Override
        public final Builder snapshotTaskDetail(SnapshotTaskDetail snapshotTaskDetail) {
            this.snapshotTaskDetail = snapshotTaskDetail;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ImportSnapshotTask build() {
            return new ImportSnapshotTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportSnapshotTask> {
        public Builder description(String var1);

        public Builder importTaskId(String var1);

        public Builder snapshotTaskDetail(SnapshotTaskDetail var1);

        default public Builder snapshotTaskDetail(Consumer<SnapshotTaskDetail.Builder> snapshotTaskDetail) {
            return this.snapshotTaskDetail((SnapshotTaskDetail)((SnapshotTaskDetail.Builder)SnapshotTaskDetail.builder().applyMutation(snapshotTaskDetail)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

