/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransitGatewayRouteTablePropagationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetTransitGatewayRouteTablePropagationsResponse> {
    private static final SdkField<List<TransitGatewayRouteTablePropagation>> TRANSIT_GATEWAY_ROUTE_TABLE_PROPAGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayRouteTablePropagations").getter(GetTransitGatewayRouteTablePropagationsResponse.getter(GetTransitGatewayRouteTablePropagationsResponse::transitGatewayRouteTablePropagations)).setter(GetTransitGatewayRouteTablePropagationsResponse.setter(Builder::transitGatewayRouteTablePropagations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTablePropagations").unmarshallLocationName("transitGatewayRouteTablePropagations").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayRouteTablePropagation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTransitGatewayRouteTablePropagationsResponse.getter(GetTransitGatewayRouteTablePropagationsResponse::nextToken)).setter(GetTransitGatewayRouteTablePropagationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ROUTE_TABLE_PROPAGATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TransitGatewayRouteTablePropagations", TRANSIT_GATEWAY_ROUTE_TABLE_PROPAGATIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<TransitGatewayRouteTablePropagation> transitGatewayRouteTablePropagations;
    private final String nextToken;

    private GetTransitGatewayRouteTablePropagationsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRouteTablePropagations = builder.transitGatewayRouteTablePropagations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransitGatewayRouteTablePropagations() {
        return this.transitGatewayRouteTablePropagations != null && !(this.transitGatewayRouteTablePropagations instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayRouteTablePropagation> transitGatewayRouteTablePropagations() {
        return this.transitGatewayRouteTablePropagations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayRouteTablePropagations() ? this.transitGatewayRouteTablePropagations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayRouteTablePropagationsResponse)) {
            return false;
        }
        GetTransitGatewayRouteTablePropagationsResponse other = (GetTransitGatewayRouteTablePropagationsResponse)((Object)obj);
        return this.hasTransitGatewayRouteTablePropagations() == other.hasTransitGatewayRouteTablePropagations() && Objects.equals(this.transitGatewayRouteTablePropagations(), other.transitGatewayRouteTablePropagations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTransitGatewayRouteTablePropagationsResponse").add("TransitGatewayRouteTablePropagations", this.hasTransitGatewayRouteTablePropagations() ? this.transitGatewayRouteTablePropagations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayRouteTablePropagations": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTablePropagations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayRouteTablePropagationsResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayRouteTablePropagationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayRouteTablePropagation> transitGatewayRouteTablePropagations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayRouteTablePropagationsResponse model) {
            super(model);
            this.transitGatewayRouteTablePropagations(model.transitGatewayRouteTablePropagations);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayRouteTablePropagation.Builder> getTransitGatewayRouteTablePropagations() {
            List<TransitGatewayRouteTablePropagation.Builder> result = TransitGatewayRouteTablePropagationListCopier.copyToBuilder(this.transitGatewayRouteTablePropagations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayRouteTablePropagations(Collection<TransitGatewayRouteTablePropagation.BuilderImpl> transitGatewayRouteTablePropagations) {
            this.transitGatewayRouteTablePropagations = TransitGatewayRouteTablePropagationListCopier.copyFromBuilder(transitGatewayRouteTablePropagations);
        }

        @Override
        public final Builder transitGatewayRouteTablePropagations(Collection<TransitGatewayRouteTablePropagation> transitGatewayRouteTablePropagations) {
            this.transitGatewayRouteTablePropagations = TransitGatewayRouteTablePropagationListCopier.copy(transitGatewayRouteTablePropagations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayRouteTablePropagations(TransitGatewayRouteTablePropagation ... transitGatewayRouteTablePropagations) {
            this.transitGatewayRouteTablePropagations(Arrays.asList(transitGatewayRouteTablePropagations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayRouteTablePropagations(Consumer<TransitGatewayRouteTablePropagation.Builder> ... transitGatewayRouteTablePropagations) {
            this.transitGatewayRouteTablePropagations(Stream.of(transitGatewayRouteTablePropagations).map(c -> (TransitGatewayRouteTablePropagation)((TransitGatewayRouteTablePropagation.Builder)TransitGatewayRouteTablePropagation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTransitGatewayRouteTablePropagationsResponse build() {
            return new GetTransitGatewayRouteTablePropagationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransitGatewayRouteTablePropagationsResponse> {
        public Builder transitGatewayRouteTablePropagations(Collection<TransitGatewayRouteTablePropagation> var1);

        public Builder transitGatewayRouteTablePropagations(TransitGatewayRouteTablePropagation ... var1);

        public Builder transitGatewayRouteTablePropagations(Consumer<TransitGatewayRouteTablePropagation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

