/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc;
import software.amazon.awssdk.services.ec2.model.SecurityGroupForVpcListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSecurityGroupsForVpcResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetSecurityGroupsForVpcResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetSecurityGroupsForVpcResponse.getter(GetSecurityGroupsForVpcResponse::nextToken)).setter(GetSecurityGroupsForVpcResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<SecurityGroupForVpc>> SECURITY_GROUP_FOR_VPCS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupForVpcs").getter(GetSecurityGroupsForVpcResponse.getter(GetSecurityGroupsForVpcResponse::securityGroupForVpcs)).setter(GetSecurityGroupsForVpcResponse.setter(Builder::securityGroupForVpcs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupForVpcSet").unmarshallLocationName("securityGroupForVpcSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupForVpc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SECURITY_GROUP_FOR_VPCS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("SecurityGroupForVpcSet", SECURITY_GROUP_FOR_VPCS_FIELD);
        }
    });
    private final String nextToken;
    private final List<SecurityGroupForVpc> securityGroupForVpcs;

    private GetSecurityGroupsForVpcResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.securityGroupForVpcs = builder.securityGroupForVpcs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSecurityGroupForVpcs() {
        return this.securityGroupForVpcs != null && !(this.securityGroupForVpcs instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupForVpc> securityGroupForVpcs() {
        return this.securityGroupForVpcs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupForVpcs() ? this.securityGroupForVpcs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSecurityGroupsForVpcResponse)) {
            return false;
        }
        GetSecurityGroupsForVpcResponse other = (GetSecurityGroupsForVpcResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSecurityGroupForVpcs() == other.hasSecurityGroupForVpcs() && Objects.equals(this.securityGroupForVpcs(), other.securityGroupForVpcs());
    }

    public final String toString() {
        return ToString.builder((String)"GetSecurityGroupsForVpcResponse").add("NextToken", (Object)this.nextToken()).add("SecurityGroupForVpcs", this.hasSecurityGroupForVpcs() ? this.securityGroupForVpcs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SecurityGroupForVpcs": {
                return Optional.ofNullable(clazz.cast(this.securityGroupForVpcs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSecurityGroupsForVpcResponse, T> g) {
        return obj -> g.apply((GetSecurityGroupsForVpcResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SecurityGroupForVpc> securityGroupForVpcs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSecurityGroupsForVpcResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.securityGroupForVpcs(model.securityGroupForVpcs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SecurityGroupForVpc.Builder> getSecurityGroupForVpcs() {
            List<SecurityGroupForVpc.Builder> result = SecurityGroupForVpcListCopier.copyToBuilder(this.securityGroupForVpcs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupForVpcs(Collection<SecurityGroupForVpc.BuilderImpl> securityGroupForVpcs) {
            this.securityGroupForVpcs = SecurityGroupForVpcListCopier.copyFromBuilder(securityGroupForVpcs);
        }

        @Override
        public final Builder securityGroupForVpcs(Collection<SecurityGroupForVpc> securityGroupForVpcs) {
            this.securityGroupForVpcs = SecurityGroupForVpcListCopier.copy(securityGroupForVpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupForVpcs(SecurityGroupForVpc ... securityGroupForVpcs) {
            this.securityGroupForVpcs(Arrays.asList(securityGroupForVpcs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupForVpcs(Consumer<SecurityGroupForVpc.Builder> ... securityGroupForVpcs) {
            this.securityGroupForVpcs(Stream.of(securityGroupForVpcs).map(c -> (SecurityGroupForVpc)((SecurityGroupForVpc.Builder)SecurityGroupForVpc.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSecurityGroupsForVpcResponse build() {
            return new GetSecurityGroupsForVpcResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSecurityGroupsForVpcResponse> {
        public Builder nextToken(String var1);

        public Builder securityGroupForVpcs(Collection<SecurityGroupForVpc> var1);

        public Builder securityGroupForVpcs(SecurityGroupForVpc ... var1);

        public Builder securityGroupForVpcs(Consumer<SecurityGroupForVpc.Builder> ... var1);
    }
}

