/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DeprovisionedAddressSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeprovisionPublicIpv4PoolCidrResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DeprovisionPublicIpv4PoolCidrResponse> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(DeprovisionPublicIpv4PoolCidrResponse.getter(DeprovisionPublicIpv4PoolCidrResponse::poolId)).setter(DeprovisionPublicIpv4PoolCidrResponse.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").unmarshallLocationName("poolId").build()}).build();
    private static final SdkField<List<String>> DEPROVISIONED_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeprovisionedAddresses").getter(DeprovisionPublicIpv4PoolCidrResponse.getter(DeprovisionPublicIpv4PoolCidrResponse::deprovisionedAddresses)).setter(DeprovisionPublicIpv4PoolCidrResponse.setter(Builder::deprovisionedAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprovisionedAddressSet").unmarshallLocationName("deprovisionedAddressSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD, DEPROVISIONED_ADDRESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PoolId", POOL_ID_FIELD);
            this.put("DeprovisionedAddressSet", DEPROVISIONED_ADDRESSES_FIELD);
        }
    });
    private final String poolId;
    private final List<String> deprovisionedAddresses;

    private DeprovisionPublicIpv4PoolCidrResponse(BuilderImpl builder) {
        super(builder);
        this.poolId = builder.poolId;
        this.deprovisionedAddresses = builder.deprovisionedAddresses;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final boolean hasDeprovisionedAddresses() {
        return this.deprovisionedAddresses != null && !(this.deprovisionedAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> deprovisionedAddresses() {
        return this.deprovisionedAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeprovisionedAddresses() ? this.deprovisionedAddresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprovisionPublicIpv4PoolCidrResponse)) {
            return false;
        }
        DeprovisionPublicIpv4PoolCidrResponse other = (DeprovisionPublicIpv4PoolCidrResponse)((Object)obj);
        return Objects.equals(this.poolId(), other.poolId()) && this.hasDeprovisionedAddresses() == other.hasDeprovisionedAddresses() && Objects.equals(this.deprovisionedAddresses(), other.deprovisionedAddresses());
    }

    public final String toString() {
        return ToString.builder((String)"DeprovisionPublicIpv4PoolCidrResponse").add("PoolId", (Object)this.poolId()).add("DeprovisionedAddresses", this.hasDeprovisionedAddresses() ? this.deprovisionedAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "DeprovisionedAddresses": {
                return Optional.ofNullable(clazz.cast(this.deprovisionedAddresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeprovisionPublicIpv4PoolCidrResponse, T> g) {
        return obj -> g.apply((DeprovisionPublicIpv4PoolCidrResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String poolId;
        private List<String> deprovisionedAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeprovisionPublicIpv4PoolCidrResponse model) {
            super(model);
            this.poolId(model.poolId);
            this.deprovisionedAddresses(model.deprovisionedAddresses);
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Collection<String> getDeprovisionedAddresses() {
            if (this.deprovisionedAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deprovisionedAddresses;
        }

        public final void setDeprovisionedAddresses(Collection<String> deprovisionedAddresses) {
            this.deprovisionedAddresses = DeprovisionedAddressSetCopier.copy(deprovisionedAddresses);
        }

        @Override
        public final Builder deprovisionedAddresses(Collection<String> deprovisionedAddresses) {
            this.deprovisionedAddresses = DeprovisionedAddressSetCopier.copy(deprovisionedAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deprovisionedAddresses(String ... deprovisionedAddresses) {
            this.deprovisionedAddresses(Arrays.asList(deprovisionedAddresses));
            return this;
        }

        @Override
        public DeprovisionPublicIpv4PoolCidrResponse build() {
            return new DeprovisionPublicIpv4PoolCidrResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeprovisionPublicIpv4PoolCidrResponse> {
        public Builder poolId(String var1);

        public Builder deprovisionedAddresses(Collection<String> var1);

        public Builder deprovisionedAddresses(String ... var1);
    }
}

