/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DnsOptionsSpecification;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpAddressType;
import software.amazon.awssdk.services.ec2.model.SubnetConfiguration;
import software.amazon.awssdk.services.ec2.model.SubnetConfigurationsListCopier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointRouteTableIdListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointSecurityGroupIdListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointSubnetIdListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcEndpointRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVpcEndpointRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::dryRun)).setter(CreateVpcEndpointRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointType").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::vpcEndpointTypeAsString)).setter(CreateVpcEndpointRequest.setter(Builder::vpcEndpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointType").unmarshallLocationName("VpcEndpointType").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::vpcId)).setter(CreateVpcEndpointRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("VpcId").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::serviceName)).setter(CreateVpcEndpointRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").unmarshallLocationName("ServiceName").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::policyDocument)).setter(CreateVpcEndpointRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").unmarshallLocationName("PolicyDocument").build()}).build();
    private static final SdkField<List<String>> ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteTableIds").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::routeTableIds)).setter(CreateVpcEndpointRequest.setter(Builder::routeTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").unmarshallLocationName("RouteTableId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::subnetIds)).setter(CreateVpcEndpointRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::securityGroupIds)).setter(CreateVpcEndpointRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::ipAddressTypeAsString)).setter(CreateVpcEndpointRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").unmarshallLocationName("IpAddressType").build()}).build();
    private static final SdkField<DnsOptionsSpecification> DNS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsOptions").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::dnsOptions)).setter(CreateVpcEndpointRequest.setter(Builder::dnsOptions)).constructor(DnsOptionsSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsOptions").unmarshallLocationName("DnsOptions").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::clientToken)).setter(CreateVpcEndpointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PrivateDnsEnabled").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::privateDnsEnabled)).setter(CreateVpcEndpointRequest.setter(Builder::privateDnsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsEnabled").unmarshallLocationName("PrivateDnsEnabled").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::tagSpecifications)).setter(CreateVpcEndpointRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<SubnetConfiguration>> SUBNET_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetConfigurations").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::subnetConfigurations)).setter(CreateVpcEndpointRequest.setter(Builder::subnetConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetConfiguration").unmarshallLocationName("SubnetConfiguration").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRegion").getter(CreateVpcEndpointRequest.getter(CreateVpcEndpointRequest::serviceRegion)).setter(CreateVpcEndpointRequest.setter(Builder::serviceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRegion").unmarshallLocationName("ServiceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, VPC_ENDPOINT_TYPE_FIELD, VPC_ID_FIELD, SERVICE_NAME_FIELD, POLICY_DOCUMENT_FIELD, ROUTE_TABLE_IDS_FIELD, SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, IP_ADDRESS_TYPE_FIELD, DNS_OPTIONS_FIELD, CLIENT_TOKEN_FIELD, PRIVATE_DNS_ENABLED_FIELD, TAG_SPECIFICATIONS_FIELD, SUBNET_CONFIGURATIONS_FIELD, SERVICE_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("VpcEndpointType", VPC_ENDPOINT_TYPE_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("ServiceName", SERVICE_NAME_FIELD);
            this.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
            this.put("RouteTableId", ROUTE_TABLE_IDS_FIELD);
            this.put("SubnetId", SUBNET_IDS_FIELD);
            this.put("SecurityGroupId", SECURITY_GROUP_IDS_FIELD);
            this.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
            this.put("DnsOptions", DNS_OPTIONS_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("PrivateDnsEnabled", PRIVATE_DNS_ENABLED_FIELD);
            this.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
            this.put("SubnetConfiguration", SUBNET_CONFIGURATIONS_FIELD);
            this.put("ServiceRegion", SERVICE_REGION_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String vpcEndpointType;
    private final String vpcId;
    private final String serviceName;
    private final String policyDocument;
    private final List<String> routeTableIds;
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final String ipAddressType;
    private final DnsOptionsSpecification dnsOptions;
    private final String clientToken;
    private final Boolean privateDnsEnabled;
    private final List<TagSpecification> tagSpecifications;
    private final List<SubnetConfiguration> subnetConfigurations;
    private final String serviceRegion;

    private CreateVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.vpcEndpointType = builder.vpcEndpointType;
        this.vpcId = builder.vpcId;
        this.serviceName = builder.serviceName;
        this.policyDocument = builder.policyDocument;
        this.routeTableIds = builder.routeTableIds;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.ipAddressType = builder.ipAddressType;
        this.dnsOptions = builder.dnsOptions;
        this.clientToken = builder.clientToken;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.tagSpecifications = builder.tagSpecifications;
        this.subnetConfigurations = builder.subnetConfigurations;
        this.serviceRegion = builder.serviceRegion;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final VpcEndpointType vpcEndpointType() {
        return VpcEndpointType.fromValue(this.vpcEndpointType);
    }

    public final String vpcEndpointTypeAsString() {
        return this.vpcEndpointType;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final boolean hasRouteTableIds() {
        return this.routeTableIds != null && !(this.routeTableIds instanceof SdkAutoConstructList);
    }

    public final List<String> routeTableIds() {
        return this.routeTableIds;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final DnsOptionsSpecification dnsOptions() {
        return this.dnsOptions;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean privateDnsEnabled() {
        return this.privateDnsEnabled;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final boolean hasSubnetConfigurations() {
        return this.subnetConfigurations != null && !(this.subnetConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SubnetConfiguration> subnetConfigurations() {
        return this.subnetConfigurations;
    }

    public final String serviceRegion() {
        return this.serviceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteTableIds() ? this.routeTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetConfigurations() ? this.subnetConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointRequest)) {
            return false;
        }
        CreateVpcEndpointRequest other = (CreateVpcEndpointRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.vpcEndpointTypeAsString(), other.vpcEndpointTypeAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.policyDocument(), other.policyDocument()) && this.hasRouteTableIds() == other.hasRouteTableIds() && Objects.equals(this.routeTableIds(), other.routeTableIds()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.dnsOptions(), other.dnsOptions()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.privateDnsEnabled(), other.privateDnsEnabled()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && this.hasSubnetConfigurations() == other.hasSubnetConfigurations() && Objects.equals(this.subnetConfigurations(), other.subnetConfigurations()) && Objects.equals(this.serviceRegion(), other.serviceRegion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcEndpointRequest").add("DryRun", (Object)this.dryRun()).add("VpcEndpointType", (Object)this.vpcEndpointTypeAsString()).add("VpcId", (Object)this.vpcId()).add("ServiceName", (Object)this.serviceName()).add("PolicyDocument", (Object)this.policyDocument()).add("RouteTableIds", this.hasRouteTableIds() ? this.routeTableIds() : null).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("DnsOptions", (Object)this.dnsOptions()).add("ClientToken", (Object)this.clientToken()).add("PrivateDnsEnabled", (Object)this.privateDnsEnabled()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("SubnetConfigurations", this.hasSubnetConfigurations() ? this.subnetConfigurations() : null).add("ServiceRegion", (Object)this.serviceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "VpcEndpointType": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointTypeAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "RouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.routeTableIds()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "DnsOptions": {
                return Optional.ofNullable(clazz.cast(this.dnsOptions()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "PrivateDnsEnabled": {
                return Optional.ofNullable(clazz.cast(this.privateDnsEnabled()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "SubnetConfigurations": {
                return Optional.ofNullable(clazz.cast(this.subnetConfigurations()));
            }
            case "ServiceRegion": {
                return Optional.ofNullable(clazz.cast(this.serviceRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointRequest, T> g) {
        return obj -> g.apply((CreateVpcEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String vpcEndpointType;
        private String vpcId;
        private String serviceName;
        private String policyDocument;
        private List<String> routeTableIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String ipAddressType;
        private DnsOptionsSpecification dnsOptions;
        private String clientToken;
        private Boolean privateDnsEnabled;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<SubnetConfiguration> subnetConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String serviceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.vpcEndpointType(model.vpcEndpointType);
            this.vpcId(model.vpcId);
            this.serviceName(model.serviceName);
            this.policyDocument(model.policyDocument);
            this.routeTableIds(model.routeTableIds);
            this.subnetIds(model.subnetIds);
            this.securityGroupIds(model.securityGroupIds);
            this.ipAddressType(model.ipAddressType);
            this.dnsOptions(model.dnsOptions);
            this.clientToken(model.clientToken);
            this.privateDnsEnabled(model.privateDnsEnabled);
            this.tagSpecifications(model.tagSpecifications);
            this.subnetConfigurations(model.subnetConfigurations);
            this.serviceRegion(model.serviceRegion);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getVpcEndpointType() {
            return this.vpcEndpointType;
        }

        public final void setVpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
        }

        @Override
        public final Builder vpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        @Override
        public final Builder vpcEndpointType(VpcEndpointType vpcEndpointType) {
            this.vpcEndpointType(vpcEndpointType == null ? null : vpcEndpointType.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final Collection<String> getRouteTableIds() {
            if (this.routeTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routeTableIds;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = VpcEndpointRouteTableIdListCopier.copy(routeTableIds);
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = VpcEndpointRouteTableIdListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String ... routeTableIds) {
            this.routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = VpcEndpointSubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = VpcEndpointSubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final DnsOptionsSpecification.Builder getDnsOptions() {
            return this.dnsOptions != null ? this.dnsOptions.toBuilder() : null;
        }

        public final void setDnsOptions(DnsOptionsSpecification.BuilderImpl dnsOptions) {
            this.dnsOptions = dnsOptions != null ? dnsOptions.build() : null;
        }

        @Override
        public final Builder dnsOptions(DnsOptionsSpecification dnsOptions) {
            this.dnsOptions = dnsOptions;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SubnetConfiguration.Builder> getSubnetConfigurations() {
            List<SubnetConfiguration.Builder> result = SubnetConfigurationsListCopier.copyToBuilder(this.subnetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetConfigurations(Collection<SubnetConfiguration.BuilderImpl> subnetConfigurations) {
            this.subnetConfigurations = SubnetConfigurationsListCopier.copyFromBuilder(subnetConfigurations);
        }

        @Override
        public final Builder subnetConfigurations(Collection<SubnetConfiguration> subnetConfigurations) {
            this.subnetConfigurations = SubnetConfigurationsListCopier.copy(subnetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetConfigurations(SubnetConfiguration ... subnetConfigurations) {
            this.subnetConfigurations(Arrays.asList(subnetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetConfigurations(Consumer<SubnetConfiguration.Builder> ... subnetConfigurations) {
            this.subnetConfigurations(Stream.of(subnetConfigurations).map(c -> (SubnetConfiguration)((SubnetConfiguration.Builder)SubnetConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceRegion() {
            return this.serviceRegion;
        }

        public final void setServiceRegion(String serviceRegion) {
            this.serviceRegion = serviceRegion;
        }

        @Override
        public final Builder serviceRegion(String serviceRegion) {
            this.serviceRegion = serviceRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcEndpointRequest build() {
            return new CreateVpcEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcEndpointRequest> {
        public Builder dryRun(Boolean var1);

        public Builder vpcEndpointType(String var1);

        public Builder vpcEndpointType(VpcEndpointType var1);

        public Builder vpcId(String var1);

        public Builder serviceName(String var1);

        public Builder policyDocument(String var1);

        public Builder routeTableIds(Collection<String> var1);

        public Builder routeTableIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder dnsOptions(DnsOptionsSpecification var1);

        default public Builder dnsOptions(Consumer<DnsOptionsSpecification.Builder> dnsOptions) {
            return this.dnsOptions((DnsOptionsSpecification)((DnsOptionsSpecification.Builder)DnsOptionsSpecification.builder().applyMutation(dnsOptions)).build());
        }

        public Builder clientToken(String var1);

        public Builder privateDnsEnabled(Boolean var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder subnetConfigurations(Collection<SubnetConfiguration> var1);

        public Builder subnetConfigurations(SubnetConfiguration ... var1);

        public Builder subnetConfigurations(Consumer<SubnetConfiguration.Builder> ... var1);

        public Builder serviceRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

