/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachVerifiedAccessTrustProviderRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AttachVerifiedAccessTrustProviderRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessInstanceId").getter(AttachVerifiedAccessTrustProviderRequest.getter(AttachVerifiedAccessTrustProviderRequest::verifiedAccessInstanceId)).setter(AttachVerifiedAccessTrustProviderRequest.setter(Builder::verifiedAccessInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId").unmarshallLocationName("VerifiedAccessInstanceId").build()}).build();
    private static final SdkField<String> VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessTrustProviderId").getter(AttachVerifiedAccessTrustProviderRequest.getter(AttachVerifiedAccessTrustProviderRequest::verifiedAccessTrustProviderId)).setter(AttachVerifiedAccessTrustProviderRequest.setter(Builder::verifiedAccessTrustProviderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderId").unmarshallLocationName("VerifiedAccessTrustProviderId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AttachVerifiedAccessTrustProviderRequest.getter(AttachVerifiedAccessTrustProviderRequest::clientToken)).setter(AttachVerifiedAccessTrustProviderRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(AttachVerifiedAccessTrustProviderRequest.getter(AttachVerifiedAccessTrustProviderRequest::dryRun)).setter(AttachVerifiedAccessTrustProviderRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_INSTANCE_ID_FIELD, VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VerifiedAccessInstanceId", VERIFIED_ACCESS_INSTANCE_ID_FIELD);
            this.put("VerifiedAccessTrustProviderId", VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String verifiedAccessInstanceId;
    private final String verifiedAccessTrustProviderId;
    private final String clientToken;
    private final Boolean dryRun;

    private AttachVerifiedAccessTrustProviderRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.verifiedAccessTrustProviderId = builder.verifiedAccessTrustProviderId;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
    }

    public final String verifiedAccessInstanceId() {
        return this.verifiedAccessInstanceId;
    }

    public final String verifiedAccessTrustProviderId() {
        return this.verifiedAccessTrustProviderId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessTrustProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVerifiedAccessTrustProviderRequest)) {
            return false;
        }
        AttachVerifiedAccessTrustProviderRequest other = (AttachVerifiedAccessTrustProviderRequest)((Object)obj);
        return Objects.equals(this.verifiedAccessInstanceId(), other.verifiedAccessInstanceId()) && Objects.equals(this.verifiedAccessTrustProviderId(), other.verifiedAccessTrustProviderId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"AttachVerifiedAccessTrustProviderRequest").add("VerifiedAccessInstanceId", (Object)this.verifiedAccessInstanceId()).add("VerifiedAccessTrustProviderId", (Object)this.verifiedAccessTrustProviderId()).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessInstanceId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessInstanceId()));
            }
            case "VerifiedAccessTrustProviderId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessTrustProviderId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AttachVerifiedAccessTrustProviderRequest, T> g) {
        return obj -> g.apply((AttachVerifiedAccessTrustProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String verifiedAccessInstanceId;
        private String verifiedAccessTrustProviderId;
        private String clientToken;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVerifiedAccessTrustProviderRequest model) {
            super(model);
            this.verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            this.verifiedAccessTrustProviderId(model.verifiedAccessTrustProviderId);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
        }

        public final String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getVerifiedAccessTrustProviderId() {
            return this.verifiedAccessTrustProviderId;
        }

        public final void setVerifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
        }

        @Override
        public final Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachVerifiedAccessTrustProviderRequest build() {
            return new AttachVerifiedAccessTrustProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachVerifiedAccessTrustProviderRequest> {
        public Builder verifiedAccessInstanceId(String var1);

        public Builder verifiedAccessTrustProviderId(String var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

