/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.PartitionLoadFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AthenaIntegration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AthenaIntegration> {
    private static final SdkField<String> INTEGRATION_RESULT_S3_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationResultS3DestinationArn").getter(AthenaIntegration.getter(AthenaIntegration::integrationResultS3DestinationArn)).setter(AthenaIntegration.setter(Builder::integrationResultS3DestinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationResultS3DestinationArn").unmarshallLocationName("IntegrationResultS3DestinationArn").build()}).build();
    private static final SdkField<String> PARTITION_LOAD_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartitionLoadFrequency").getter(AthenaIntegration.getter(AthenaIntegration::partitionLoadFrequencyAsString)).setter(AthenaIntegration.setter(Builder::partitionLoadFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionLoadFrequency").unmarshallLocationName("PartitionLoadFrequency").build()}).build();
    private static final SdkField<Instant> PARTITION_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PartitionStartDate").getter(AthenaIntegration.getter(AthenaIntegration::partitionStartDate)).setter(AthenaIntegration.setter(Builder::partitionStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionStartDate").unmarshallLocationName("PartitionStartDate").build()}).build();
    private static final SdkField<Instant> PARTITION_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PartitionEndDate").getter(AthenaIntegration.getter(AthenaIntegration::partitionEndDate)).setter(AthenaIntegration.setter(Builder::partitionEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionEndDate").unmarshallLocationName("PartitionEndDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_RESULT_S3_DESTINATION_ARN_FIELD, PARTITION_LOAD_FREQUENCY_FIELD, PARTITION_START_DATE_FIELD, PARTITION_END_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IntegrationResultS3DestinationArn", INTEGRATION_RESULT_S3_DESTINATION_ARN_FIELD);
            this.put("PartitionLoadFrequency", PARTITION_LOAD_FREQUENCY_FIELD);
            this.put("PartitionStartDate", PARTITION_START_DATE_FIELD);
            this.put("PartitionEndDate", PARTITION_END_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String integrationResultS3DestinationArn;
    private final String partitionLoadFrequency;
    private final Instant partitionStartDate;
    private final Instant partitionEndDate;

    private AthenaIntegration(BuilderImpl builder) {
        this.integrationResultS3DestinationArn = builder.integrationResultS3DestinationArn;
        this.partitionLoadFrequency = builder.partitionLoadFrequency;
        this.partitionStartDate = builder.partitionStartDate;
        this.partitionEndDate = builder.partitionEndDate;
    }

    public final String integrationResultS3DestinationArn() {
        return this.integrationResultS3DestinationArn;
    }

    public final PartitionLoadFrequency partitionLoadFrequency() {
        return PartitionLoadFrequency.fromValue(this.partitionLoadFrequency);
    }

    public final String partitionLoadFrequencyAsString() {
        return this.partitionLoadFrequency;
    }

    public final Instant partitionStartDate() {
        return this.partitionStartDate;
    }

    public final Instant partitionEndDate() {
        return this.partitionEndDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationResultS3DestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionLoadFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionEndDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AthenaIntegration)) {
            return false;
        }
        AthenaIntegration other = (AthenaIntegration)obj;
        return Objects.equals(this.integrationResultS3DestinationArn(), other.integrationResultS3DestinationArn()) && Objects.equals(this.partitionLoadFrequencyAsString(), other.partitionLoadFrequencyAsString()) && Objects.equals(this.partitionStartDate(), other.partitionStartDate()) && Objects.equals(this.partitionEndDate(), other.partitionEndDate());
    }

    public final String toString() {
        return ToString.builder((String)"AthenaIntegration").add("IntegrationResultS3DestinationArn", (Object)this.integrationResultS3DestinationArn()).add("PartitionLoadFrequency", (Object)this.partitionLoadFrequencyAsString()).add("PartitionStartDate", (Object)this.partitionStartDate()).add("PartitionEndDate", (Object)this.partitionEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegrationResultS3DestinationArn": {
                return Optional.ofNullable(clazz.cast(this.integrationResultS3DestinationArn()));
            }
            case "PartitionLoadFrequency": {
                return Optional.ofNullable(clazz.cast(this.partitionLoadFrequencyAsString()));
            }
            case "PartitionStartDate": {
                return Optional.ofNullable(clazz.cast(this.partitionStartDate()));
            }
            case "PartitionEndDate": {
                return Optional.ofNullable(clazz.cast(this.partitionEndDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AthenaIntegration, T> g) {
        return obj -> g.apply((AthenaIntegration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String integrationResultS3DestinationArn;
        private String partitionLoadFrequency;
        private Instant partitionStartDate;
        private Instant partitionEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AthenaIntegration model) {
            this.integrationResultS3DestinationArn(model.integrationResultS3DestinationArn);
            this.partitionLoadFrequency(model.partitionLoadFrequency);
            this.partitionStartDate(model.partitionStartDate);
            this.partitionEndDate(model.partitionEndDate);
        }

        public final String getIntegrationResultS3DestinationArn() {
            return this.integrationResultS3DestinationArn;
        }

        public final void setIntegrationResultS3DestinationArn(String integrationResultS3DestinationArn) {
            this.integrationResultS3DestinationArn = integrationResultS3DestinationArn;
        }

        @Override
        public final Builder integrationResultS3DestinationArn(String integrationResultS3DestinationArn) {
            this.integrationResultS3DestinationArn = integrationResultS3DestinationArn;
            return this;
        }

        public final String getPartitionLoadFrequency() {
            return this.partitionLoadFrequency;
        }

        public final void setPartitionLoadFrequency(String partitionLoadFrequency) {
            this.partitionLoadFrequency = partitionLoadFrequency;
        }

        @Override
        public final Builder partitionLoadFrequency(String partitionLoadFrequency) {
            this.partitionLoadFrequency = partitionLoadFrequency;
            return this;
        }

        @Override
        public final Builder partitionLoadFrequency(PartitionLoadFrequency partitionLoadFrequency) {
            this.partitionLoadFrequency(partitionLoadFrequency == null ? null : partitionLoadFrequency.toString());
            return this;
        }

        public final Instant getPartitionStartDate() {
            return this.partitionStartDate;
        }

        public final void setPartitionStartDate(Instant partitionStartDate) {
            this.partitionStartDate = partitionStartDate;
        }

        @Override
        public final Builder partitionStartDate(Instant partitionStartDate) {
            this.partitionStartDate = partitionStartDate;
            return this;
        }

        public final Instant getPartitionEndDate() {
            return this.partitionEndDate;
        }

        public final void setPartitionEndDate(Instant partitionEndDate) {
            this.partitionEndDate = partitionEndDate;
        }

        @Override
        public final Builder partitionEndDate(Instant partitionEndDate) {
            this.partitionEndDate = partitionEndDate;
            return this;
        }

        public AthenaIntegration build() {
            return new AthenaIntegration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AthenaIntegration> {
        public Builder integrationResultS3DestinationArn(String var1);

        public Builder partitionLoadFrequency(String var1);

        public Builder partitionLoadFrequency(PartitionLoadFrequency var1);

        public Builder partitionStartDate(Instant var1);

        public Builder partitionEndDate(Instant var1);
    }
}

