/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpPrefixListCopier;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssignPrivateIpAddressesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
    private static final SdkField<List<String>> IPV4_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv4Prefixes").getter(AssignPrivateIpAddressesRequest.getter(AssignPrivateIpAddressesRequest::ipv4Prefixes)).setter(AssignPrivateIpAddressesRequest.setter(Builder::ipv4Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefix").unmarshallLocationName("Ipv4Prefix").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv4PrefixCount").getter(AssignPrivateIpAddressesRequest.getter(AssignPrivateIpAddressesRequest::ipv4PrefixCount)).setter(AssignPrivateIpAddressesRequest.setter(Builder::ipv4PrefixCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount").unmarshallLocationName("Ipv4PrefixCount").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(AssignPrivateIpAddressesRequest.getter(AssignPrivateIpAddressesRequest::networkInterfaceId)).setter(AssignPrivateIpAddressesRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<List<String>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(AssignPrivateIpAddressesRequest.getter(AssignPrivateIpAddressesRequest::privateIpAddresses)).setter(AssignPrivateIpAddressesRequest.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build(), ListTrait.builder().memberLocationName("PrivateIpAddress").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("PrivateIpAddress").build()}).build()).build()}).build();
    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondaryPrivateIpAddressCount").getter(AssignPrivateIpAddressesRequest.getter(AssignPrivateIpAddressesRequest::secondaryPrivateIpAddressCount)).setter(AssignPrivateIpAddressesRequest.setter(Builder::secondaryPrivateIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount").unmarshallLocationName("secondaryPrivateIpAddressCount").build()}).build();
    private static final SdkField<Boolean> ALLOW_REASSIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowReassignment").getter(AssignPrivateIpAddressesRequest.getter(AssignPrivateIpAddressesRequest::allowReassignment)).setter(AssignPrivateIpAddressesRequest.setter(Builder::allowReassignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowReassignment").unmarshallLocationName("allowReassignment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV4_PREFIXES_FIELD, IPV4_PREFIX_COUNT_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, ALLOW_REASSIGNMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Ipv4Prefix", IPV4_PREFIXES_FIELD);
            this.put("Ipv4PrefixCount", IPV4_PREFIX_COUNT_FIELD);
            this.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
            this.put("PrivateIpAddress", PRIVATE_IP_ADDRESSES_FIELD);
            this.put("SecondaryPrivateIpAddressCount", SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD);
            this.put("AllowReassignment", ALLOW_REASSIGNMENT_FIELD);
        }
    });
    private final List<String> ipv4Prefixes;
    private final Integer ipv4PrefixCount;
    private final String networkInterfaceId;
    private final List<String> privateIpAddresses;
    private final Integer secondaryPrivateIpAddressCount;
    private final Boolean allowReassignment;

    private AssignPrivateIpAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.allowReassignment = builder.allowReassignment;
    }

    public final boolean hasIpv4Prefixes() {
        return this.ipv4Prefixes != null && !(this.ipv4Prefixes instanceof SdkAutoConstructList);
    }

    public final List<String> ipv4Prefixes() {
        return this.ipv4Prefixes;
    }

    public final Integer ipv4PrefixCount() {
        return this.ipv4PrefixCount;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public final Boolean allowReassignment() {
        return this.allowReassignment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowReassignment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesRequest)) {
            return false;
        }
        AssignPrivateIpAddressesRequest other = (AssignPrivateIpAddressesRequest)((Object)obj);
        return this.hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(this.ipv4Prefixes(), other.ipv4Prefixes()) && Objects.equals(this.ipv4PrefixCount(), other.ipv4PrefixCount()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount()) && Objects.equals(this.allowReassignment(), other.allowReassignment());
    }

    public final String toString() {
        return ToString.builder((String)"AssignPrivateIpAddressesRequest").add("Ipv4Prefixes", this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null).add("Ipv4PrefixCount", (Object)this.ipv4PrefixCount()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("SecondaryPrivateIpAddressCount", (Object)this.secondaryPrivateIpAddressCount()).add("AllowReassignment", (Object)this.allowReassignment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv4Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv4Prefixes()));
            }
            case "Ipv4PrefixCount": {
                return Optional.ofNullable(clazz.cast(this.ipv4PrefixCount()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "SecondaryPrivateIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.secondaryPrivateIpAddressCount()));
            }
            case "AllowReassignment": {
                return Optional.ofNullable(clazz.cast(this.allowReassignment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssignPrivateIpAddressesRequest, T> g) {
        return obj -> g.apply((AssignPrivateIpAddressesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv4PrefixCount;
        private String networkInterfaceId;
        private List<String> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Integer secondaryPrivateIpAddressCount;
        private Boolean allowReassignment;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesRequest model) {
            super(model);
            this.ipv4Prefixes(model.ipv4Prefixes);
            this.ipv4PrefixCount(model.ipv4PrefixCount);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIpAddresses(model.privateIpAddresses);
            this.secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            this.allowReassignment(model.allowReassignment);
        }

        public final Collection<String> getIpv4Prefixes() {
            if (this.ipv4Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv4Prefixes;
        }

        public final void setIpv4Prefixes(Collection<String> ipv4Prefixes) {
            this.ipv4Prefixes = IpPrefixListCopier.copy(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<String> ipv4Prefixes) {
            this.ipv4Prefixes = IpPrefixListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(String ... ipv4Prefixes) {
            this.ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        public final Integer getIpv4PrefixCount() {
            return this.ipv4PrefixCount;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        @Override
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Collection<String> getPrivateIpAddresses() {
            if (this.privateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.privateIpAddresses;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final Boolean getAllowReassignment() {
            return this.allowReassignment;
        }

        public final void setAllowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
        }

        @Override
        public final Builder allowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssignPrivateIpAddressesRequest build() {
            return new AssignPrivateIpAddressesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
        public Builder ipv4Prefixes(Collection<String> var1);

        public Builder ipv4Prefixes(String ... var1);

        public Builder ipv4PrefixCount(Integer var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddresses(Collection<String> var1);

        public Builder privateIpAddresses(String ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);

        public Builder allowReassignment(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

