/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NatGatewayAddress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NatGatewayAddress> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(NatGatewayAddress.getter(NatGatewayAddress::allocationId)).setter(NatGatewayAddress.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("allocationId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(NatGatewayAddress.getter(NatGatewayAddress::networkInterfaceId)).setter(NatGatewayAddress.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> PRIVATE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIp").getter(NatGatewayAddress.getter(NatGatewayAddress::privateIp)).setter(NatGatewayAddress.setter(Builder::privateIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIp").unmarshallLocationName("privateIp").build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(NatGatewayAddress.getter(NatGatewayAddress::publicIp)).setter(NatGatewayAddress.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("publicIp").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(NatGatewayAddress.getter(NatGatewayAddress::associationId)).setter(NatGatewayAddress.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<Boolean> IS_PRIMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPrimary").getter(NatGatewayAddress.getter(NatGatewayAddress::isPrimary)).setter(NatGatewayAddress.setter(Builder::isPrimary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPrimary").unmarshallLocationName("isPrimary").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(NatGatewayAddress.getter(NatGatewayAddress::failureMessage)).setter(NatGatewayAddress.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").unmarshallLocationName("failureMessage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NatGatewayAddress.getter(NatGatewayAddress::statusAsString)).setter(NatGatewayAddress.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_FIELD, PUBLIC_IP_FIELD, ASSOCIATION_ID_FIELD, IS_PRIMARY_FIELD, FAILURE_MESSAGE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AllocationId", ALLOCATION_ID_FIELD);
            this.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
            this.put("PrivateIp", PRIVATE_IP_FIELD);
            this.put("PublicIp", PUBLIC_IP_FIELD);
            this.put("AssociationId", ASSOCIATION_ID_FIELD);
            this.put("IsPrimary", IS_PRIMARY_FIELD);
            this.put("FailureMessage", FAILURE_MESSAGE_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String allocationId;
    private final String networkInterfaceId;
    private final String privateIp;
    private final String publicIp;
    private final String associationId;
    private final Boolean isPrimary;
    private final String failureMessage;
    private final String status;

    private NatGatewayAddress(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIp = builder.privateIp;
        this.publicIp = builder.publicIp;
        this.associationId = builder.associationId;
        this.isPrimary = builder.isPrimary;
        this.failureMessage = builder.failureMessage;
        this.status = builder.status;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String privateIp() {
        return this.privateIp;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final Boolean isPrimary() {
        return this.isPrimary;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final NatGatewayAddressStatus status() {
        return NatGatewayAddressStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPrimary());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGatewayAddress)) {
            return false;
        }
        NatGatewayAddress other = (NatGatewayAddress)obj;
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIp(), other.privateIp()) && Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.isPrimary(), other.isPrimary()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NatGatewayAddress").add("AllocationId", (Object)this.allocationId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("PrivateIp", (Object)this.privateIp()).add("PublicIp", (Object)this.publicIp()).add("AssociationId", (Object)this.associationId()).add("IsPrimary", (Object)this.isPrimary()).add("FailureMessage", (Object)this.failureMessage()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIp": {
                return Optional.ofNullable(clazz.cast(this.privateIp()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "IsPrimary": {
                return Optional.ofNullable(clazz.cast(this.isPrimary()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NatGatewayAddress, T> g) {
        return obj -> g.apply((NatGatewayAddress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationId;
        private String networkInterfaceId;
        private String privateIp;
        private String publicIp;
        private String associationId;
        private Boolean isPrimary;
        private String failureMessage;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(NatGatewayAddress model) {
            this.allocationId(model.allocationId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIp(model.privateIp);
            this.publicIp(model.publicIp);
            this.associationId(model.associationId);
            this.isPrimary(model.isPrimary);
            this.failureMessage(model.failureMessage);
            this.status(model.status);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getPrivateIp() {
            return this.privateIp;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final Boolean getIsPrimary() {
            return this.isPrimary;
        }

        public final void setIsPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
        }

        @Override
        public final Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NatGatewayAddressStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public NatGatewayAddress build() {
            return new NatGatewayAddress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NatGatewayAddress> {
        public Builder allocationId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIp(String var1);

        public Builder publicIp(String var1);

        public Builder associationId(String var1);

        public Builder isPrimary(Boolean var1);

        public Builder failureMessage(String var1);

        public Builder status(String var1);

        public Builder status(NatGatewayAddressStatus var1);
    }
}

