/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Placement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Placement> {
    private static final SdkField<String> AFFINITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Affinity").getter(Placement.getter(Placement::affinity)).setter(Placement.setter(Builder::affinity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Affinity").unmarshallLocationName("affinity").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(Placement.getter(Placement::groupName)).setter(Placement.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<Integer> PARTITION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PartitionNumber").getter(Placement.getter(Placement::partitionNumber)).setter(Placement.setter(Builder::partitionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionNumber").unmarshallLocationName("partitionNumber").build()}).build();
    private static final SdkField<String> HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostId").getter(Placement.getter(Placement::hostId)).setter(Placement.setter(Builder::hostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").unmarshallLocationName("hostId").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(Placement.getter(Placement::tenancyAsString)).setter(Placement.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("tenancy").build()}).build();
    private static final SdkField<String> SPREAD_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpreadDomain").getter(Placement.getter(Placement::spreadDomain)).setter(Placement.setter(Builder::spreadDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpreadDomain").unmarshallLocationName("spreadDomain").build()}).build();
    private static final SdkField<String> HOST_RESOURCE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostResourceGroupArn").getter(Placement.getter(Placement::hostResourceGroupArn)).setter(Placement.setter(Builder::hostResourceGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostResourceGroupArn").unmarshallLocationName("hostResourceGroupArn").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(Placement.getter(Placement::groupId)).setter(Placement.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Placement.getter(Placement::availabilityZone)).setter(Placement.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFINITY_FIELD, GROUP_NAME_FIELD, PARTITION_NUMBER_FIELD, HOST_ID_FIELD, TENANCY_FIELD, SPREAD_DOMAIN_FIELD, HOST_RESOURCE_GROUP_ARN_FIELD, GROUP_ID_FIELD, AVAILABILITY_ZONE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String affinity;
    private final String groupName;
    private final Integer partitionNumber;
    private final String hostId;
    private final String tenancy;
    private final String spreadDomain;
    private final String hostResourceGroupArn;
    private final String groupId;
    private final String availabilityZone;

    private Placement(BuilderImpl builder) {
        this.affinity = builder.affinity;
        this.groupName = builder.groupName;
        this.partitionNumber = builder.partitionNumber;
        this.hostId = builder.hostId;
        this.tenancy = builder.tenancy;
        this.spreadDomain = builder.spreadDomain;
        this.hostResourceGroupArn = builder.hostResourceGroupArn;
        this.groupId = builder.groupId;
        this.availabilityZone = builder.availabilityZone;
    }

    public final String affinity() {
        return this.affinity;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final Integer partitionNumber() {
        return this.partitionNumber;
    }

    public final String hostId() {
        return this.hostId;
    }

    public final Tenancy tenancy() {
        return Tenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final String spreadDomain() {
        return this.spreadDomain;
    }

    public final String hostResourceGroupArn() {
        return this.hostResourceGroupArn;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.affinity());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spreadDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostResourceGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Placement)) {
            return false;
        }
        Placement other = (Placement)obj;
        return Objects.equals(this.affinity(), other.affinity()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.partitionNumber(), other.partitionNumber()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.spreadDomain(), other.spreadDomain()) && Objects.equals(this.hostResourceGroupArn(), other.hostResourceGroupArn()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.availabilityZone(), other.availabilityZone());
    }

    public final String toString() {
        return ToString.builder((String)"Placement").add("Affinity", (Object)this.affinity()).add("GroupName", (Object)this.groupName()).add("PartitionNumber", (Object)this.partitionNumber()).add("HostId", (Object)this.hostId()).add("Tenancy", (Object)this.tenancyAsString()).add("SpreadDomain", (Object)this.spreadDomain()).add("HostResourceGroupArn", (Object)this.hostResourceGroupArn()).add("GroupId", (Object)this.groupId()).add("AvailabilityZone", (Object)this.availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Affinity": {
                return Optional.ofNullable(clazz.cast(this.affinity()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "PartitionNumber": {
                return Optional.ofNullable(clazz.cast(this.partitionNumber()));
            }
            case "HostId": {
                return Optional.ofNullable(clazz.cast(this.hostId()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "SpreadDomain": {
                return Optional.ofNullable(clazz.cast(this.spreadDomain()));
            }
            case "HostResourceGroupArn": {
                return Optional.ofNullable(clazz.cast(this.hostResourceGroupArn()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Placement, T> g) {
        return obj -> g.apply((Placement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String affinity;
        private String groupName;
        private Integer partitionNumber;
        private String hostId;
        private String tenancy;
        private String spreadDomain;
        private String hostResourceGroupArn;
        private String groupId;
        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(Placement model) {
            this.affinity(model.affinity);
            this.groupName(model.groupName);
            this.partitionNumber(model.partitionNumber);
            this.hostId(model.hostId);
            this.tenancy(model.tenancy);
            this.spreadDomain(model.spreadDomain);
            this.hostResourceGroupArn(model.hostResourceGroupArn);
            this.groupId(model.groupId);
            this.availabilityZone(model.availabilityZone);
        }

        public final String getAffinity() {
            return this.affinity;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final Integer getPartitionNumber() {
            return this.partitionNumber;
        }

        public final void setPartitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
        }

        @Override
        public final Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public final String getHostId() {
            return this.hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final String getSpreadDomain() {
            return this.spreadDomain;
        }

        public final void setSpreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
        }

        @Override
        public final Builder spreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
            return this;
        }

        public final String getHostResourceGroupArn() {
            return this.hostResourceGroupArn;
        }

        public final void setHostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
        }

        @Override
        public final Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Placement build() {
            return new Placement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Placement> {
        public Builder affinity(String var1);

        public Builder groupName(String var1);

        public Builder partitionNumber(Integer var1);

        public Builder hostId(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(Tenancy var1);

        public Builder spreadDomain(String var1);

        public Builder hostResourceGroupArn(String var1);

        public Builder groupId(String var1);

        public Builder availabilityZone(String var1);
    }
}

