/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceImageMetadata;
import software.amazon.awssdk.services.ec2.model.InstanceImageMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceImageMetadataResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeInstanceImageMetadataResponse> {
    private static final SdkField<List<InstanceImageMetadata>> INSTANCE_IMAGE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceImageMetadata").getter(DescribeInstanceImageMetadataResponse.getter(DescribeInstanceImageMetadataResponse::instanceImageMetadata)).setter(DescribeInstanceImageMetadataResponse.setter(Builder::instanceImageMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceImageMetadataSet").unmarshallLocationName("instanceImageMetadataSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceImageMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstanceImageMetadataResponse.getter(DescribeInstanceImageMetadataResponse::nextToken)).setter(DescribeInstanceImageMetadataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IMAGE_METADATA_FIELD, NEXT_TOKEN_FIELD));
    private final List<InstanceImageMetadata> instanceImageMetadata;
    private final String nextToken;

    private DescribeInstanceImageMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.instanceImageMetadata = builder.instanceImageMetadata;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceImageMetadata() {
        return this.instanceImageMetadata != null && !(this.instanceImageMetadata instanceof SdkAutoConstructList);
    }

    public final List<InstanceImageMetadata> instanceImageMetadata() {
        return this.instanceImageMetadata;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceImageMetadata() ? this.instanceImageMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceImageMetadataResponse)) {
            return false;
        }
        DescribeInstanceImageMetadataResponse other = (DescribeInstanceImageMetadataResponse)((Object)obj);
        return this.hasInstanceImageMetadata() == other.hasInstanceImageMetadata() && Objects.equals(this.instanceImageMetadata(), other.instanceImageMetadata()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstanceImageMetadataResponse").add("InstanceImageMetadata", this.hasInstanceImageMetadata() ? this.instanceImageMetadata() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceImageMetadata": {
                return Optional.ofNullable(clazz.cast(this.instanceImageMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceImageMetadataResponse, T> g) {
        return obj -> g.apply((DescribeInstanceImageMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceImageMetadata> instanceImageMetadata = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceImageMetadataResponse model) {
            super(model);
            this.instanceImageMetadata(model.instanceImageMetadata);
            this.nextToken(model.nextToken);
        }

        public final List<InstanceImageMetadata.Builder> getInstanceImageMetadata() {
            List<InstanceImageMetadata.Builder> result = InstanceImageMetadataListCopier.copyToBuilder(this.instanceImageMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceImageMetadata(Collection<InstanceImageMetadata.BuilderImpl> instanceImageMetadata) {
            this.instanceImageMetadata = InstanceImageMetadataListCopier.copyFromBuilder(instanceImageMetadata);
        }

        @Override
        public final Builder instanceImageMetadata(Collection<InstanceImageMetadata> instanceImageMetadata) {
            this.instanceImageMetadata = InstanceImageMetadataListCopier.copy(instanceImageMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceImageMetadata(InstanceImageMetadata ... instanceImageMetadata) {
            this.instanceImageMetadata(Arrays.asList(instanceImageMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceImageMetadata(Consumer<InstanceImageMetadata.Builder> ... instanceImageMetadata) {
            this.instanceImageMetadata(Stream.of(instanceImageMetadata).map(c -> (InstanceImageMetadata)((InstanceImageMetadata.Builder)InstanceImageMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInstanceImageMetadataResponse build() {
            return new DescribeInstanceImageMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceImageMetadataResponse> {
        public Builder instanceImageMetadata(Collection<InstanceImageMetadata> var1);

        public Builder instanceImageMetadata(InstanceImageMetadata ... var1);

        public Builder instanceImageMetadata(Consumer<InstanceImageMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

