/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayConnectPeer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayConnectPeer> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(TransitGatewayConnectPeer.getter(TransitGatewayConnectPeer::transitGatewayAttachmentId)).setter(TransitGatewayConnectPeer.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("transitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_CONNECT_PEER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayConnectPeerId").getter(TransitGatewayConnectPeer.getter(TransitGatewayConnectPeer::transitGatewayConnectPeerId)).setter(TransitGatewayConnectPeer.setter(Builder::transitGatewayConnectPeerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayConnectPeerId").unmarshallLocationName("transitGatewayConnectPeerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayConnectPeer.getter(TransitGatewayConnectPeer::stateAsString)).setter(TransitGatewayConnectPeer.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TransitGatewayConnectPeer.getter(TransitGatewayConnectPeer::creationTime)).setter(TransitGatewayConnectPeer.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<TransitGatewayConnectPeerConfiguration> CONNECT_PEER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectPeerConfiguration").getter(TransitGatewayConnectPeer.getter(TransitGatewayConnectPeer::connectPeerConfiguration)).setter(TransitGatewayConnectPeer.setter(Builder::connectPeerConfiguration)).constructor(TransitGatewayConnectPeerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeerConfiguration").unmarshallLocationName("connectPeerConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TransitGatewayConnectPeer.getter(TransitGatewayConnectPeer::tags)).setter(TransitGatewayConnectPeer.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TRANSIT_GATEWAY_CONNECT_PEER_ID_FIELD, STATE_FIELD, CREATION_TIME_FIELD, CONNECT_PEER_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TransitGatewayAttachmentId", TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
            this.put("TransitGatewayConnectPeerId", TRANSIT_GATEWAY_CONNECT_PEER_ID_FIELD);
            this.put("State", STATE_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("ConnectPeerConfiguration", CONNECT_PEER_CONFIGURATION_FIELD);
            this.put("TagSet", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String transitGatewayAttachmentId;
    private final String transitGatewayConnectPeerId;
    private final String state;
    private final Instant creationTime;
    private final TransitGatewayConnectPeerConfiguration connectPeerConfiguration;
    private final List<Tag> tags;

    private TransitGatewayConnectPeer(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.transitGatewayConnectPeerId = builder.transitGatewayConnectPeerId;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.connectPeerConfiguration = builder.connectPeerConfiguration;
        this.tags = builder.tags;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final String transitGatewayConnectPeerId() {
        return this.transitGatewayConnectPeerId;
    }

    public final TransitGatewayConnectPeerState state() {
        return TransitGatewayConnectPeerState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final TransitGatewayConnectPeerConfiguration connectPeerConfiguration() {
        return this.connectPeerConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayConnectPeerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectPeerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConnectPeer)) {
            return false;
        }
        TransitGatewayConnectPeer other = (TransitGatewayConnectPeer)obj;
        return Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.transitGatewayConnectPeerId(), other.transitGatewayConnectPeerId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.connectPeerConfiguration(), other.connectPeerConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayConnectPeer").add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("TransitGatewayConnectPeerId", (Object)this.transitGatewayConnectPeerId()).add("State", (Object)this.stateAsString()).add("CreationTime", (Object)this.creationTime()).add("ConnectPeerConfiguration", (Object)this.connectPeerConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "TransitGatewayConnectPeerId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayConnectPeerId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ConnectPeerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.connectPeerConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConnectPeer, T> g) {
        return obj -> g.apply((TransitGatewayConnectPeer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayAttachmentId;
        private String transitGatewayConnectPeerId;
        private String state;
        private Instant creationTime;
        private TransitGatewayConnectPeerConfiguration connectPeerConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConnectPeer model) {
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.transitGatewayConnectPeerId(model.transitGatewayConnectPeerId);
            this.state(model.state);
            this.creationTime(model.creationTime);
            this.connectPeerConfiguration(model.connectPeerConfiguration);
            this.tags(model.tags);
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getTransitGatewayConnectPeerId() {
            return this.transitGatewayConnectPeerId;
        }

        public final void setTransitGatewayConnectPeerId(String transitGatewayConnectPeerId) {
            this.transitGatewayConnectPeerId = transitGatewayConnectPeerId;
        }

        @Override
        public final Builder transitGatewayConnectPeerId(String transitGatewayConnectPeerId) {
            this.transitGatewayConnectPeerId = transitGatewayConnectPeerId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayConnectPeerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final TransitGatewayConnectPeerConfiguration.Builder getConnectPeerConfiguration() {
            return this.connectPeerConfiguration != null ? this.connectPeerConfiguration.toBuilder() : null;
        }

        public final void setConnectPeerConfiguration(TransitGatewayConnectPeerConfiguration.BuilderImpl connectPeerConfiguration) {
            this.connectPeerConfiguration = connectPeerConfiguration != null ? connectPeerConfiguration.build() : null;
        }

        @Override
        public final Builder connectPeerConfiguration(TransitGatewayConnectPeerConfiguration connectPeerConfiguration) {
            this.connectPeerConfiguration = connectPeerConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TransitGatewayConnectPeer build() {
            return new TransitGatewayConnectPeer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayConnectPeer> {
        public Builder transitGatewayAttachmentId(String var1);

        public Builder transitGatewayConnectPeerId(String var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayConnectPeerState var1);

        public Builder creationTime(Instant var1);

        public Builder connectPeerConfiguration(TransitGatewayConnectPeerConfiguration var1);

        default public Builder connectPeerConfiguration(Consumer<TransitGatewayConnectPeerConfiguration.Builder> connectPeerConfiguration) {
            return this.connectPeerConfiguration((TransitGatewayConnectPeerConfiguration)((TransitGatewayConnectPeerConfiguration.Builder)TransitGatewayConnectPeerConfiguration.builder().applyMutation(connectPeerConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

