/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ImageMetadata;
import software.amazon.awssdk.services.ec2.model.InstanceState;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceImageMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceImageMetadata> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceImageMetadata.getter(InstanceImageMetadata::instanceId)).setter(InstanceImageMetadata.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(InstanceImageMetadata.getter(InstanceImageMetadata::instanceTypeAsString)).setter(InstanceImageMetadata.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LaunchTime").getter(InstanceImageMetadata.getter(InstanceImageMetadata::launchTime)).setter(InstanceImageMetadata.setter(Builder::launchTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").unmarshallLocationName("launchTime").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(InstanceImageMetadata.getter(InstanceImageMetadata::availabilityZone)).setter(InstanceImageMetadata.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZoneId").getter(InstanceImageMetadata.getter(InstanceImageMetadata::zoneId)).setter(InstanceImageMetadata.setter(Builder::zoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneId").unmarshallLocationName("zoneId").build()}).build();
    private static final SdkField<InstanceState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("State").getter(InstanceImageMetadata.getter(InstanceImageMetadata::state)).setter(InstanceImageMetadata.setter(Builder::state)).constructor(InstanceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceState").unmarshallLocationName("instanceState").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(InstanceImageMetadata.getter(InstanceImageMetadata::ownerId)).setter(InstanceImageMetadata.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOwnerId").unmarshallLocationName("instanceOwnerId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(InstanceImageMetadata.getter(InstanceImageMetadata::tags)).setter(InstanceImageMetadata.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<ImageMetadata> IMAGE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageMetadata").getter(InstanceImageMetadata.getter(InstanceImageMetadata::imageMetadata)).setter(InstanceImageMetadata.setter(Builder::imageMetadata)).constructor(ImageMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageMetadata").unmarshallLocationName("imageMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, LAUNCH_TIME_FIELD, AVAILABILITY_ZONE_FIELD, ZONE_ID_FIELD, STATE_FIELD, OWNER_ID_FIELD, TAGS_FIELD, IMAGE_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String instanceType;
    private final Instant launchTime;
    private final String availabilityZone;
    private final String zoneId;
    private final InstanceState state;
    private final String ownerId;
    private final List<Tag> tags;
    private final ImageMetadata imageMetadata;

    private InstanceImageMetadata(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.launchTime = builder.launchTime;
        this.availabilityZone = builder.availabilityZone;
        this.zoneId = builder.zoneId;
        this.state = builder.state;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
        this.imageMetadata = builder.imageMetadata;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Instant launchTime() {
        return this.launchTime;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String zoneId() {
        return this.zoneId;
    }

    public final InstanceState state() {
        return this.state;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ImageMetadata imageMetadata() {
        return this.imageMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceImageMetadata)) {
            return false;
        }
        InstanceImageMetadata other = (InstanceImageMetadata)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.launchTime(), other.launchTime()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.zoneId(), other.zoneId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.ownerId(), other.ownerId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.imageMetadata(), other.imageMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceImageMetadata").add("InstanceId", (Object)this.instanceId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("LaunchTime", (Object)this.launchTime()).add("AvailabilityZone", (Object)this.availabilityZone()).add("ZoneId", (Object)this.zoneId()).add("State", (Object)this.state()).add("OwnerId", (Object)this.ownerId()).add("Tags", this.hasTags() ? this.tags() : null).add("ImageMetadata", (Object)this.imageMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "LaunchTime": {
                return Optional.ofNullable(clazz.cast(this.launchTime()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "ZoneId": {
                return Optional.ofNullable(clazz.cast(this.zoneId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ImageMetadata": {
                return Optional.ofNullable(clazz.cast(this.imageMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceImageMetadata, T> g) {
        return obj -> g.apply((InstanceImageMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String instanceType;
        private Instant launchTime;
        private String availabilityZone;
        private String zoneId;
        private InstanceState state;
        private String ownerId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private ImageMetadata imageMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceImageMetadata model) {
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.launchTime(model.launchTime);
            this.availabilityZone(model.availabilityZone);
            this.zoneId(model.zoneId);
            this.state(model.state);
            this.ownerId(model.ownerId);
            this.tags(model.tags);
            this.imageMetadata(model.imageMetadata);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Instant getLaunchTime() {
            return this.launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getZoneId() {
            return this.zoneId;
        }

        public final void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public final Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public final InstanceState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ImageMetadata.Builder getImageMetadata() {
            return this.imageMetadata != null ? this.imageMetadata.toBuilder() : null;
        }

        public final void setImageMetadata(ImageMetadata.BuilderImpl imageMetadata) {
            this.imageMetadata = imageMetadata != null ? imageMetadata.build() : null;
        }

        @Override
        public final Builder imageMetadata(ImageMetadata imageMetadata) {
            this.imageMetadata = imageMetadata;
            return this;
        }

        public InstanceImageMetadata build() {
            return new InstanceImageMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceImageMetadata> {
        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder launchTime(Instant var1);

        public Builder availabilityZone(String var1);

        public Builder zoneId(String var1);

        public Builder state(InstanceState var1);

        default public Builder state(Consumer<InstanceState.Builder> state) {
            return this.state((InstanceState)((InstanceState.Builder)InstanceState.builder().applyMutation(state)).build());
        }

        public Builder ownerId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder imageMetadata(ImageMetadata var1);

        default public Builder imageMetadata(Consumer<ImageMetadata.Builder> imageMetadata) {
            return this.imageMetadata((ImageMetadata)((ImageMetadata.Builder)ImageMetadata.builder().applyMutation(imageMetadata)).build());
        }
    }
}

