/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityReservation;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCapacityReservationBySplittingResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateCapacityReservationBySplittingResponse> {
    private static final SdkField<CapacityReservation> SOURCE_CAPACITY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceCapacityReservation").getter(CreateCapacityReservationBySplittingResponse.getter(CreateCapacityReservationBySplittingResponse::sourceCapacityReservation)).setter(CreateCapacityReservationBySplittingResponse.setter(Builder::sourceCapacityReservation)).constructor(CapacityReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCapacityReservation").unmarshallLocationName("sourceCapacityReservation").build()}).build();
    private static final SdkField<CapacityReservation> DESTINATION_CAPACITY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationCapacityReservation").getter(CreateCapacityReservationBySplittingResponse.getter(CreateCapacityReservationBySplittingResponse::destinationCapacityReservation)).setter(CreateCapacityReservationBySplittingResponse.setter(Builder::destinationCapacityReservation)).constructor(CapacityReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCapacityReservation").unmarshallLocationName("destinationCapacityReservation").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(CreateCapacityReservationBySplittingResponse.getter(CreateCapacityReservationBySplittingResponse::instanceCount)).setter(CreateCapacityReservationBySplittingResponse.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CAPACITY_RESERVATION_FIELD, DESTINATION_CAPACITY_RESERVATION_FIELD, INSTANCE_COUNT_FIELD));
    private final CapacityReservation sourceCapacityReservation;
    private final CapacityReservation destinationCapacityReservation;
    private final Integer instanceCount;

    private CreateCapacityReservationBySplittingResponse(BuilderImpl builder) {
        super(builder);
        this.sourceCapacityReservation = builder.sourceCapacityReservation;
        this.destinationCapacityReservation = builder.destinationCapacityReservation;
        this.instanceCount = builder.instanceCount;
    }

    public final CapacityReservation sourceCapacityReservation() {
        return this.sourceCapacityReservation;
    }

    public final CapacityReservation destinationCapacityReservation() {
        return this.destinationCapacityReservation;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCapacityReservation());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCapacityReservation());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityReservationBySplittingResponse)) {
            return false;
        }
        CreateCapacityReservationBySplittingResponse other = (CreateCapacityReservationBySplittingResponse)((Object)obj);
        return Objects.equals(this.sourceCapacityReservation(), other.sourceCapacityReservation()) && Objects.equals(this.destinationCapacityReservation(), other.destinationCapacityReservation()) && Objects.equals(this.instanceCount(), other.instanceCount());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCapacityReservationBySplittingResponse").add("SourceCapacityReservation", (Object)this.sourceCapacityReservation()).add("DestinationCapacityReservation", (Object)this.destinationCapacityReservation()).add("InstanceCount", (Object)this.instanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceCapacityReservation": {
                return Optional.ofNullable(clazz.cast(this.sourceCapacityReservation()));
            }
            case "DestinationCapacityReservation": {
                return Optional.ofNullable(clazz.cast(this.destinationCapacityReservation()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityReservationBySplittingResponse, T> g) {
        return obj -> g.apply((CreateCapacityReservationBySplittingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private CapacityReservation sourceCapacityReservation;
        private CapacityReservation destinationCapacityReservation;
        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityReservationBySplittingResponse model) {
            super(model);
            this.sourceCapacityReservation(model.sourceCapacityReservation);
            this.destinationCapacityReservation(model.destinationCapacityReservation);
            this.instanceCount(model.instanceCount);
        }

        public final CapacityReservation.Builder getSourceCapacityReservation() {
            return this.sourceCapacityReservation != null ? this.sourceCapacityReservation.toBuilder() : null;
        }

        public final void setSourceCapacityReservation(CapacityReservation.BuilderImpl sourceCapacityReservation) {
            this.sourceCapacityReservation = sourceCapacityReservation != null ? sourceCapacityReservation.build() : null;
        }

        @Override
        public final Builder sourceCapacityReservation(CapacityReservation sourceCapacityReservation) {
            this.sourceCapacityReservation = sourceCapacityReservation;
            return this;
        }

        public final CapacityReservation.Builder getDestinationCapacityReservation() {
            return this.destinationCapacityReservation != null ? this.destinationCapacityReservation.toBuilder() : null;
        }

        public final void setDestinationCapacityReservation(CapacityReservation.BuilderImpl destinationCapacityReservation) {
            this.destinationCapacityReservation = destinationCapacityReservation != null ? destinationCapacityReservation.build() : null;
        }

        @Override
        public final Builder destinationCapacityReservation(CapacityReservation destinationCapacityReservation) {
            this.destinationCapacityReservation = destinationCapacityReservation;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @Override
        public CreateCapacityReservationBySplittingResponse build() {
            return new CreateCapacityReservationBySplittingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCapacityReservationBySplittingResponse> {
        public Builder sourceCapacityReservation(CapacityReservation var1);

        default public Builder sourceCapacityReservation(Consumer<CapacityReservation.Builder> sourceCapacityReservation) {
            return this.sourceCapacityReservation((CapacityReservation)((CapacityReservation.Builder)CapacityReservation.builder().applyMutation(sourceCapacityReservation)).build());
        }

        public Builder destinationCapacityReservation(CapacityReservation var1);

        default public Builder destinationCapacityReservation(Consumer<CapacityReservation.Builder> destinationCapacityReservation) {
            return this.destinationCapacityReservation((CapacityReservation)((CapacityReservation.Builder)CapacityReservation.builder().applyMutation(destinationCapacityReservation)).build());
        }

        public Builder instanceCount(Integer var1);
    }
}

