/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceMetadataOptionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifyInstanceMetadataOptionsResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ModifyInstanceMetadataOptionsResponse.getter(ModifyInstanceMetadataOptionsResponse::instanceId)).setter(ModifyInstanceMetadataOptionsResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<InstanceMetadataOptionsResponse> INSTANCE_METADATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMetadataOptions").getter(ModifyInstanceMetadataOptionsResponse.getter(ModifyInstanceMetadataOptionsResponse::instanceMetadataOptions)).setter(ModifyInstanceMetadataOptionsResponse.setter(Builder::instanceMetadataOptions)).constructor(InstanceMetadataOptionsResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataOptions").unmarshallLocationName("instanceMetadataOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, INSTANCE_METADATA_OPTIONS_FIELD));
    private final String instanceId;
    private final InstanceMetadataOptionsResponse instanceMetadataOptions;

    private ModifyInstanceMetadataOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.instanceMetadataOptions = builder.instanceMetadataOptions;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final InstanceMetadataOptionsResponse instanceMetadataOptions() {
        return this.instanceMetadataOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMetadataOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceMetadataOptionsResponse)) {
            return false;
        }
        ModifyInstanceMetadataOptionsResponse other = (ModifyInstanceMetadataOptionsResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceMetadataOptions(), other.instanceMetadataOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceMetadataOptionsResponse").add("InstanceId", (Object)this.instanceId()).add("InstanceMetadataOptions", (Object)this.instanceMetadataOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceMetadataOptions": {
                return Optional.ofNullable(clazz.cast(this.instanceMetadataOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceMetadataOptionsResponse, T> g) {
        return obj -> g.apply((ModifyInstanceMetadataOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String instanceId;
        private InstanceMetadataOptionsResponse instanceMetadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceMetadataOptionsResponse model) {
            super(model);
            this.instanceId(model.instanceId);
            this.instanceMetadataOptions(model.instanceMetadataOptions);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final InstanceMetadataOptionsResponse.Builder getInstanceMetadataOptions() {
            return this.instanceMetadataOptions != null ? this.instanceMetadataOptions.toBuilder() : null;
        }

        public final void setInstanceMetadataOptions(InstanceMetadataOptionsResponse.BuilderImpl instanceMetadataOptions) {
            this.instanceMetadataOptions = instanceMetadataOptions != null ? instanceMetadataOptions.build() : null;
        }

        @Override
        public final Builder instanceMetadataOptions(InstanceMetadataOptionsResponse instanceMetadataOptions) {
            this.instanceMetadataOptions = instanceMetadataOptions;
            return this;
        }

        @Override
        public ModifyInstanceMetadataOptionsResponse build() {
            return new ModifyInstanceMetadataOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceMetadataOptionsResponse> {
        public Builder instanceId(String var1);

        public Builder instanceMetadataOptions(InstanceMetadataOptionsResponse var1);

        default public Builder instanceMetadataOptions(Consumer<InstanceMetadataOptionsResponse.Builder> instanceMetadataOptions) {
            return this.instanceMetadataOptions((InstanceMetadataOptionsResponse)((InstanceMetadataOptionsResponse.Builder)InstanceMetadataOptionsResponse.builder().applyMutation(instanceMetadataOptions)).build());
        }
    }
}

