/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkInterfaceAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeNetworkInterfaceAttributeRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeNetworkInterfaceAttributeRequest.getter(DescribeNetworkInterfaceAttributeRequest::dryRun)).setter(DescribeNetworkInterfaceAttributeRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(DescribeNetworkInterfaceAttributeRequest.getter(DescribeNetworkInterfaceAttributeRequest::networkInterfaceId)).setter(DescribeNetworkInterfaceAttributeRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(DescribeNetworkInterfaceAttributeRequest.getter(DescribeNetworkInterfaceAttributeRequest::attributeAsString)).setter(DescribeNetworkInterfaceAttributeRequest.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").unmarshallLocationName("attribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, NETWORK_INTERFACE_ID_FIELD, ATTRIBUTE_FIELD));
    private final Boolean dryRun;
    private final String networkInterfaceId;
    private final String attribute;

    private DescribeNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.attribute = builder.attribute;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final NetworkInterfaceAttribute attribute() {
        return NetworkInterfaceAttribute.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfaceAttributeRequest)) {
            return false;
        }
        DescribeNetworkInterfaceAttributeRequest other = (DescribeNetworkInterfaceAttributeRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.attributeAsString(), other.attributeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNetworkInterfaceAttributeRequest").add("DryRun", (Object)this.dryRun()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("Attribute", (Object)this.attributeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInterfaceAttributeRequest, T> g) {
        return obj -> g.apply((DescribeNetworkInterfaceAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String networkInterfaceId;
        private String attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfaceAttributeRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.networkInterfaceId(model.networkInterfaceId);
            this.attribute(model.attribute);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(NetworkInterfaceAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInterfaceAttributeRequest build() {
            return new DescribeNetworkInterfaceAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkInterfaceAttributeRequest> {
        public Builder dryRun(Boolean var1);

        public Builder networkInterfaceId(String var1);

        public Builder attribute(String var1);

        public Builder attribute(NetworkInterfaceAttribute var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

