/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AttributeValue;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageAttributeResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeImageAttributeResponse> {
    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Description").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::description)).setter(DescribeImageAttributeResponse.setter(Builder::description)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<AttributeValue> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KernelId").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::kernelId)).setter(DescribeImageAttributeResponse.setter(Builder::kernelId)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Kernel").unmarshallLocationName("kernel").build()}).build();
    private static final SdkField<AttributeValue> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RamdiskId").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::ramdiskId)).setter(DescribeImageAttributeResponse.setter(Builder::ramdiskId)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ramdisk").unmarshallLocationName("ramdisk").build()}).build();
    private static final SdkField<AttributeValue> SRIOV_NET_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SriovNetSupport").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::sriovNetSupport)).setter(DescribeImageAttributeResponse.setter(Builder::sriovNetSupport)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport").unmarshallLocationName("sriovNetSupport").build()}).build();
    private static final SdkField<AttributeValue> BOOT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BootMode").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::bootMode)).setter(DescribeImageAttributeResponse.setter(Builder::bootMode)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode").unmarshallLocationName("bootMode").build()}).build();
    private static final SdkField<AttributeValue> TPM_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TpmSupport").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::tpmSupport)).setter(DescribeImageAttributeResponse.setter(Builder::tpmSupport)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TpmSupport").unmarshallLocationName("tpmSupport").build()}).build();
    private static final SdkField<AttributeValue> UEFI_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UefiData").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::uefiData)).setter(DescribeImageAttributeResponse.setter(Builder::uefiData)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UefiData").unmarshallLocationName("uefiData").build()}).build();
    private static final SdkField<AttributeValue> LAST_LAUNCHED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastLaunchedTime").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::lastLaunchedTime)).setter(DescribeImageAttributeResponse.setter(Builder::lastLaunchedTime)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastLaunchedTime").unmarshallLocationName("lastLaunchedTime").build()}).build();
    private static final SdkField<AttributeValue> IMDS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImdsSupport").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::imdsSupport)).setter(DescribeImageAttributeResponse.setter(Builder::imdsSupport)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImdsSupport").unmarshallLocationName("imdsSupport").build()}).build();
    private static final SdkField<AttributeValue> DEREGISTRATION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeregistrationProtection").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::deregistrationProtection)).setter(DescribeImageAttributeResponse.setter(Builder::deregistrationProtection)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeregistrationProtection").unmarshallLocationName("deregistrationProtection").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::imageId)).setter(DescribeImageAttributeResponse.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<List<LaunchPermission>> LAUNCH_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchPermissions").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::launchPermissions)).setter(DescribeImageAttributeResponse.setter(Builder::launchPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPermission").unmarshallLocationName("launchPermission").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCodes").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::productCodes)).setter(DescribeImageAttributeResponse.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes").unmarshallLocationName("productCodes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::blockDeviceMappings)).setter(DescribeImageAttributeResponse.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("blockDeviceMapping").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, KERNEL_ID_FIELD, RAMDISK_ID_FIELD, SRIOV_NET_SUPPORT_FIELD, BOOT_MODE_FIELD, TPM_SUPPORT_FIELD, UEFI_DATA_FIELD, LAST_LAUNCHED_TIME_FIELD, IMDS_SUPPORT_FIELD, DEREGISTRATION_PROTECTION_FIELD, IMAGE_ID_FIELD, LAUNCH_PERMISSIONS_FIELD, PRODUCT_CODES_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD));
    private final AttributeValue description;
    private final AttributeValue kernelId;
    private final AttributeValue ramdiskId;
    private final AttributeValue sriovNetSupport;
    private final AttributeValue bootMode;
    private final AttributeValue tpmSupport;
    private final AttributeValue uefiData;
    private final AttributeValue lastLaunchedTime;
    private final AttributeValue imdsSupport;
    private final AttributeValue deregistrationProtection;
    private final String imageId;
    private final List<LaunchPermission> launchPermissions;
    private final List<ProductCode> productCodes;
    private final List<BlockDeviceMapping> blockDeviceMappings;

    private DescribeImageAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.bootMode = builder.bootMode;
        this.tpmSupport = builder.tpmSupport;
        this.uefiData = builder.uefiData;
        this.lastLaunchedTime = builder.lastLaunchedTime;
        this.imdsSupport = builder.imdsSupport;
        this.deregistrationProtection = builder.deregistrationProtection;
        this.imageId = builder.imageId;
        this.launchPermissions = builder.launchPermissions;
        this.productCodes = builder.productCodes;
        this.blockDeviceMappings = builder.blockDeviceMappings;
    }

    public final AttributeValue description() {
        return this.description;
    }

    public final AttributeValue kernelId() {
        return this.kernelId;
    }

    public final AttributeValue ramdiskId() {
        return this.ramdiskId;
    }

    public final AttributeValue sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public final AttributeValue bootMode() {
        return this.bootMode;
    }

    public final AttributeValue tpmSupport() {
        return this.tpmSupport;
    }

    public final AttributeValue uefiData() {
        return this.uefiData;
    }

    public final AttributeValue lastLaunchedTime() {
        return this.lastLaunchedTime;
    }

    public final AttributeValue imdsSupport() {
        return this.imdsSupport;
    }

    public final AttributeValue deregistrationProtection() {
        return this.deregistrationProtection;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final boolean hasLaunchPermissions() {
        return this.launchPermissions != null && !(this.launchPermissions instanceof SdkAutoConstructList);
    }

    public final List<LaunchPermission> launchPermissions() {
        return this.launchPermissions;
    }

    public final boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public final List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.bootMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.tpmSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.uefiData());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastLaunchedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.imdsSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.deregistrationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchPermissions() ? this.launchPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductCodes() ? this.productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageAttributeResponse)) {
            return false;
        }
        DescribeImageAttributeResponse other = (DescribeImageAttributeResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(this.bootMode(), other.bootMode()) && Objects.equals(this.tpmSupport(), other.tpmSupport()) && Objects.equals(this.uefiData(), other.uefiData()) && Objects.equals(this.lastLaunchedTime(), other.lastLaunchedTime()) && Objects.equals(this.imdsSupport(), other.imdsSupport()) && Objects.equals(this.deregistrationProtection(), other.deregistrationProtection()) && Objects.equals(this.imageId(), other.imageId()) && this.hasLaunchPermissions() == other.hasLaunchPermissions() && Objects.equals(this.launchPermissions(), other.launchPermissions()) && this.hasProductCodes() == other.hasProductCodes() && Objects.equals(this.productCodes(), other.productCodes()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageAttributeResponse").add("Description", (Object)this.description()).add("KernelId", (Object)this.kernelId()).add("RamdiskId", (Object)this.ramdiskId()).add("SriovNetSupport", (Object)this.sriovNetSupport()).add("BootMode", (Object)this.bootMode()).add("TpmSupport", (Object)this.tpmSupport()).add("UefiData", (Object)this.uefiData()).add("LastLaunchedTime", (Object)this.lastLaunchedTime()).add("ImdsSupport", (Object)this.imdsSupport()).add("DeregistrationProtection", (Object)this.deregistrationProtection()).add("ImageId", (Object)this.imageId()).add("LaunchPermissions", this.hasLaunchPermissions() ? this.launchPermissions() : null).add("ProductCodes", this.hasProductCodes() ? this.productCodes() : null).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "SriovNetSupport": {
                return Optional.ofNullable(clazz.cast(this.sriovNetSupport()));
            }
            case "BootMode": {
                return Optional.ofNullable(clazz.cast(this.bootMode()));
            }
            case "TpmSupport": {
                return Optional.ofNullable(clazz.cast(this.tpmSupport()));
            }
            case "UefiData": {
                return Optional.ofNullable(clazz.cast(this.uefiData()));
            }
            case "LastLaunchedTime": {
                return Optional.ofNullable(clazz.cast(this.lastLaunchedTime()));
            }
            case "ImdsSupport": {
                return Optional.ofNullable(clazz.cast(this.imdsSupport()));
            }
            case "DeregistrationProtection": {
                return Optional.ofNullable(clazz.cast(this.deregistrationProtection()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "LaunchPermissions": {
                return Optional.ofNullable(clazz.cast(this.launchPermissions()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageAttributeResponse, T> g) {
        return obj -> g.apply((DescribeImageAttributeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private AttributeValue description;
        private AttributeValue kernelId;
        private AttributeValue ramdiskId;
        private AttributeValue sriovNetSupport;
        private AttributeValue bootMode;
        private AttributeValue tpmSupport;
        private AttributeValue uefiData;
        private AttributeValue lastLaunchedTime;
        private AttributeValue imdsSupport;
        private AttributeValue deregistrationProtection;
        private String imageId;
        private List<LaunchPermission> launchPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageAttributeResponse model) {
            super(model);
            this.description(model.description);
            this.kernelId(model.kernelId);
            this.ramdiskId(model.ramdiskId);
            this.sriovNetSupport(model.sriovNetSupport);
            this.bootMode(model.bootMode);
            this.tpmSupport(model.tpmSupport);
            this.uefiData(model.uefiData);
            this.lastLaunchedTime(model.lastLaunchedTime);
            this.imdsSupport(model.imdsSupport);
            this.deregistrationProtection(model.deregistrationProtection);
            this.imageId(model.imageId);
            this.launchPermissions(model.launchPermissions);
            this.productCodes(model.productCodes);
            this.blockDeviceMappings(model.blockDeviceMappings);
        }

        public final AttributeValue.Builder getDescription() {
            return this.description != null ? this.description.toBuilder() : null;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final AttributeValue.Builder getKernelId() {
            return this.kernelId != null ? this.kernelId.toBuilder() : null;
        }

        public final void setKernelId(AttributeValue.BuilderImpl kernelId) {
            this.kernelId = kernelId != null ? kernelId.build() : null;
        }

        @Override
        public final Builder kernelId(AttributeValue kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final AttributeValue.Builder getRamdiskId() {
            return this.ramdiskId != null ? this.ramdiskId.toBuilder() : null;
        }

        public final void setRamdiskId(AttributeValue.BuilderImpl ramdiskId) {
            this.ramdiskId = ramdiskId != null ? ramdiskId.build() : null;
        }

        @Override
        public final Builder ramdiskId(AttributeValue ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final AttributeValue.Builder getSriovNetSupport() {
            return this.sriovNetSupport != null ? this.sriovNetSupport.toBuilder() : null;
        }

        public final void setSriovNetSupport(AttributeValue.BuilderImpl sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport != null ? sriovNetSupport.build() : null;
        }

        @Override
        public final Builder sriovNetSupport(AttributeValue sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final AttributeValue.Builder getBootMode() {
            return this.bootMode != null ? this.bootMode.toBuilder() : null;
        }

        public final void setBootMode(AttributeValue.BuilderImpl bootMode) {
            this.bootMode = bootMode != null ? bootMode.build() : null;
        }

        @Override
        public final Builder bootMode(AttributeValue bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        public final AttributeValue.Builder getTpmSupport() {
            return this.tpmSupport != null ? this.tpmSupport.toBuilder() : null;
        }

        public final void setTpmSupport(AttributeValue.BuilderImpl tpmSupport) {
            this.tpmSupport = tpmSupport != null ? tpmSupport.build() : null;
        }

        @Override
        public final Builder tpmSupport(AttributeValue tpmSupport) {
            this.tpmSupport = tpmSupport;
            return this;
        }

        public final AttributeValue.Builder getUefiData() {
            return this.uefiData != null ? this.uefiData.toBuilder() : null;
        }

        public final void setUefiData(AttributeValue.BuilderImpl uefiData) {
            this.uefiData = uefiData != null ? uefiData.build() : null;
        }

        @Override
        public final Builder uefiData(AttributeValue uefiData) {
            this.uefiData = uefiData;
            return this;
        }

        public final AttributeValue.Builder getLastLaunchedTime() {
            return this.lastLaunchedTime != null ? this.lastLaunchedTime.toBuilder() : null;
        }

        public final void setLastLaunchedTime(AttributeValue.BuilderImpl lastLaunchedTime) {
            this.lastLaunchedTime = lastLaunchedTime != null ? lastLaunchedTime.build() : null;
        }

        @Override
        public final Builder lastLaunchedTime(AttributeValue lastLaunchedTime) {
            this.lastLaunchedTime = lastLaunchedTime;
            return this;
        }

        public final AttributeValue.Builder getImdsSupport() {
            return this.imdsSupport != null ? this.imdsSupport.toBuilder() : null;
        }

        public final void setImdsSupport(AttributeValue.BuilderImpl imdsSupport) {
            this.imdsSupport = imdsSupport != null ? imdsSupport.build() : null;
        }

        @Override
        public final Builder imdsSupport(AttributeValue imdsSupport) {
            this.imdsSupport = imdsSupport;
            return this;
        }

        public final AttributeValue.Builder getDeregistrationProtection() {
            return this.deregistrationProtection != null ? this.deregistrationProtection.toBuilder() : null;
        }

        public final void setDeregistrationProtection(AttributeValue.BuilderImpl deregistrationProtection) {
            this.deregistrationProtection = deregistrationProtection != null ? deregistrationProtection.build() : null;
        }

        @Override
        public final Builder deregistrationProtection(AttributeValue deregistrationProtection) {
            this.deregistrationProtection = deregistrationProtection;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final List<LaunchPermission.Builder> getLaunchPermissions() {
            List<LaunchPermission.Builder> result = LaunchPermissionListCopier.copyToBuilder(this.launchPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchPermissions(Collection<LaunchPermission.BuilderImpl> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copyFromBuilder(launchPermissions);
        }

        @Override
        public final Builder launchPermissions(Collection<LaunchPermission> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copy(launchPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(LaunchPermission ... launchPermissions) {
            this.launchPermissions(Arrays.asList(launchPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(Consumer<LaunchPermission.Builder> ... launchPermissions) {
            this.launchPermissions(Stream.of(launchPermissions).map(c -> (LaunchPermission)((LaunchPermission.Builder)LaunchPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodeListCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeImageAttributeResponse build() {
            return new DescribeImageAttributeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageAttributeResponse> {
        public Builder description(AttributeValue var1);

        default public Builder description(Consumer<AttributeValue.Builder> description) {
            return this.description((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(description)).build());
        }

        public Builder kernelId(AttributeValue var1);

        default public Builder kernelId(Consumer<AttributeValue.Builder> kernelId) {
            return this.kernelId((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(kernelId)).build());
        }

        public Builder ramdiskId(AttributeValue var1);

        default public Builder ramdiskId(Consumer<AttributeValue.Builder> ramdiskId) {
            return this.ramdiskId((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(ramdiskId)).build());
        }

        public Builder sriovNetSupport(AttributeValue var1);

        default public Builder sriovNetSupport(Consumer<AttributeValue.Builder> sriovNetSupport) {
            return this.sriovNetSupport((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(sriovNetSupport)).build());
        }

        public Builder bootMode(AttributeValue var1);

        default public Builder bootMode(Consumer<AttributeValue.Builder> bootMode) {
            return this.bootMode((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(bootMode)).build());
        }

        public Builder tpmSupport(AttributeValue var1);

        default public Builder tpmSupport(Consumer<AttributeValue.Builder> tpmSupport) {
            return this.tpmSupport((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(tpmSupport)).build());
        }

        public Builder uefiData(AttributeValue var1);

        default public Builder uefiData(Consumer<AttributeValue.Builder> uefiData) {
            return this.uefiData((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(uefiData)).build());
        }

        public Builder lastLaunchedTime(AttributeValue var1);

        default public Builder lastLaunchedTime(Consumer<AttributeValue.Builder> lastLaunchedTime) {
            return this.lastLaunchedTime((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(lastLaunchedTime)).build());
        }

        public Builder imdsSupport(AttributeValue var1);

        default public Builder imdsSupport(Consumer<AttributeValue.Builder> imdsSupport) {
            return this.imdsSupport((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(imdsSupport)).build());
        }

        public Builder deregistrationProtection(AttributeValue var1);

        default public Builder deregistrationProtection(Consumer<AttributeValue.Builder> deregistrationProtection) {
            return this.deregistrationProtection((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(deregistrationProtection)).build());
        }

        public Builder imageId(String var1);

        public Builder launchPermissions(Collection<LaunchPermission> var1);

        public Builder launchPermissions(LaunchPermission ... var1);

        public Builder launchPermissions(Consumer<LaunchPermission.Builder> ... var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);
    }
}

