/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpRange> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(IpRange.getter(IpRange::description)).setter(IpRange.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> CIDR_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrIp").getter(IpRange.getter(IpRange::cidrIp)).setter(IpRange.setter(Builder::cidrIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp").unmarshallLocationName("cidrIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, CIDR_IP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String cidrIp;

    private IpRange(BuilderImpl builder) {
        this.description = builder.description;
        this.cidrIp = builder.cidrIp;
    }

    public final String description() {
        return this.description;
    }

    public final String cidrIp() {
        return this.cidrIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpRange)) {
            return false;
        }
        IpRange other = (IpRange)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.cidrIp(), other.cidrIp());
    }

    public final String toString() {
        return ToString.builder((String)"IpRange").add("Description", (Object)this.description()).add("CidrIp", (Object)this.cidrIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CidrIp": {
                return Optional.ofNullable(clazz.cast(this.cidrIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpRange, T> g) {
        return obj -> g.apply((IpRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String cidrIp;

        private BuilderImpl() {
        }

        private BuilderImpl(IpRange model) {
            this.description(model.description);
            this.cidrIp(model.cidrIp);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCidrIp() {
            return this.cidrIp;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public IpRange build() {
            return new IpRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpRange> {
        public Builder description(String var1);

        public Builder cidrIp(String var1);
    }
}

