/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.PricingDetail;
import software.amazon.awssdk.services.ec2.model.PricingDetailsListCopier;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.RecurringCharge;
import software.amazon.awssdk.services.ec2.model.RecurringChargesListCopier;
import software.amazon.awssdk.services.ec2.model.Scope;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedInstancesOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedInstancesOffering> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::currencyCodeAsString)).setter(ReservedInstancesOffering.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceTenancy").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::instanceTenancyAsString)).setter(ReservedInstancesOffering.setter(Builder::instanceTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy").unmarshallLocationName("instanceTenancy").build()}).build();
    private static final SdkField<Boolean> MARKETPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Marketplace").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::marketplace)).setter(ReservedInstancesOffering.setter(Builder::marketplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketplace").unmarshallLocationName("marketplace").build()}).build();
    private static final SdkField<String> OFFERING_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingClass").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::offeringClassAsString)).setter(ReservedInstancesOffering.setter(Builder::offeringClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingClass").unmarshallLocationName("offeringClass").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::offeringTypeAsString)).setter(ReservedInstancesOffering.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").unmarshallLocationName("offeringType").build()}).build();
    private static final SdkField<List<PricingDetail>> PRICING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PricingDetails").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::pricingDetails)).setter(ReservedInstancesOffering.setter(Builder::pricingDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingDetailsSet").unmarshallLocationName("pricingDetailsSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PricingDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecurringCharges").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::recurringCharges)).setter(ReservedInstancesOffering.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").unmarshallLocationName("recurringCharges").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::scopeAsString)).setter(ReservedInstancesOffering.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").unmarshallLocationName("scope").build()}).build();
    private static final SdkField<String> RESERVED_INSTANCES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstancesOfferingId").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::reservedInstancesOfferingId)).setter(ReservedInstancesOffering.setter(Builder::reservedInstancesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesOfferingId").unmarshallLocationName("reservedInstancesOfferingId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::instanceTypeAsString)).setter(ReservedInstancesOffering.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::availabilityZone)).setter(ReservedInstancesOffering.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::duration)).setter(ReservedInstancesOffering.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").unmarshallLocationName("duration").build()}).build();
    private static final SdkField<Float> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("UsagePrice").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::usagePrice)).setter(ReservedInstancesOffering.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").unmarshallLocationName("usagePrice").build()}).build();
    private static final SdkField<Float> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("FixedPrice").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::fixedPrice)).setter(ReservedInstancesOffering.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").unmarshallLocationName("fixedPrice").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductDescription").getter(ReservedInstancesOffering.getter(ReservedInstancesOffering::productDescriptionAsString)).setter(ReservedInstancesOffering.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").unmarshallLocationName("productDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, INSTANCE_TENANCY_FIELD, MARKETPLACE_FIELD, OFFERING_CLASS_FIELD, OFFERING_TYPE_FIELD, PRICING_DETAILS_FIELD, RECURRING_CHARGES_FIELD, SCOPE_FIELD, RESERVED_INSTANCES_OFFERING_ID_FIELD, INSTANCE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, DURATION_FIELD, USAGE_PRICE_FIELD, FIXED_PRICE_FIELD, PRODUCT_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currencyCode;
    private final String instanceTenancy;
    private final Boolean marketplace;
    private final String offeringClass;
    private final String offeringType;
    private final List<PricingDetail> pricingDetails;
    private final List<RecurringCharge> recurringCharges;
    private final String scope;
    private final String reservedInstancesOfferingId;
    private final String instanceType;
    private final String availabilityZone;
    private final Long duration;
    private final Float usagePrice;
    private final Float fixedPrice;
    private final String productDescription;

    private ReservedInstancesOffering(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.marketplace = builder.marketplace;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.pricingDetails = builder.pricingDetails;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.usagePrice = builder.usagePrice;
        this.fixedPrice = builder.fixedPrice;
        this.productDescription = builder.productDescription;
    }

    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public final Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public final String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    public final Boolean marketplace() {
        return this.marketplace;
    }

    public final OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(this.offeringClass);
    }

    public final String offeringClassAsString() {
        return this.offeringClass;
    }

    public final OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(this.offeringType);
    }

    public final String offeringTypeAsString() {
        return this.offeringType;
    }

    public final boolean hasPricingDetails() {
        return this.pricingDetails != null && !(this.pricingDetails instanceof SdkAutoConstructList);
    }

    public final List<PricingDetail> pricingDetails() {
        return this.pricingDetails;
    }

    public final boolean hasRecurringCharges() {
        return this.recurringCharges != null && !(this.recurringCharges instanceof SdkAutoConstructList);
    }

    public final List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String reservedInstancesOfferingId() {
        return this.reservedInstancesOfferingId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Long duration() {
        return this.duration;
    }

    public final Float usagePrice() {
        return this.usagePrice;
    }

    public final Float fixedPrice() {
        return this.fixedPrice;
    }

    public final RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public final String productDescriptionAsString() {
        return this.productDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPricingDetails() ? this.pricingDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecurringCharges() ? this.recurringCharges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescriptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesOffering)) {
            return false;
        }
        ReservedInstancesOffering other = (ReservedInstancesOffering)obj;
        return Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString()) && Objects.equals(this.marketplace(), other.marketplace()) && Objects.equals(this.offeringClassAsString(), other.offeringClassAsString()) && Objects.equals(this.offeringTypeAsString(), other.offeringTypeAsString()) && this.hasPricingDetails() == other.hasPricingDetails() && Objects.equals(this.pricingDetails(), other.pricingDetails()) && this.hasRecurringCharges() == other.hasRecurringCharges() && Objects.equals(this.recurringCharges(), other.recurringCharges()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.reservedInstancesOfferingId(), other.reservedInstancesOfferingId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.productDescriptionAsString(), other.productDescriptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedInstancesOffering").add("CurrencyCode", (Object)this.currencyCodeAsString()).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).add("Marketplace", (Object)this.marketplace()).add("OfferingClass", (Object)this.offeringClassAsString()).add("OfferingType", (Object)this.offeringTypeAsString()).add("PricingDetails", this.hasPricingDetails() ? this.pricingDetails() : null).add("RecurringCharges", this.hasRecurringCharges() ? this.recurringCharges() : null).add("Scope", (Object)this.scopeAsString()).add("ReservedInstancesOfferingId", (Object)this.reservedInstancesOfferingId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Duration", (Object)this.duration()).add("UsagePrice", (Object)this.usagePrice()).add("FixedPrice", (Object)this.fixedPrice()).add("ProductDescription", (Object)this.productDescriptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
            case "InstanceTenancy": {
                return Optional.ofNullable(clazz.cast(this.instanceTenancyAsString()));
            }
            case "Marketplace": {
                return Optional.ofNullable(clazz.cast(this.marketplace()));
            }
            case "OfferingClass": {
                return Optional.ofNullable(clazz.cast(this.offeringClassAsString()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringTypeAsString()));
            }
            case "PricingDetails": {
                return Optional.ofNullable(clazz.cast(this.pricingDetails()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "ReservedInstancesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesOfferingId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescriptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesOffering, T> g) {
        return obj -> g.apply((ReservedInstancesOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private String instanceTenancy;
        private Boolean marketplace;
        private String offeringClass;
        private String offeringType;
        private List<PricingDetail> pricingDetails = DefaultSdkAutoConstructList.getInstance();
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();
        private String scope;
        private String reservedInstancesOfferingId;
        private String instanceType;
        private String availabilityZone;
        private Long duration;
        private Float usagePrice;
        private Float fixedPrice;
        private String productDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesOffering model) {
            this.currencyCode(model.currencyCode);
            this.instanceTenancy(model.instanceTenancy);
            this.marketplace(model.marketplace);
            this.offeringClass(model.offeringClass);
            this.offeringType(model.offeringType);
            this.pricingDetails(model.pricingDetails);
            this.recurringCharges(model.recurringCharges);
            this.scope(model.scope);
            this.reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            this.instanceType(model.instanceType);
            this.availabilityZone(model.availabilityZone);
            this.duration(model.duration);
            this.usagePrice(model.usagePrice);
            this.fixedPrice(model.fixedPrice);
            this.productDescription(model.productDescription);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final Boolean getMarketplace() {
            return this.marketplace;
        }

        public final void setMarketplace(Boolean marketplace) {
            this.marketplace = marketplace;
        }

        @Override
        public final Builder marketplace(Boolean marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass == null ? null : offeringClass.toString());
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final List<PricingDetail.Builder> getPricingDetails() {
            List<PricingDetail.Builder> result = PricingDetailsListCopier.copyToBuilder(this.pricingDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPricingDetails(Collection<PricingDetail.BuilderImpl> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copyFromBuilder(pricingDetails);
        }

        @Override
        public final Builder pricingDetails(Collection<PricingDetail> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copy(pricingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(PricingDetail ... pricingDetails) {
            this.pricingDetails(Arrays.asList(pricingDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(Consumer<PricingDetail.Builder> ... pricingDetails) {
            this.pricingDetails(Stream.of(pricingDetails).map(c -> (PricingDetail)((PricingDetail.Builder)PricingDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargesListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getReservedInstancesOfferingId() {
            return this.reservedInstancesOfferingId;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final Float getUsagePrice() {
            return this.usagePrice;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final Float getFixedPrice() {
            return this.fixedPrice;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription == null ? null : productDescription.toString());
            return this;
        }

        public ReservedInstancesOffering build() {
            return new ReservedInstancesOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedInstancesOffering> {
        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder marketplace(Boolean var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);

        public Builder pricingDetails(Collection<PricingDetail> var1);

        public Builder pricingDetails(PricingDetail ... var1);

        public Builder pricingDetails(Consumer<PricingDetail.Builder> ... var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder reservedInstancesOfferingId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder availabilityZone(String var1);

        public Builder duration(Long var1);

        public Builder usagePrice(Float var1);

        public Builder fixedPrice(Float var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);
    }
}

