/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocateAddressRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AllocateAddressRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(AllocateAddressRequest.getter(AllocateAddressRequest::domainAsString)).setter(AllocateAddressRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").unmarshallLocationName("Domain").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(AllocateAddressRequest.getter(AllocateAddressRequest::address)).setter(AllocateAddressRequest.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").unmarshallLocationName("Address").build()}).build();
    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIpv4Pool").getter(AllocateAddressRequest.getter(AllocateAddressRequest::publicIpv4Pool)).setter(AllocateAddressRequest.setter(Builder::publicIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool").unmarshallLocationName("PublicIpv4Pool").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(AllocateAddressRequest.getter(AllocateAddressRequest::networkBorderGroup)).setter(AllocateAddressRequest.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("NetworkBorderGroup").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIpv4Pool").getter(AllocateAddressRequest.getter(AllocateAddressRequest::customerOwnedIpv4Pool)).setter(AllocateAddressRequest.setter(Builder::customerOwnedIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").unmarshallLocationName("CustomerOwnedIpv4Pool").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(AllocateAddressRequest.getter(AllocateAddressRequest::tagSpecifications)).setter(AllocateAddressRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolId").getter(AllocateAddressRequest.getter(AllocateAddressRequest::ipamPoolId)).setter(AllocateAddressRequest.setter(Builder::ipamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId").unmarshallLocationName("IpamPoolId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(AllocateAddressRequest.getter(AllocateAddressRequest::dryRun)).setter(AllocateAddressRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, ADDRESS_FIELD, PUBLIC_IPV4_POOL_FIELD, NETWORK_BORDER_GROUP_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, TAG_SPECIFICATIONS_FIELD, IPAM_POOL_ID_FIELD, DRY_RUN_FIELD));
    private final String domain;
    private final String address;
    private final String publicIpv4Pool;
    private final String networkBorderGroup;
    private final String customerOwnedIpv4Pool;
    private final List<TagSpecification> tagSpecifications;
    private final String ipamPoolId;
    private final Boolean dryRun;

    private AllocateAddressRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.address = builder.address;
        this.publicIpv4Pool = builder.publicIpv4Pool;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.tagSpecifications = builder.tagSpecifications;
        this.ipamPoolId = builder.ipamPoolId;
        this.dryRun = builder.dryRun;
    }

    public final DomainType domain() {
        return DomainType.fromValue(this.domain);
    }

    public final String domainAsString() {
        return this.domain;
    }

    public final String address() {
        return this.address;
    }

    public final String publicIpv4Pool() {
        return this.publicIpv4Pool;
    }

    public final String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    public final String customerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String ipamPoolId() {
        return this.ipamPoolId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressRequest)) {
            return false;
        }
        AllocateAddressRequest other = (AllocateAddressRequest)((Object)obj);
        return Objects.equals(this.domainAsString(), other.domainAsString()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.publicIpv4Pool(), other.publicIpv4Pool()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup()) && Objects.equals(this.customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.ipamPoolId(), other.ipamPoolId()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"AllocateAddressRequest").add("Domain", (Object)this.domainAsString()).add("Address", (Object)this.address()).add("PublicIpv4Pool", (Object)this.publicIpv4Pool()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).add("CustomerOwnedIpv4Pool", (Object)this.customerOwnedIpv4Pool()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("IpamPoolId", (Object)this.ipamPoolId()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "PublicIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.publicIpv4Pool()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
            case "CustomerOwnedIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIpv4Pool()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateAddressRequest, T> g) {
        return obj -> g.apply((AllocateAddressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String domain;
        private String address;
        private String publicIpv4Pool;
        private String networkBorderGroup;
        private String customerOwnedIpv4Pool;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String ipamPoolId;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressRequest model) {
            super(model);
            this.domain(model.domain);
            this.address(model.address);
            this.publicIpv4Pool(model.publicIpv4Pool);
            this.networkBorderGroup(model.networkBorderGroup);
            this.customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            this.tagSpecifications(model.tagSpecifications);
            this.ipamPoolId(model.ipamPoolId);
            this.dryRun(model.dryRun);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getPublicIpv4Pool() {
            return this.publicIpv4Pool;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        @Override
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIpamPoolId() {
            return this.ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateAddressRequest build() {
            return new AllocateAddressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AllocateAddressRequest> {
        public Builder domain(String var1);

        public Builder domain(DomainType var1);

        public Builder address(String var1);

        public Builder publicIpv4Pool(String var1);

        public Builder networkBorderGroup(String var1);

        public Builder customerOwnedIpv4Pool(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder ipamPoolId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

