/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVerifiedAccessEndpointPolicyRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVerifiedAccessEndpointPolicyRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessEndpointId").getter(ModifyVerifiedAccessEndpointPolicyRequest.getter(ModifyVerifiedAccessEndpointPolicyRequest::verifiedAccessEndpointId)).setter(ModifyVerifiedAccessEndpointPolicyRequest.setter(Builder::verifiedAccessEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointId").unmarshallLocationName("VerifiedAccessEndpointId").build()}).build();
    private static final SdkField<Boolean> POLICY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PolicyEnabled").getter(ModifyVerifiedAccessEndpointPolicyRequest.getter(ModifyVerifiedAccessEndpointPolicyRequest::policyEnabled)).setter(ModifyVerifiedAccessEndpointPolicyRequest.setter(Builder::policyEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyEnabled").unmarshallLocationName("PolicyEnabled").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(ModifyVerifiedAccessEndpointPolicyRequest.getter(ModifyVerifiedAccessEndpointPolicyRequest::policyDocument)).setter(ModifyVerifiedAccessEndpointPolicyRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").unmarshallLocationName("PolicyDocument").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ModifyVerifiedAccessEndpointPolicyRequest.getter(ModifyVerifiedAccessEndpointPolicyRequest::clientToken)).setter(ModifyVerifiedAccessEndpointPolicyRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVerifiedAccessEndpointPolicyRequest.getter(ModifyVerifiedAccessEndpointPolicyRequest::dryRun)).setter(ModifyVerifiedAccessEndpointPolicyRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<VerifiedAccessSseSpecificationRequest> SSE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseSpecification").getter(ModifyVerifiedAccessEndpointPolicyRequest.getter(ModifyVerifiedAccessEndpointPolicyRequest::sseSpecification)).setter(ModifyVerifiedAccessEndpointPolicyRequest.setter(Builder::sseSpecification)).constructor(VerifiedAccessSseSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification").unmarshallLocationName("SseSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_ENDPOINT_ID_FIELD, POLICY_ENABLED_FIELD, POLICY_DOCUMENT_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, SSE_SPECIFICATION_FIELD));
    private final String verifiedAccessEndpointId;
    private final Boolean policyEnabled;
    private final String policyDocument;
    private final String clientToken;
    private final Boolean dryRun;
    private final VerifiedAccessSseSpecificationRequest sseSpecification;

    private ModifyVerifiedAccessEndpointPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessEndpointId = builder.verifiedAccessEndpointId;
        this.policyEnabled = builder.policyEnabled;
        this.policyDocument = builder.policyDocument;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.sseSpecification = builder.sseSpecification;
    }

    public final String verifiedAccessEndpointId() {
        return this.verifiedAccessEndpointId;
    }

    public final Boolean policyEnabled() {
        return this.policyEnabled;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final VerifiedAccessSseSpecificationRequest sseSpecification() {
        return this.sseSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessEndpointPolicyRequest)) {
            return false;
        }
        ModifyVerifiedAccessEndpointPolicyRequest other = (ModifyVerifiedAccessEndpointPolicyRequest)((Object)obj);
        return Objects.equals(this.verifiedAccessEndpointId(), other.verifiedAccessEndpointId()) && Objects.equals(this.policyEnabled(), other.policyEnabled()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.sseSpecification(), other.sseSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVerifiedAccessEndpointPolicyRequest").add("VerifiedAccessEndpointId", (Object)this.verifiedAccessEndpointId()).add("PolicyEnabled", (Object)this.policyEnabled()).add("PolicyDocument", (Object)this.policyDocument()).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("SseSpecification", (Object)this.sseSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessEndpointId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessEndpointId()));
            }
            case "PolicyEnabled": {
                return Optional.ofNullable(clazz.cast(this.policyEnabled()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "SseSpecification": {
                return Optional.ofNullable(clazz.cast(this.sseSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessEndpointPolicyRequest, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessEndpointPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String verifiedAccessEndpointId;
        private Boolean policyEnabled;
        private String policyDocument;
        private String clientToken;
        private Boolean dryRun;
        private VerifiedAccessSseSpecificationRequest sseSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessEndpointPolicyRequest model) {
            super(model);
            this.verifiedAccessEndpointId(model.verifiedAccessEndpointId);
            this.policyEnabled(model.policyEnabled);
            this.policyDocument(model.policyDocument);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.sseSpecification(model.sseSpecification);
        }

        public final String getVerifiedAccessEndpointId() {
            return this.verifiedAccessEndpointId;
        }

        public final void setVerifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
        }

        @Override
        public final Builder verifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
            return this;
        }

        public final Boolean getPolicyEnabled() {
            return this.policyEnabled;
        }

        public final void setPolicyEnabled(Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
        }

        @Override
        public final Builder policyEnabled(Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final VerifiedAccessSseSpecificationRequest.Builder getSseSpecification() {
            return this.sseSpecification != null ? this.sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationRequest.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationRequest sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVerifiedAccessEndpointPolicyRequest build() {
            return new ModifyVerifiedAccessEndpointPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVerifiedAccessEndpointPolicyRequest> {
        public Builder verifiedAccessEndpointId(String var1);

        public Builder policyEnabled(Boolean var1);

        public Builder policyDocument(String var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder sseSpecification(VerifiedAccessSseSpecificationRequest var1);

        default public Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationRequest.Builder> sseSpecification) {
            return this.sseSpecification((VerifiedAccessSseSpecificationRequest)((VerifiedAccessSseSpecificationRequest.Builder)VerifiedAccessSseSpecificationRequest.builder().applyMutation(sseSpecification)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

