/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding;
import software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFindingListCopier;
import software.amazon.awssdk.services.ec2.model.AnalysisStatus;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNetworkInsightsAccessScopeAnalysisFindingsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetNetworkInsightsAccessScopeAnalysisFindingsResponse> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAccessScopeAnalysisId").getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse.getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse::networkInsightsAccessScopeAnalysisId)).setter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse.setter(Builder::networkInsightsAccessScopeAnalysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeAnalysisId").unmarshallLocationName("networkInsightsAccessScopeAnalysisId").build()}).build();
    private static final SdkField<String> ANALYSIS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisStatus").getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse.getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse::analysisStatusAsString)).setter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse.setter(Builder::analysisStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStatus").unmarshallLocationName("analysisStatus").build()}).build();
    private static final SdkField<List<AccessScopeAnalysisFinding>> ANALYSIS_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisFindings").getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse.getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse::analysisFindings)).setter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse.setter(Builder::analysisFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisFindingSet").unmarshallLocationName("analysisFindingSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessScopeAnalysisFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse.getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse::nextToken)).setter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD, ANALYSIS_STATUS_FIELD, ANALYSIS_FINDINGS_FIELD, NEXT_TOKEN_FIELD));
    private final String networkInsightsAccessScopeAnalysisId;
    private final String analysisStatus;
    private final List<AccessScopeAnalysisFinding> analysisFindings;
    private final String nextToken;

    private GetNetworkInsightsAccessScopeAnalysisFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAccessScopeAnalysisId = builder.networkInsightsAccessScopeAnalysisId;
        this.analysisStatus = builder.analysisStatus;
        this.analysisFindings = builder.analysisFindings;
        this.nextToken = builder.nextToken;
    }

    public final String networkInsightsAccessScopeAnalysisId() {
        return this.networkInsightsAccessScopeAnalysisId;
    }

    public final AnalysisStatus analysisStatus() {
        return AnalysisStatus.fromValue(this.analysisStatus);
    }

    public final String analysisStatusAsString() {
        return this.analysisStatus;
    }

    public final boolean hasAnalysisFindings() {
        return this.analysisFindings != null && !(this.analysisFindings instanceof SdkAutoConstructList);
    }

    public final List<AccessScopeAnalysisFinding> analysisFindings() {
        return this.analysisFindings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAccessScopeAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisFindings() ? this.analysisFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkInsightsAccessScopeAnalysisFindingsResponse)) {
            return false;
        }
        GetNetworkInsightsAccessScopeAnalysisFindingsResponse other = (GetNetworkInsightsAccessScopeAnalysisFindingsResponse)((Object)obj);
        return Objects.equals(this.networkInsightsAccessScopeAnalysisId(), other.networkInsightsAccessScopeAnalysisId()) && Objects.equals(this.analysisStatusAsString(), other.analysisStatusAsString()) && this.hasAnalysisFindings() == other.hasAnalysisFindings() && Objects.equals(this.analysisFindings(), other.analysisFindings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetNetworkInsightsAccessScopeAnalysisFindingsResponse").add("NetworkInsightsAccessScopeAnalysisId", (Object)this.networkInsightsAccessScopeAnalysisId()).add("AnalysisStatus", (Object)this.analysisStatusAsString()).add("AnalysisFindings", this.hasAnalysisFindings() ? this.analysisFindings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsAccessScopeAnalysisId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeAnalysisId()));
            }
            case "AnalysisStatus": {
                return Optional.ofNullable(clazz.cast(this.analysisStatusAsString()));
            }
            case "AnalysisFindings": {
                return Optional.ofNullable(clazz.cast(this.analysisFindings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkInsightsAccessScopeAnalysisFindingsResponse, T> g) {
        return obj -> g.apply((GetNetworkInsightsAccessScopeAnalysisFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String networkInsightsAccessScopeAnalysisId;
        private String analysisStatus;
        private List<AccessScopeAnalysisFinding> analysisFindings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkInsightsAccessScopeAnalysisFindingsResponse model) {
            super(model);
            this.networkInsightsAccessScopeAnalysisId(model.networkInsightsAccessScopeAnalysisId);
            this.analysisStatus(model.analysisStatus);
            this.analysisFindings(model.analysisFindings);
            this.nextToken(model.nextToken);
        }

        public final String getNetworkInsightsAccessScopeAnalysisId() {
            return this.networkInsightsAccessScopeAnalysisId;
        }

        public final void setNetworkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
        }

        @Override
        public final Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
            return this;
        }

        public final String getAnalysisStatus() {
            return this.analysisStatus;
        }

        public final void setAnalysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
        }

        @Override
        public final Builder analysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
            return this;
        }

        @Override
        public final Builder analysisStatus(AnalysisStatus analysisStatus) {
            this.analysisStatus(analysisStatus == null ? null : analysisStatus.toString());
            return this;
        }

        public final List<AccessScopeAnalysisFinding.Builder> getAnalysisFindings() {
            List<AccessScopeAnalysisFinding.Builder> result = AccessScopeAnalysisFindingListCopier.copyToBuilder(this.analysisFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisFindings(Collection<AccessScopeAnalysisFinding.BuilderImpl> analysisFindings) {
            this.analysisFindings = AccessScopeAnalysisFindingListCopier.copyFromBuilder(analysisFindings);
        }

        @Override
        public final Builder analysisFindings(Collection<AccessScopeAnalysisFinding> analysisFindings) {
            this.analysisFindings = AccessScopeAnalysisFindingListCopier.copy(analysisFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisFindings(AccessScopeAnalysisFinding ... analysisFindings) {
            this.analysisFindings(Arrays.asList(analysisFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisFindings(Consumer<AccessScopeAnalysisFinding.Builder> ... analysisFindings) {
            this.analysisFindings(Stream.of(analysisFindings).map(c -> (AccessScopeAnalysisFinding)((AccessScopeAnalysisFinding.Builder)AccessScopeAnalysisFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetNetworkInsightsAccessScopeAnalysisFindingsResponse build() {
            return new GetNetworkInsightsAccessScopeAnalysisFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNetworkInsightsAccessScopeAnalysisFindingsResponse> {
        public Builder networkInsightsAccessScopeAnalysisId(String var1);

        public Builder analysisStatus(String var1);

        public Builder analysisStatus(AnalysisStatus var1);

        public Builder analysisFindings(Collection<AccessScopeAnalysisFinding> var1);

        public Builder analysisFindings(AccessScopeAnalysisFinding ... var1);

        public Builder analysisFindings(Consumer<AccessScopeAnalysisFinding.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

