/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostsResponse;
import software.amazon.awssdk.services.ec2.model.Host;

public class DescribeHostsIterable
implements SdkIterable<DescribeHostsResponse> {
    private final Ec2Client client;
    private final DescribeHostsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeHostsIterable(Ec2Client client, DescribeHostsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeHostsResponseFetcher();
    }

    public Iterator<DescribeHostsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Host> hosts() {
        Function<DescribeHostsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hosts() != null) {
                return response.hosts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeHostsResponseFetcher
    implements SyncPageFetcher<DescribeHostsResponse> {
        private DescribeHostsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHostsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeHostsResponse nextPage(DescribeHostsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHostsIterable.this.client.describeHosts(DescribeHostsIterable.this.firstRequest);
            }
            return DescribeHostsIterable.this.client.describeHosts((DescribeHostsRequest)((Object)DescribeHostsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

