/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ArchitectureType;
import software.amazon.awssdk.services.ec2.model.ArchitectureTypeListCopier;
import software.amazon.awssdk.services.ec2.model.SupportedAdditionalProcessorFeature;
import software.amazon.awssdk.services.ec2.model.SupportedAdditionalProcessorFeatureListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessorInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessorInfo> {
    private static final SdkField<List<String>> SUPPORTED_ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedArchitectures").getter(ProcessorInfo.getter(ProcessorInfo::supportedArchitecturesAsStrings)).setter(ProcessorInfo.setter(Builder::supportedArchitecturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedArchitectures").unmarshallLocationName("supportedArchitectures").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Double> SUSTAINED_CLOCK_SPEED_IN_GHZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SustainedClockSpeedInGhz").getter(ProcessorInfo.getter(ProcessorInfo::sustainedClockSpeedInGhz)).setter(ProcessorInfo.setter(Builder::sustainedClockSpeedInGhz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SustainedClockSpeedInGhz").unmarshallLocationName("sustainedClockSpeedInGhz").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedFeatures").getter(ProcessorInfo.getter(ProcessorInfo::supportedFeaturesAsStrings)).setter(ProcessorInfo.setter(Builder::supportedFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedFeatures").unmarshallLocationName("supportedFeatures").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> MANUFACTURER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Manufacturer").getter(ProcessorInfo.getter(ProcessorInfo::manufacturer)).setter(ProcessorInfo.setter(Builder::manufacturer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manufacturer").unmarshallLocationName("manufacturer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_ARCHITECTURES_FIELD, SUSTAINED_CLOCK_SPEED_IN_GHZ_FIELD, SUPPORTED_FEATURES_FIELD, MANUFACTURER_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> supportedArchitectures;
    private final Double sustainedClockSpeedInGhz;
    private final List<String> supportedFeatures;
    private final String manufacturer;

    private ProcessorInfo(BuilderImpl builder) {
        this.supportedArchitectures = builder.supportedArchitectures;
        this.sustainedClockSpeedInGhz = builder.sustainedClockSpeedInGhz;
        this.supportedFeatures = builder.supportedFeatures;
        this.manufacturer = builder.manufacturer;
    }

    public final List<ArchitectureType> supportedArchitectures() {
        return ArchitectureTypeListCopier.copyStringToEnum(this.supportedArchitectures);
    }

    public final boolean hasSupportedArchitectures() {
        return this.supportedArchitectures != null && !(this.supportedArchitectures instanceof SdkAutoConstructList);
    }

    public final List<String> supportedArchitecturesAsStrings() {
        return this.supportedArchitectures;
    }

    public final Double sustainedClockSpeedInGhz() {
        return this.sustainedClockSpeedInGhz;
    }

    public final List<SupportedAdditionalProcessorFeature> supportedFeatures() {
        return SupportedAdditionalProcessorFeatureListCopier.copyStringToEnum(this.supportedFeatures);
    }

    public final boolean hasSupportedFeatures() {
        return this.supportedFeatures != null && !(this.supportedFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> supportedFeaturesAsStrings() {
        return this.supportedFeatures;
    }

    public final String manufacturer() {
        return this.manufacturer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedArchitectures() ? this.supportedArchitecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sustainedClockSpeedInGhz());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedFeatures() ? this.supportedFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessorInfo)) {
            return false;
        }
        ProcessorInfo other = (ProcessorInfo)obj;
        return this.hasSupportedArchitectures() == other.hasSupportedArchitectures() && Objects.equals(this.supportedArchitecturesAsStrings(), other.supportedArchitecturesAsStrings()) && Objects.equals(this.sustainedClockSpeedInGhz(), other.sustainedClockSpeedInGhz()) && this.hasSupportedFeatures() == other.hasSupportedFeatures() && Objects.equals(this.supportedFeaturesAsStrings(), other.supportedFeaturesAsStrings()) && Objects.equals(this.manufacturer(), other.manufacturer());
    }

    public final String toString() {
        return ToString.builder((String)"ProcessorInfo").add("SupportedArchitectures", this.hasSupportedArchitectures() ? this.supportedArchitecturesAsStrings() : null).add("SustainedClockSpeedInGhz", (Object)this.sustainedClockSpeedInGhz()).add("SupportedFeatures", this.hasSupportedFeatures() ? this.supportedFeaturesAsStrings() : null).add("Manufacturer", (Object)this.manufacturer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SupportedArchitectures": {
                return Optional.ofNullable(clazz.cast(this.supportedArchitecturesAsStrings()));
            }
            case "SustainedClockSpeedInGhz": {
                return Optional.ofNullable(clazz.cast(this.sustainedClockSpeedInGhz()));
            }
            case "SupportedFeatures": {
                return Optional.ofNullable(clazz.cast(this.supportedFeaturesAsStrings()));
            }
            case "Manufacturer": {
                return Optional.ofNullable(clazz.cast(this.manufacturer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessorInfo, T> g) {
        return obj -> g.apply((ProcessorInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> supportedArchitectures = DefaultSdkAutoConstructList.getInstance();
        private Double sustainedClockSpeedInGhz;
        private List<String> supportedFeatures = DefaultSdkAutoConstructList.getInstance();
        private String manufacturer;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessorInfo model) {
            this.supportedArchitecturesWithStrings(model.supportedArchitectures);
            this.sustainedClockSpeedInGhz(model.sustainedClockSpeedInGhz);
            this.supportedFeaturesWithStrings(model.supportedFeatures);
            this.manufacturer(model.manufacturer);
        }

        public final Collection<String> getSupportedArchitectures() {
            if (this.supportedArchitectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedArchitectures;
        }

        public final void setSupportedArchitectures(Collection<String> supportedArchitectures) {
            this.supportedArchitectures = ArchitectureTypeListCopier.copy(supportedArchitectures);
        }

        @Override
        public final Builder supportedArchitecturesWithStrings(Collection<String> supportedArchitectures) {
            this.supportedArchitectures = ArchitectureTypeListCopier.copy(supportedArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedArchitecturesWithStrings(String ... supportedArchitectures) {
            this.supportedArchitecturesWithStrings(Arrays.asList(supportedArchitectures));
            return this;
        }

        @Override
        public final Builder supportedArchitectures(Collection<ArchitectureType> supportedArchitectures) {
            this.supportedArchitectures = ArchitectureTypeListCopier.copyEnumToString(supportedArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedArchitectures(ArchitectureType ... supportedArchitectures) {
            this.supportedArchitectures(Arrays.asList(supportedArchitectures));
            return this;
        }

        public final Double getSustainedClockSpeedInGhz() {
            return this.sustainedClockSpeedInGhz;
        }

        public final void setSustainedClockSpeedInGhz(Double sustainedClockSpeedInGhz) {
            this.sustainedClockSpeedInGhz = sustainedClockSpeedInGhz;
        }

        @Override
        public final Builder sustainedClockSpeedInGhz(Double sustainedClockSpeedInGhz) {
            this.sustainedClockSpeedInGhz = sustainedClockSpeedInGhz;
            return this;
        }

        public final Collection<String> getSupportedFeatures() {
            if (this.supportedFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedFeatures;
        }

        public final void setSupportedFeatures(Collection<String> supportedFeatures) {
            this.supportedFeatures = SupportedAdditionalProcessorFeatureListCopier.copy(supportedFeatures);
        }

        @Override
        public final Builder supportedFeaturesWithStrings(Collection<String> supportedFeatures) {
            this.supportedFeatures = SupportedAdditionalProcessorFeatureListCopier.copy(supportedFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFeaturesWithStrings(String ... supportedFeatures) {
            this.supportedFeaturesWithStrings(Arrays.asList(supportedFeatures));
            return this;
        }

        @Override
        public final Builder supportedFeatures(Collection<SupportedAdditionalProcessorFeature> supportedFeatures) {
            this.supportedFeatures = SupportedAdditionalProcessorFeatureListCopier.copyEnumToString(supportedFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFeatures(SupportedAdditionalProcessorFeature ... supportedFeatures) {
            this.supportedFeatures(Arrays.asList(supportedFeatures));
            return this;
        }

        public final String getManufacturer() {
            return this.manufacturer;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public ProcessorInfo build() {
            return new ProcessorInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessorInfo> {
        public Builder supportedArchitecturesWithStrings(Collection<String> var1);

        public Builder supportedArchitecturesWithStrings(String ... var1);

        public Builder supportedArchitectures(Collection<ArchitectureType> var1);

        public Builder supportedArchitectures(ArchitectureType ... var1);

        public Builder sustainedClockSpeedInGhz(Double var1);

        public Builder supportedFeaturesWithStrings(Collection<String> var1);

        public Builder supportedFeaturesWithStrings(String ... var1);

        public Builder supportedFeatures(Collection<SupportedAdditionalProcessorFeature> var1);

        public Builder supportedFeatures(SupportedAdditionalProcessorFeature ... var1);

        public Builder manufacturer(String var1);
    }
}

