/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse;
import software.amazon.awssdk.services.ec2.waiters.Ec2AsyncWaiter;
import software.amazon.awssdk.services.ec2.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultEc2AsyncWaiter
implements Ec2AsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final Ec2AsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeInstancesResponse> instanceExistsWaiter;
    private final AsyncWaiter<DescribeBundleTasksResponse> bundleTaskCompleteWaiter;
    private final AsyncWaiter<DescribeConversionTasksResponse> conversionTaskCancelledWaiter;
    private final AsyncWaiter<DescribeConversionTasksResponse> conversionTaskCompletedWaiter;
    private final AsyncWaiter<DescribeConversionTasksResponse> conversionTaskDeletedWaiter;
    private final AsyncWaiter<DescribeCustomerGatewaysResponse> customerGatewayAvailableWaiter;
    private final AsyncWaiter<DescribeExportTasksResponse> exportTaskCancelledWaiter;
    private final AsyncWaiter<DescribeExportTasksResponse> exportTaskCompletedWaiter;
    private final AsyncWaiter<DescribeImagesResponse> imageExistsWaiter;
    private final AsyncWaiter<DescribeImagesResponse> imageAvailableWaiter;
    private final AsyncWaiter<DescribeInstancesResponse> instanceRunningWaiter;
    private final AsyncWaiter<DescribeInstanceStatusResponse> instanceStatusOkWaiter;
    private final AsyncWaiter<DescribeInstancesResponse> instanceStoppedWaiter;
    private final AsyncWaiter<DescribeInstancesResponse> instanceTerminatedWaiter;
    private final AsyncWaiter<DescribeInternetGatewaysResponse> internetGatewayExistsWaiter;
    private final AsyncWaiter<DescribeKeyPairsResponse> keyPairExistsWaiter;
    private final AsyncWaiter<DescribeNatGatewaysResponse> natGatewayAvailableWaiter;
    private final AsyncWaiter<DescribeNatGatewaysResponse> natGatewayDeletedWaiter;
    private final AsyncWaiter<DescribeNetworkInterfacesResponse> networkInterfaceAvailableWaiter;
    private final AsyncWaiter<GetPasswordDataResponse> passwordDataAvailableWaiter;
    private final AsyncWaiter<DescribeSnapshotsResponse> snapshotCompletedWaiter;
    private final AsyncWaiter<DescribeImportSnapshotTasksResponse> snapshotImportedWaiter;
    private final AsyncWaiter<DescribeSecurityGroupsResponse> securityGroupExistsWaiter;
    private final AsyncWaiter<DescribeSpotInstanceRequestsResponse> spotInstanceRequestFulfilledWaiter;
    private final AsyncWaiter<DescribeStoreImageTasksResponse> storeImageTaskCompleteWaiter;
    private final AsyncWaiter<DescribeSubnetsResponse> subnetAvailableWaiter;
    private final AsyncWaiter<DescribeInstanceStatusResponse> systemStatusOkWaiter;
    private final AsyncWaiter<DescribeVolumesResponse> volumeAvailableWaiter;
    private final AsyncWaiter<DescribeVolumesResponse> volumeDeletedWaiter;
    private final AsyncWaiter<DescribeVolumesResponse> volumeInUseWaiter;
    private final AsyncWaiter<DescribeVpcsResponse> vpcAvailableWaiter;
    private final AsyncWaiter<DescribeVpcsResponse> vpcExistsWaiter;
    private final AsyncWaiter<DescribeVpnConnectionsResponse> vpnConnectionAvailableWaiter;
    private final AsyncWaiter<DescribeVpnConnectionsResponse> vpnConnectionDeletedWaiter;
    private final AsyncWaiter<DescribeVpcPeeringConnectionsResponse> vpcPeeringConnectionExistsWaiter;
    private final AsyncWaiter<DescribeVpcPeeringConnectionsResponse> vpcPeeringConnectionDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultEc2AsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (Ec2AsyncClient)Ec2AsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.instanceExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInstancesResponse.class).acceptors(DefaultEc2AsyncWaiter.instanceExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.instanceExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.bundleTaskCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeBundleTasksResponse.class).acceptors(DefaultEc2AsyncWaiter.bundleTaskCompleteWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.bundleTaskCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.conversionTaskCancelledWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeConversionTasksResponse.class).acceptors(DefaultEc2AsyncWaiter.conversionTaskCancelledWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.conversionTaskCancelledWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.conversionTaskCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeConversionTasksResponse.class).acceptors(DefaultEc2AsyncWaiter.conversionTaskCompletedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.conversionTaskCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.conversionTaskDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeConversionTasksResponse.class).acceptors(DefaultEc2AsyncWaiter.conversionTaskDeletedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.conversionTaskDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.customerGatewayAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeCustomerGatewaysResponse.class).acceptors(DefaultEc2AsyncWaiter.customerGatewayAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.customerGatewayAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.exportTaskCancelledWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeExportTasksResponse.class).acceptors(DefaultEc2AsyncWaiter.exportTaskCancelledWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.exportTaskCancelledWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.exportTaskCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeExportTasksResponse.class).acceptors(DefaultEc2AsyncWaiter.exportTaskCompletedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.exportTaskCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.imageExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeImagesResponse.class).acceptors(DefaultEc2AsyncWaiter.imageExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.imageExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.imageAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeImagesResponse.class).acceptors(DefaultEc2AsyncWaiter.imageAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.imageAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.instanceRunningWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInstancesResponse.class).acceptors(DefaultEc2AsyncWaiter.instanceRunningWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.instanceRunningWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.instanceStatusOkWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInstanceStatusResponse.class).acceptors(DefaultEc2AsyncWaiter.instanceStatusOkWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.instanceStatusOkWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.instanceStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInstancesResponse.class).acceptors(DefaultEc2AsyncWaiter.instanceStoppedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.instanceStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.instanceTerminatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInstancesResponse.class).acceptors(DefaultEc2AsyncWaiter.instanceTerminatedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.instanceTerminatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.internetGatewayExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInternetGatewaysResponse.class).acceptors(DefaultEc2AsyncWaiter.internetGatewayExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.internetGatewayExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.keyPairExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeKeyPairsResponse.class).acceptors(DefaultEc2AsyncWaiter.keyPairExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.keyPairExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.natGatewayAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeNatGatewaysResponse.class).acceptors(DefaultEc2AsyncWaiter.natGatewayAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.natGatewayAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.natGatewayDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeNatGatewaysResponse.class).acceptors(DefaultEc2AsyncWaiter.natGatewayDeletedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.natGatewayDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.networkInterfaceAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeNetworkInterfacesResponse.class).acceptors(DefaultEc2AsyncWaiter.networkInterfaceAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.networkInterfaceAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.passwordDataAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetPasswordDataResponse.class).acceptors(DefaultEc2AsyncWaiter.passwordDataAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.passwordDataAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.snapshotCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeSnapshotsResponse.class).acceptors(DefaultEc2AsyncWaiter.snapshotCompletedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.snapshotCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.snapshotImportedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeImportSnapshotTasksResponse.class).acceptors(DefaultEc2AsyncWaiter.snapshotImportedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.snapshotImportedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.securityGroupExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeSecurityGroupsResponse.class).acceptors(DefaultEc2AsyncWaiter.securityGroupExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.securityGroupExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.spotInstanceRequestFulfilledWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeSpotInstanceRequestsResponse.class).acceptors(DefaultEc2AsyncWaiter.spotInstanceRequestFulfilledWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.spotInstanceRequestFulfilledWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.storeImageTaskCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeStoreImageTasksResponse.class).acceptors(DefaultEc2AsyncWaiter.storeImageTaskCompleteWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.storeImageTaskCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.subnetAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeSubnetsResponse.class).acceptors(DefaultEc2AsyncWaiter.subnetAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.subnetAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.systemStatusOkWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInstanceStatusResponse.class).acceptors(DefaultEc2AsyncWaiter.systemStatusOkWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.systemStatusOkWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.volumeAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVolumesResponse.class).acceptors(DefaultEc2AsyncWaiter.volumeAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.volumeAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.volumeDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVolumesResponse.class).acceptors(DefaultEc2AsyncWaiter.volumeDeletedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.volumeDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.volumeInUseWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVolumesResponse.class).acceptors(DefaultEc2AsyncWaiter.volumeInUseWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.volumeInUseWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.vpcAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVpcsResponse.class).acceptors(DefaultEc2AsyncWaiter.vpcAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.vpcAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.vpcExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVpcsResponse.class).acceptors(DefaultEc2AsyncWaiter.vpcExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.vpcExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.vpnConnectionAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVpnConnectionsResponse.class).acceptors(DefaultEc2AsyncWaiter.vpnConnectionAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.vpnConnectionAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.vpnConnectionDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVpnConnectionsResponse.class).acceptors(DefaultEc2AsyncWaiter.vpnConnectionDeletedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.vpnConnectionDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.vpcPeeringConnectionExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVpcPeeringConnectionsResponse.class).acceptors(DefaultEc2AsyncWaiter.vpcPeeringConnectionExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.vpcPeeringConnectionExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.vpcPeeringConnectionDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeVpcPeeringConnectionsResponse.class).acceptors(DefaultEc2AsyncWaiter.vpcPeeringConnectionDeletedWaiterAcceptors())).overrideConfiguration(DefaultEc2AsyncWaiter.vpcPeeringConnectionDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBundleTasksResponse>> waitUntilBundleTaskComplete(DescribeBundleTasksRequest describeBundleTasksRequest) {
        return this.bundleTaskCompleteWaiter.runAsync(() -> this.client.describeBundleTasks(this.applyWaitersUserAgent(describeBundleTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBundleTasksResponse>> waitUntilBundleTaskComplete(DescribeBundleTasksRequest describeBundleTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.bundleTaskCompleteWaiter.runAsync(() -> this.client.describeBundleTasks(this.applyWaitersUserAgent(describeBundleTasksRequest)), DefaultEc2AsyncWaiter.bundleTaskCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCancelled(DescribeConversionTasksRequest describeConversionTasksRequest) {
        return this.conversionTaskCancelledWaiter.runAsync(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCancelled(DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.conversionTaskCancelledWaiter.runAsync(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)), DefaultEc2AsyncWaiter.conversionTaskCancelledWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCompleted(DescribeConversionTasksRequest describeConversionTasksRequest) {
        return this.conversionTaskCompletedWaiter.runAsync(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskCompleted(DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.conversionTaskCompletedWaiter.runAsync(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)), DefaultEc2AsyncWaiter.conversionTaskCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskDeleted(DescribeConversionTasksRequest describeConversionTasksRequest) {
        return this.conversionTaskDeletedWaiter.runAsync(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeConversionTasksResponse>> waitUntilConversionTaskDeleted(DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.conversionTaskDeletedWaiter.runAsync(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)), DefaultEc2AsyncWaiter.conversionTaskDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeCustomerGatewaysResponse>> waitUntilCustomerGatewayAvailable(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {
        return this.customerGatewayAvailableWaiter.runAsync(() -> this.client.describeCustomerGateways(this.applyWaitersUserAgent(describeCustomerGatewaysRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeCustomerGatewaysResponse>> waitUntilCustomerGatewayAvailable(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.customerGatewayAvailableWaiter.runAsync(() -> this.client.describeCustomerGateways(this.applyWaitersUserAgent(describeCustomerGatewaysRequest)), DefaultEc2AsyncWaiter.customerGatewayAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCancelled(DescribeExportTasksRequest describeExportTasksRequest) {
        return this.exportTaskCancelledWaiter.runAsync(() -> this.client.describeExportTasks(this.applyWaitersUserAgent(describeExportTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCancelled(DescribeExportTasksRequest describeExportTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.exportTaskCancelledWaiter.runAsync(() -> this.client.describeExportTasks(this.applyWaitersUserAgent(describeExportTasksRequest)), DefaultEc2AsyncWaiter.exportTaskCancelledWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCompleted(DescribeExportTasksRequest describeExportTasksRequest) {
        return this.exportTaskCompletedWaiter.runAsync(() -> this.client.describeExportTasks(this.applyWaitersUserAgent(describeExportTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeExportTasksResponse>> waitUntilExportTaskCompleted(DescribeExportTasksRequest describeExportTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.exportTaskCompletedWaiter.runAsync(() -> this.client.describeExportTasks(this.applyWaitersUserAgent(describeExportTasksRequest)), DefaultEc2AsyncWaiter.exportTaskCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageAvailable(DescribeImagesRequest describeImagesRequest) {
        return this.imageAvailableWaiter.runAsync(() -> this.client.describeImages(this.applyWaitersUserAgent(describeImagesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageAvailable(DescribeImagesRequest describeImagesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageAvailableWaiter.runAsync(() -> this.client.describeImages(this.applyWaitersUserAgent(describeImagesRequest)), DefaultEc2AsyncWaiter.imageAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageExists(DescribeImagesRequest describeImagesRequest) {
        return this.imageExistsWaiter.runAsync(() -> this.client.describeImages(this.applyWaitersUserAgent(describeImagesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImagesResponse>> waitUntilImageExists(DescribeImagesRequest describeImagesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageExistsWaiter.runAsync(() -> this.client.describeImages(this.applyWaitersUserAgent(describeImagesRequest)), DefaultEc2AsyncWaiter.imageExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceExists(DescribeInstancesRequest describeInstancesRequest) {
        return this.instanceExistsWaiter.runAsync(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceExists(DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceExistsWaiter.runAsync(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)), DefaultEc2AsyncWaiter.instanceExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceRunning(DescribeInstancesRequest describeInstancesRequest) {
        return this.instanceRunningWaiter.runAsync(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceRunning(DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceRunningWaiter.runAsync(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)), DefaultEc2AsyncWaiter.instanceRunningWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilInstanceStatusOk(DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        return this.instanceStatusOkWaiter.runAsync(() -> this.client.describeInstanceStatus(this.applyWaitersUserAgent(describeInstanceStatusRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilInstanceStatusOk(DescribeInstanceStatusRequest describeInstanceStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceStatusOkWaiter.runAsync(() -> this.client.describeInstanceStatus(this.applyWaitersUserAgent(describeInstanceStatusRequest)), DefaultEc2AsyncWaiter.instanceStatusOkWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceStopped(DescribeInstancesRequest describeInstancesRequest) {
        return this.instanceStoppedWaiter.runAsync(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceStopped(DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceStoppedWaiter.runAsync(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)), DefaultEc2AsyncWaiter.instanceStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceTerminated(DescribeInstancesRequest describeInstancesRequest) {
        return this.instanceTerminatedWaiter.runAsync(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstancesResponse>> waitUntilInstanceTerminated(DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceTerminatedWaiter.runAsync(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)), DefaultEc2AsyncWaiter.instanceTerminatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInternetGatewaysResponse>> waitUntilInternetGatewayExists(DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {
        return this.internetGatewayExistsWaiter.runAsync(() -> this.client.describeInternetGateways(this.applyWaitersUserAgent(describeInternetGatewaysRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInternetGatewaysResponse>> waitUntilInternetGatewayExists(DescribeInternetGatewaysRequest describeInternetGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.internetGatewayExistsWaiter.runAsync(() -> this.client.describeInternetGateways(this.applyWaitersUserAgent(describeInternetGatewaysRequest)), DefaultEc2AsyncWaiter.internetGatewayExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeKeyPairsResponse>> waitUntilKeyPairExists(DescribeKeyPairsRequest describeKeyPairsRequest) {
        return this.keyPairExistsWaiter.runAsync(() -> this.client.describeKeyPairs(this.applyWaitersUserAgent(describeKeyPairsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeKeyPairsResponse>> waitUntilKeyPairExists(DescribeKeyPairsRequest describeKeyPairsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.keyPairExistsWaiter.runAsync(() -> this.client.describeKeyPairs(this.applyWaitersUserAgent(describeKeyPairsRequest)), DefaultEc2AsyncWaiter.keyPairExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayAvailable(DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        return this.natGatewayAvailableWaiter.runAsync(() -> this.client.describeNatGateways(this.applyWaitersUserAgent(describeNatGatewaysRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayAvailable(DescribeNatGatewaysRequest describeNatGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.natGatewayAvailableWaiter.runAsync(() -> this.client.describeNatGateways(this.applyWaitersUserAgent(describeNatGatewaysRequest)), DefaultEc2AsyncWaiter.natGatewayAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayDeleted(DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        return this.natGatewayDeletedWaiter.runAsync(() -> this.client.describeNatGateways(this.applyWaitersUserAgent(describeNatGatewaysRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNatGatewaysResponse>> waitUntilNatGatewayDeleted(DescribeNatGatewaysRequest describeNatGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.natGatewayDeletedWaiter.runAsync(() -> this.client.describeNatGateways(this.applyWaitersUserAgent(describeNatGatewaysRequest)), DefaultEc2AsyncWaiter.natGatewayDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNetworkInterfacesResponse>> waitUntilNetworkInterfaceAvailable(DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        return this.networkInterfaceAvailableWaiter.runAsync(() -> this.client.describeNetworkInterfaces(this.applyWaitersUserAgent(describeNetworkInterfacesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNetworkInterfacesResponse>> waitUntilNetworkInterfaceAvailable(DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.networkInterfaceAvailableWaiter.runAsync(() -> this.client.describeNetworkInterfaces(this.applyWaitersUserAgent(describeNetworkInterfacesRequest)), DefaultEc2AsyncWaiter.networkInterfaceAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPasswordDataResponse>> waitUntilPasswordDataAvailable(GetPasswordDataRequest getPasswordDataRequest) {
        return this.passwordDataAvailableWaiter.runAsync(() -> this.client.getPasswordData(this.applyWaitersUserAgent(getPasswordDataRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPasswordDataResponse>> waitUntilPasswordDataAvailable(GetPasswordDataRequest getPasswordDataRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.passwordDataAvailableWaiter.runAsync(() -> this.client.getPasswordData(this.applyWaitersUserAgent(getPasswordDataRequest)), DefaultEc2AsyncWaiter.passwordDataAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeSecurityGroupsResponse>> waitUntilSecurityGroupExists(DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        return this.securityGroupExistsWaiter.runAsync(() -> this.client.describeSecurityGroups(this.applyWaitersUserAgent(describeSecurityGroupsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeSecurityGroupsResponse>> waitUntilSecurityGroupExists(DescribeSecurityGroupsRequest describeSecurityGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.securityGroupExistsWaiter.runAsync(() -> this.client.describeSecurityGroups(this.applyWaitersUserAgent(describeSecurityGroupsRequest)), DefaultEc2AsyncWaiter.securityGroupExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeSnapshotsResponse>> waitUntilSnapshotCompleted(DescribeSnapshotsRequest describeSnapshotsRequest) {
        return this.snapshotCompletedWaiter.runAsync(() -> this.client.describeSnapshots(this.applyWaitersUserAgent(describeSnapshotsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeSnapshotsResponse>> waitUntilSnapshotCompleted(DescribeSnapshotsRequest describeSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.snapshotCompletedWaiter.runAsync(() -> this.client.describeSnapshots(this.applyWaitersUserAgent(describeSnapshotsRequest)), DefaultEc2AsyncWaiter.snapshotCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImportSnapshotTasksResponse>> waitUntilSnapshotImported(DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) {
        return this.snapshotImportedWaiter.runAsync(() -> this.client.describeImportSnapshotTasks(this.applyWaitersUserAgent(describeImportSnapshotTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImportSnapshotTasksResponse>> waitUntilSnapshotImported(DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.snapshotImportedWaiter.runAsync(() -> this.client.describeImportSnapshotTasks(this.applyWaitersUserAgent(describeImportSnapshotTasksRequest)), DefaultEc2AsyncWaiter.snapshotImportedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeSpotInstanceRequestsResponse>> waitUntilSpotInstanceRequestFulfilled(DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest) {
        return this.spotInstanceRequestFulfilledWaiter.runAsync(() -> this.client.describeSpotInstanceRequests(this.applyWaitersUserAgent(describeSpotInstanceRequestsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeSpotInstanceRequestsResponse>> waitUntilSpotInstanceRequestFulfilled(DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.spotInstanceRequestFulfilledWaiter.runAsync(() -> this.client.describeSpotInstanceRequests(this.applyWaitersUserAgent(describeSpotInstanceRequestsRequest)), DefaultEc2AsyncWaiter.spotInstanceRequestFulfilledWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStoreImageTasksResponse>> waitUntilStoreImageTaskComplete(DescribeStoreImageTasksRequest describeStoreImageTasksRequest) {
        return this.storeImageTaskCompleteWaiter.runAsync(() -> this.client.describeStoreImageTasks(this.applyWaitersUserAgent(describeStoreImageTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStoreImageTasksResponse>> waitUntilStoreImageTaskComplete(DescribeStoreImageTasksRequest describeStoreImageTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.storeImageTaskCompleteWaiter.runAsync(() -> this.client.describeStoreImageTasks(this.applyWaitersUserAgent(describeStoreImageTasksRequest)), DefaultEc2AsyncWaiter.storeImageTaskCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeSubnetsResponse>> waitUntilSubnetAvailable(DescribeSubnetsRequest describeSubnetsRequest) {
        return this.subnetAvailableWaiter.runAsync(() -> this.client.describeSubnets(this.applyWaitersUserAgent(describeSubnetsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeSubnetsResponse>> waitUntilSubnetAvailable(DescribeSubnetsRequest describeSubnetsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.subnetAvailableWaiter.runAsync(() -> this.client.describeSubnets(this.applyWaitersUserAgent(describeSubnetsRequest)), DefaultEc2AsyncWaiter.subnetAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilSystemStatusOk(DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        return this.systemStatusOkWaiter.runAsync(() -> this.client.describeInstanceStatus(this.applyWaitersUserAgent(describeInstanceStatusRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInstanceStatusResponse>> waitUntilSystemStatusOk(DescribeInstanceStatusRequest describeInstanceStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.systemStatusOkWaiter.runAsync(() -> this.client.describeInstanceStatus(this.applyWaitersUserAgent(describeInstanceStatusRequest)), DefaultEc2AsyncWaiter.systemStatusOkWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeAvailable(DescribeVolumesRequest describeVolumesRequest) {
        return this.volumeAvailableWaiter.runAsync(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeAvailable(DescribeVolumesRequest describeVolumesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.volumeAvailableWaiter.runAsync(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)), DefaultEc2AsyncWaiter.volumeAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeDeleted(DescribeVolumesRequest describeVolumesRequest) {
        return this.volumeDeletedWaiter.runAsync(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeDeleted(DescribeVolumesRequest describeVolumesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.volumeDeletedWaiter.runAsync(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)), DefaultEc2AsyncWaiter.volumeDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeInUse(DescribeVolumesRequest describeVolumesRequest) {
        return this.volumeInUseWaiter.runAsync(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVolumesResponse>> waitUntilVolumeInUse(DescribeVolumesRequest describeVolumesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.volumeInUseWaiter.runAsync(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)), DefaultEc2AsyncWaiter.volumeInUseWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcAvailable(DescribeVpcsRequest describeVpcsRequest) {
        return this.vpcAvailableWaiter.runAsync(() -> this.client.describeVpcs(this.applyWaitersUserAgent(describeVpcsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcAvailable(DescribeVpcsRequest describeVpcsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpcAvailableWaiter.runAsync(() -> this.client.describeVpcs(this.applyWaitersUserAgent(describeVpcsRequest)), DefaultEc2AsyncWaiter.vpcAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcExists(DescribeVpcsRequest describeVpcsRequest) {
        return this.vpcExistsWaiter.runAsync(() -> this.client.describeVpcs(this.applyWaitersUserAgent(describeVpcsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpcsResponse>> waitUntilVpcExists(DescribeVpcsRequest describeVpcsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpcExistsWaiter.runAsync(() -> this.client.describeVpcs(this.applyWaitersUserAgent(describeVpcsRequest)), DefaultEc2AsyncWaiter.vpcExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionDeleted(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        return this.vpcPeeringConnectionDeletedWaiter.runAsync(() -> this.client.describeVpcPeeringConnections(this.applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionDeleted(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpcPeeringConnectionDeletedWaiter.runAsync(() -> this.client.describeVpcPeeringConnections(this.applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)), DefaultEc2AsyncWaiter.vpcPeeringConnectionDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionExists(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        return this.vpcPeeringConnectionExistsWaiter.runAsync(() -> this.client.describeVpcPeeringConnections(this.applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpcPeeringConnectionsResponse>> waitUntilVpcPeeringConnectionExists(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpcPeeringConnectionExistsWaiter.runAsync(() -> this.client.describeVpcPeeringConnections(this.applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)), DefaultEc2AsyncWaiter.vpcPeeringConnectionExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionAvailable(DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        return this.vpnConnectionAvailableWaiter.runAsync(() -> this.client.describeVpnConnections(this.applyWaitersUserAgent(describeVpnConnectionsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionAvailable(DescribeVpnConnectionsRequest describeVpnConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpnConnectionAvailableWaiter.runAsync(() -> this.client.describeVpnConnections(this.applyWaitersUserAgent(describeVpnConnectionsRequest)), DefaultEc2AsyncWaiter.vpnConnectionAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionDeleted(DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        return this.vpnConnectionDeletedWaiter.runAsync(() -> this.client.describeVpnConnections(this.applyWaitersUserAgent(describeVpnConnectionsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeVpnConnectionsResponse>> waitUntilVpnConnectionDeleted(DescribeVpnConnectionsRequest describeVpnConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpnConnectionDeletedWaiter.runAsync(() -> this.client.describeVpnConnections(this.applyWaitersUserAgent(describeVpnConnectionsRequest)), DefaultEc2AsyncWaiter.vpnConnectionDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Reservations").flatten().length().compare(">", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidInstanceID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBundleTasksResponse>> bundleTaskCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBundleTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBundleTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("BundleTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "complete"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("BundleTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (BundleTasks[].State=failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeConversionTasksResponse>> conversionTaskCancelledWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "cancelled"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeConversionTasksResponse>> conversionTaskCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "cancelled"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ConversionTasks[].State=cancelled) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "cancelling"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ConversionTasks[].State=cancelling) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeConversionTasksResponse>> conversionTaskDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeCustomerGatewaysResponse>> customerGatewayAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeCustomerGatewaysResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeCustomerGatewaysResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CustomerGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CustomerGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CustomerGateways[].State=deleted) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CustomerGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CustomerGateways[].State=deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeExportTasksResponse>> exportTaskCancelledWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeExportTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeExportTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ExportTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "cancelled"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeExportTasksResponse>> exportTaskCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeExportTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeExportTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ExportTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImagesResponse>> imageExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImagesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImagesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Images").flatten().length().compare(">", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidAMIID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImagesResponse>> imageAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImagesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImagesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Images").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Images").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Images[].State=failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "running"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "shutting-down"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=shutting-down) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "terminated"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=terminated) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopping"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=stopping) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidInstanceID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstanceStatusResponse>> instanceStatusOkWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstanceStatusResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstanceStatusResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("InstanceStatuses").flatten().field("InstanceStatus").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "ok"));
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidInstanceID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "stopped"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "pending"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=pending) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "terminated"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=terminated) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceTerminatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "terminated"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "pending"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=pending) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopping"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=stopping) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInternetGatewaysResponse>> internetGatewayExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInternetGatewaysResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInternetGatewaysResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("InternetGateways").flatten().field("InternetGatewayId").length().compare(">", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidInternetGateway.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeKeyPairsResponse>> keyPairExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeKeyPairsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeKeyPairsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("KeyPairs").flatten().field("KeyName").length().compare(">", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidKeyPair.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNatGatewaysResponse>> natGatewayAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNatGatewaysResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNatGatewaysResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (NatGateways[].State=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (NatGateways[].State=deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (NatGateways[].State=deleted) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "NatGatewayNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNatGatewaysResponse>> natGatewayDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNatGatewaysResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNatGatewaysResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "NatGatewayNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNetworkInterfacesResponse>> networkInterfaceAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNetworkInterfacesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNetworkInterfacesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NetworkInterfaces").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidNetworkInterfaceID.NotFound"), (String)"A waiter acceptor was matched on error condition (InvalidNetworkInterfaceID.NotFound) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPasswordDataResponse>> passwordDataAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPasswordDataResponse>> result = new ArrayList<WaiterAcceptor<? super GetPasswordDataResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("PasswordData").length().compare(">", input.constant(0)).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSnapshotsResponse>> snapshotCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "error"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Snapshots[].State=error) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImportSnapshotTasksResponse>> snapshotImportedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImportSnapshotTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImportSnapshotTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ImportSnapshotTasks").flatten().field("SnapshotTaskDetail").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ImportSnapshotTasks").flatten().field("SnapshotTaskDetail").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "error"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ImportSnapshotTasks[].SnapshotTaskDetail.Status=error) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSecurityGroupsResponse>> securityGroupExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeSecurityGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeSecurityGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("SecurityGroups").flatten().field("GroupId").length().compare(">", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidGroup.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSpotInstanceRequestsResponse>> spotInstanceRequestFulfilledWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeSpotInstanceRequestsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeSpotInstanceRequestsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "fulfilled"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "request-canceled-and-instance-running"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "schedule-expired"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=schedule-expired) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "canceled-before-fulfillment"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=canceled-before-fulfillment) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "bad-parameters"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=bad-parameters) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "system-error"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=system-error) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidSpotInstanceRequestID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStoreImageTasksResponse>> storeImageTaskCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStoreImageTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStoreImageTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("StoreImageTaskResults").flatten().field("StoreTaskState").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("StoreImageTaskResults").flatten().field("StoreTaskState").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "Failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (StoreImageTaskResults[].StoreTaskState=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("StoreImageTaskResults").flatten().field("StoreTaskState").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "InProgress"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSubnetsResponse>> subnetAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeSubnetsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeSubnetsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Subnets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstanceStatusResponse>> systemStatusOkWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstanceStatusResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstanceStatusResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("InstanceStatuses").flatten().field("SystemStatus").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "ok"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVolumesResponse>> volumeAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Volumes[].State=deleted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVolumesResponse>> volumeDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidVolume.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVolumesResponse>> volumeInUseWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "in-use"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Volumes[].State=deleted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcsResponse>> vpcAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpcsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpcsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Vpcs").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcsResponse>> vpcExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpcsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpcsResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidVpcID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> vpnConnectionAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpnConnectionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (VpnConnections[].State=deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (VpnConnections[].State=deleted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> vpnConnectionDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpnConnectionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "pending"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (VpnConnections[].State=pending) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> vpcPeeringConnectionExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidVpcPeeringConnectionID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> vpcPeeringConnectionDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpcPeeringConnections").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEc2AsyncWaiter.errorCode(error), "InvalidVpcPeeringConnectionID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration instanceExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration bundleTaskCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration conversionTaskCancelledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration conversionTaskCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration conversionTaskDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration customerGatewayAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration exportTaskCancelledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration exportTaskCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceStatusOkWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceTerminatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration internetGatewayExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(6);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration keyPairExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(6);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration natGatewayAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration natGatewayDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration networkInterfaceAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(10);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration passwordDataAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration snapshotCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration snapshotImportedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration securityGroupExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(6);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration spotInstanceRequestFulfilledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration storeImageTaskCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration subnetAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration systemStatusOkWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration volumeAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration volumeDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration volumeInUseWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpnConnectionAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpnConnectionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcPeeringConnectionExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcPeeringConnectionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static Ec2AsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends Ec2Request> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Ec2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements Ec2AsyncWaiter.Builder {
        private Ec2AsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public Ec2AsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public Ec2AsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public Ec2AsyncWaiter.Builder client(Ec2AsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public Ec2AsyncWaiter build() {
            return new DefaultEc2AsyncWaiter(this);
        }
    }
}

