/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLogOptionsSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLogOptionsSpecification> {
    private static final SdkField<Boolean> LOG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("LogEnabled").getter(CloudWatchLogOptionsSpecification.getter(CloudWatchLogOptionsSpecification::logEnabled)).setter(CloudWatchLogOptionsSpecification.setter(Builder::logEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogEnabled").unmarshallLocationName("LogEnabled").build()}).build();
    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroupArn").getter(CloudWatchLogOptionsSpecification.getter(CloudWatchLogOptionsSpecification::logGroupArn)).setter(CloudWatchLogOptionsSpecification.setter(Builder::logGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupArn").unmarshallLocationName("LogGroupArn").build()}).build();
    private static final SdkField<String> LOG_OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogOutputFormat").getter(CloudWatchLogOptionsSpecification.getter(CloudWatchLogOptionsSpecification::logOutputFormat)).setter(CloudWatchLogOptionsSpecification.setter(Builder::logOutputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogOutputFormat").unmarshallLocationName("LogOutputFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_ENABLED_FIELD, LOG_GROUP_ARN_FIELD, LOG_OUTPUT_FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean logEnabled;
    private final String logGroupArn;
    private final String logOutputFormat;

    private CloudWatchLogOptionsSpecification(BuilderImpl builder) {
        this.logEnabled = builder.logEnabled;
        this.logGroupArn = builder.logGroupArn;
        this.logOutputFormat = builder.logOutputFormat;
    }

    public final Boolean logEnabled() {
        return this.logEnabled;
    }

    public final String logGroupArn() {
        return this.logGroupArn;
    }

    public final String logOutputFormat() {
        return this.logOutputFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logOutputFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogOptionsSpecification)) {
            return false;
        }
        CloudWatchLogOptionsSpecification other = (CloudWatchLogOptionsSpecification)obj;
        return Objects.equals(this.logEnabled(), other.logEnabled()) && Objects.equals(this.logGroupArn(), other.logGroupArn()) && Objects.equals(this.logOutputFormat(), other.logOutputFormat());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchLogOptionsSpecification").add("LogEnabled", (Object)this.logEnabled()).add("LogGroupArn", (Object)this.logGroupArn()).add("LogOutputFormat", (Object)this.logOutputFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogEnabled": {
                return Optional.ofNullable(clazz.cast(this.logEnabled()));
            }
            case "LogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.logGroupArn()));
            }
            case "LogOutputFormat": {
                return Optional.ofNullable(clazz.cast(this.logOutputFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogOptionsSpecification, T> g) {
        return obj -> g.apply((CloudWatchLogOptionsSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean logEnabled;
        private String logGroupArn;
        private String logOutputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogOptionsSpecification model) {
            this.logEnabled(model.logEnabled);
            this.logGroupArn(model.logGroupArn);
            this.logOutputFormat(model.logOutputFormat);
        }

        public final Boolean getLogEnabled() {
            return this.logEnabled;
        }

        public final void setLogEnabled(Boolean logEnabled) {
            this.logEnabled = logEnabled;
        }

        @Override
        public final Builder logEnabled(Boolean logEnabled) {
            this.logEnabled = logEnabled;
            return this;
        }

        public final String getLogGroupArn() {
            return this.logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public final String getLogOutputFormat() {
            return this.logOutputFormat;
        }

        public final void setLogOutputFormat(String logOutputFormat) {
            this.logOutputFormat = logOutputFormat;
        }

        @Override
        public final Builder logOutputFormat(String logOutputFormat) {
            this.logOutputFormat = logOutputFormat;
            return this;
        }

        public CloudWatchLogOptionsSpecification build() {
            return new CloudWatchLogOptionsSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLogOptionsSpecification> {
        public Builder logEnabled(Boolean var1);

        public Builder logGroupArn(String var1);

        public Builder logOutputFormat(String var1);
    }
}

