/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.AttributeValue;
import software.amazon.awssdk.services.ec2.model.ConnectionTrackingSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.EnaSrdSpecification;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachmentChanges;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyNetworkInterfaceAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyNetworkInterfaceAttributeRequest> {
    private static final SdkField<NetworkInterfaceAttachmentChanges> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::attachment)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::attachment)).constructor(NetworkInterfaceAttachmentChanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").unmarshallLocationName("attachment").build()}).build();
    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Description").getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::description)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::description)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::dryRun)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::groups)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::networkInterfaceId)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<AttributeBooleanValue> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDestCheck").getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::sourceDestCheck)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::sourceDestCheck)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final SdkField<EnaSrdSpecification> ENA_SRD_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnaSrdSpecification").getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::enaSrdSpecification)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::enaSrdSpecification)).constructor(EnaSrdSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdSpecification").unmarshallLocationName("EnaSrdSpecification").build()}).build();
    private static final SdkField<Boolean> ENABLE_PRIMARY_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePrimaryIpv6").getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::enablePrimaryIpv6)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::enablePrimaryIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrimaryIpv6").unmarshallLocationName("EnablePrimaryIpv6").build()}).build();
    private static final SdkField<ConnectionTrackingSpecificationRequest> CONNECTION_TRACKING_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionTrackingSpecification").getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::connectionTrackingSpecification)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::connectionTrackingSpecification)).constructor(ConnectionTrackingSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTrackingSpecification").unmarshallLocationName("ConnectionTrackingSpecification").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress").getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::associatePublicIpAddress)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").unmarshallLocationName("AssociatePublicIpAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD, GROUPS_FIELD, NETWORK_INTERFACE_ID_FIELD, SOURCE_DEST_CHECK_FIELD, ENA_SRD_SPECIFICATION_FIELD, ENABLE_PRIMARY_IPV6_FIELD, CONNECTION_TRACKING_SPECIFICATION_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD));
    private final NetworkInterfaceAttachmentChanges attachment;
    private final AttributeValue description;
    private final Boolean dryRun;
    private final List<String> groups;
    private final String networkInterfaceId;
    private final AttributeBooleanValue sourceDestCheck;
    private final EnaSrdSpecification enaSrdSpecification;
    private final Boolean enablePrimaryIpv6;
    private final ConnectionTrackingSpecificationRequest connectionTrackingSpecification;
    private final Boolean associatePublicIpAddress;

    private ModifyNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.groups = builder.groups;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.enaSrdSpecification = builder.enaSrdSpecification;
        this.enablePrimaryIpv6 = builder.enablePrimaryIpv6;
        this.connectionTrackingSpecification = builder.connectionTrackingSpecification;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
    }

    public final NetworkInterfaceAttachmentChanges attachment() {
        return this.attachment;
    }

    public final AttributeValue description() {
        return this.description;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final AttributeBooleanValue sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public final EnaSrdSpecification enaSrdSpecification() {
        return this.enaSrdSpecification;
    }

    public final Boolean enablePrimaryIpv6() {
        return this.enablePrimaryIpv6;
    }

    public final ConnectionTrackingSpecificationRequest connectionTrackingSpecification() {
        return this.connectionTrackingSpecification;
    }

    public final Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSrdSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePrimaryIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTrackingSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyNetworkInterfaceAttributeRequest)) {
            return false;
        }
        ModifyNetworkInterfaceAttributeRequest other = (ModifyNetworkInterfaceAttributeRequest)((Object)obj);
        return Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.enaSrdSpecification(), other.enaSrdSpecification()) && Objects.equals(this.enablePrimaryIpv6(), other.enablePrimaryIpv6()) && Objects.equals(this.connectionTrackingSpecification(), other.connectionTrackingSpecification()) && Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyNetworkInterfaceAttributeRequest").add("Attachment", (Object)this.attachment()).add("Description", (Object)this.description()).add("DryRun", (Object)this.dryRun()).add("Groups", this.hasGroups() ? this.groups() : null).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("EnaSrdSpecification", (Object)this.enaSrdSpecification()).add("EnablePrimaryIpv6", (Object)this.enablePrimaryIpv6()).add("ConnectionTrackingSpecification", (Object)this.connectionTrackingSpecification()).add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "EnaSrdSpecification": {
                return Optional.ofNullable(clazz.cast(this.enaSrdSpecification()));
            }
            case "EnablePrimaryIpv6": {
                return Optional.ofNullable(clazz.cast(this.enablePrimaryIpv6()));
            }
            case "ConnectionTrackingSpecification": {
                return Optional.ofNullable(clazz.cast(this.connectionTrackingSpecification()));
            }
            case "AssociatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyNetworkInterfaceAttributeRequest, T> g) {
        return obj -> g.apply((ModifyNetworkInterfaceAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private NetworkInterfaceAttachmentChanges attachment;
        private AttributeValue description;
        private Boolean dryRun;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;
        private AttributeBooleanValue sourceDestCheck;
        private EnaSrdSpecification enaSrdSpecification;
        private Boolean enablePrimaryIpv6;
        private ConnectionTrackingSpecificationRequest connectionTrackingSpecification;
        private Boolean associatePublicIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyNetworkInterfaceAttributeRequest model) {
            super(model);
            this.attachment(model.attachment);
            this.description(model.description);
            this.dryRun(model.dryRun);
            this.groups(model.groups);
            this.networkInterfaceId(model.networkInterfaceId);
            this.sourceDestCheck(model.sourceDestCheck);
            this.enaSrdSpecification(model.enaSrdSpecification);
            this.enablePrimaryIpv6(model.enablePrimaryIpv6);
            this.connectionTrackingSpecification(model.connectionTrackingSpecification);
            this.associatePublicIpAddress(model.associatePublicIpAddress);
        }

        public final NetworkInterfaceAttachmentChanges.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(NetworkInterfaceAttachmentChanges.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachmentChanges attachment) {
            this.attachment = attachment;
            return this;
        }

        public final AttributeValue.Builder getDescription() {
            return this.description != null ? this.description.toBuilder() : null;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final AttributeBooleanValue.Builder getSourceDestCheck() {
            return this.sourceDestCheck != null ? this.sourceDestCheck.toBuilder() : null;
        }

        public final void setSourceDestCheck(AttributeBooleanValue.BuilderImpl sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck != null ? sourceDestCheck.build() : null;
        }

        @Override
        public final Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final EnaSrdSpecification.Builder getEnaSrdSpecification() {
            return this.enaSrdSpecification != null ? this.enaSrdSpecification.toBuilder() : null;
        }

        public final void setEnaSrdSpecification(EnaSrdSpecification.BuilderImpl enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification != null ? enaSrdSpecification.build() : null;
        }

        @Override
        public final Builder enaSrdSpecification(EnaSrdSpecification enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification;
            return this;
        }

        public final Boolean getEnablePrimaryIpv6() {
            return this.enablePrimaryIpv6;
        }

        public final void setEnablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
        }

        @Override
        public final Builder enablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
            return this;
        }

        public final ConnectionTrackingSpecificationRequest.Builder getConnectionTrackingSpecification() {
            return this.connectionTrackingSpecification != null ? this.connectionTrackingSpecification.toBuilder() : null;
        }

        public final void setConnectionTrackingSpecification(ConnectionTrackingSpecificationRequest.BuilderImpl connectionTrackingSpecification) {
            this.connectionTrackingSpecification = connectionTrackingSpecification != null ? connectionTrackingSpecification.build() : null;
        }

        @Override
        public final Builder connectionTrackingSpecification(ConnectionTrackingSpecificationRequest connectionTrackingSpecification) {
            this.connectionTrackingSpecification = connectionTrackingSpecification;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyNetworkInterfaceAttributeRequest build() {
            return new ModifyNetworkInterfaceAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyNetworkInterfaceAttributeRequest> {
        public Builder attachment(NetworkInterfaceAttachmentChanges var1);

        default public Builder attachment(Consumer<NetworkInterfaceAttachmentChanges.Builder> attachment) {
            return this.attachment((NetworkInterfaceAttachmentChanges)((NetworkInterfaceAttachmentChanges.Builder)NetworkInterfaceAttachmentChanges.builder().applyMutation(attachment)).build());
        }

        public Builder description(AttributeValue var1);

        default public Builder description(Consumer<AttributeValue.Builder> description) {
            return this.description((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(description)).build());
        }

        public Builder dryRun(Boolean var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder sourceDestCheck(AttributeBooleanValue var1);

        default public Builder sourceDestCheck(Consumer<AttributeBooleanValue.Builder> sourceDestCheck) {
            return this.sourceDestCheck((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(sourceDestCheck)).build());
        }

        public Builder enaSrdSpecification(EnaSrdSpecification var1);

        default public Builder enaSrdSpecification(Consumer<EnaSrdSpecification.Builder> enaSrdSpecification) {
            return this.enaSrdSpecification((EnaSrdSpecification)((EnaSrdSpecification.Builder)EnaSrdSpecification.builder().applyMutation(enaSrdSpecification)).build());
        }

        public Builder enablePrimaryIpv6(Boolean var1);

        public Builder connectionTrackingSpecification(ConnectionTrackingSpecificationRequest var1);

        default public Builder connectionTrackingSpecification(Consumer<ConnectionTrackingSpecificationRequest.Builder> connectionTrackingSpecification) {
            return this.connectionTrackingSpecification((ConnectionTrackingSpecificationRequest)((ConnectionTrackingSpecificationRequest.Builder)ConnectionTrackingSpecificationRequest.builder().applyMutation(connectionTrackingSpecification)).build());
        }

        public Builder associatePublicIpAddress(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

