/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVerifiedAccessGroupRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVerifiedAccessGroupRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessGroupId").getter(ModifyVerifiedAccessGroupRequest.getter(ModifyVerifiedAccessGroupRequest::verifiedAccessGroupId)).setter(ModifyVerifiedAccessGroupRequest.setter(Builder::verifiedAccessGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId").unmarshallLocationName("VerifiedAccessGroupId").build()}).build();
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessInstanceId").getter(ModifyVerifiedAccessGroupRequest.getter(ModifyVerifiedAccessGroupRequest::verifiedAccessInstanceId)).setter(ModifyVerifiedAccessGroupRequest.setter(Builder::verifiedAccessInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId").unmarshallLocationName("VerifiedAccessInstanceId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyVerifiedAccessGroupRequest.getter(ModifyVerifiedAccessGroupRequest::description)).setter(ModifyVerifiedAccessGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ModifyVerifiedAccessGroupRequest.getter(ModifyVerifiedAccessGroupRequest::clientToken)).setter(ModifyVerifiedAccessGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVerifiedAccessGroupRequest.getter(ModifyVerifiedAccessGroupRequest::dryRun)).setter(ModifyVerifiedAccessGroupRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_GROUP_ID_FIELD, VERIFIED_ACCESS_INSTANCE_ID_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD));
    private final String verifiedAccessGroupId;
    private final String verifiedAccessInstanceId;
    private final String description;
    private final String clientToken;
    private final Boolean dryRun;

    private ModifyVerifiedAccessGroupRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
    }

    public final String verifiedAccessGroupId() {
        return this.verifiedAccessGroupId;
    }

    public final String verifiedAccessInstanceId() {
        return this.verifiedAccessInstanceId;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessGroupRequest)) {
            return false;
        }
        ModifyVerifiedAccessGroupRequest other = (ModifyVerifiedAccessGroupRequest)((Object)obj);
        return Objects.equals(this.verifiedAccessGroupId(), other.verifiedAccessGroupId()) && Objects.equals(this.verifiedAccessInstanceId(), other.verifiedAccessInstanceId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVerifiedAccessGroupRequest").add("VerifiedAccessGroupId", (Object)this.verifiedAccessGroupId()).add("VerifiedAccessInstanceId", (Object)this.verifiedAccessInstanceId()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessGroupId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessGroupId()));
            }
            case "VerifiedAccessInstanceId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessInstanceId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessGroupRequest, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String verifiedAccessGroupId;
        private String verifiedAccessInstanceId;
        private String description;
        private String clientToken;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessGroupRequest model) {
            super(model);
            this.verifiedAccessGroupId(model.verifiedAccessGroupId);
            this.verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
        }

        public final String getVerifiedAccessGroupId() {
            return this.verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVerifiedAccessGroupRequest build() {
            return new ModifyVerifiedAccessGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVerifiedAccessGroupRequest> {
        public Builder verifiedAccessGroupId(String var1);

        public Builder verifiedAccessInstanceId(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

